/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.dispatchorder;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.common.util.DispatchOrderUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DispatchOrderUnSubmitPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("sync");
        fieldKeys.add("customer");
        fieldKeys.add("owner");
        fieldKeys.add("itementry.item");
        fieldKeys.add("itementry.unit");
        fieldKeys.add("itementry.qty");
        fieldKeys.add("itementry.sourceentryid");
        fieldKeys.add("itementry.sourcebillid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        for (int i = 0; i < datas.length; ++i) {
            datas[i].set("orderstatus", (Object)DispatchOrderStatus.TEMP_SAVE.getFlagStr());
            datas[i].set("sync", (Object)DispatchOrderSyncStatus.NO_SYNC.getFlagStr());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "unaudit": {
                this.handleUnSubmit(datas);
                this.handleAfterUnAudit(datas);
                break;
            }
            case "unsubmit": {
                this.handleUnSubmit(datas);
            }
        }
    }

    private void handleAfterUnAudit(DynamicObject[] datas) {
        for (int i = 0; i < datas.length; ++i) {
            this.unWriteQty(datas[i]);
        }
    }

    private void handleUnSubmit(DynamicObject[] datas) {
        for (DynamicObject order : datas) {
            DispatchOrderUtil.reverseHandleStoreForward((DynamicObject)order);
        }
    }

    private void unWriteQty(DynamicObject data) {
        DynamicObjectCollection entry = data.getDynamicObjectCollection("itementry");
        BigDecimal qty = null;
        BigDecimal allotedQty = null;
        Object sourceEntryId = null;
        Object sourceBillId = null;
        DynamicObject cartItem = null;
        for (DynamicObject tow : entry) {
            if (sourceBillId == null) {
                sourceBillId = tow.get("sourcebillid");
            }
            qty = tow.getBigDecimal("qty");
            sourceEntryId = tow.get("sourceentryid");
            cartItem = BusinessDataServiceHelper.loadSingle((Object)sourceEntryId, (String)"mdr_saleorder_entry");
            allotedQty = cartItem.getBigDecimal("allotedqty");
            qty = allotedQty.subtract(qty);
            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u5df2\u914d\u8d27\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (String)"DispatchOrderUnSubmitPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            cartItem.set("allotedqty", (Object)qty);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartItem});
        }
        DynamicObject order = BusinessDataServiceHelper.loadSingle(sourceBillId, (String)"mdr_saleorder");
        if (SysParamsUtil.isDispatch()) {
            DispatchOrderHandler.reHandleSaleOrderStatus((DynamicObject)order);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
    }
}

