/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.evaluate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemEvaluateOperatPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("item");
        keys.add("ordernumber");
        keys.add("orderentryid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        block12: for (DynamicObject itemEvaluate : dataEntities) {
            switch (operationKey) {
                case "submit": {
                    this.setOrderEntryEvaluateStatus(itemEvaluate, "1");
                    continue block12;
                }
                case "audit": {
                    this.addItemEvaQty(itemEvaluate);
                    continue block12;
                }
                case "unsubmit": {
                    this.reduceItemEvaQty(itemEvaluate);
                    continue block12;
                }
                case "unaudit": {
                    this.setOrderEntryEvaluateStatus(itemEvaluate, "0");
                    this.reduceItemEvaQty(itemEvaluate);
                    continue block12;
                }
            }
        }
    }

    private void reduceItemEvaQty(DynamicObject itemEvaluate) {
        DynamicObject itemObj = itemEvaluate.getDynamicObject("item");
        DynamicObject itemEvaQty = BusinessDataServiceHelper.loadSingle((Object)itemObj.get("id"), (String)"mdr_item_info", (String)"evaluateqty");
        int evaqty = itemEvaQty.getInt("evaluateqty");
        if (evaqty > 0) {
            --evaqty;
        }
        itemEvaQty.set("evaluateqty", (Object)evaqty);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemEvaQty});
    }

    private void addItemEvaQty(DynamicObject itemEvaluate) {
        DynamicObject itemObj = itemEvaluate.getDynamicObject("item");
        DynamicObject itemEvaQty = BusinessDataServiceHelper.loadSingle((Object)itemObj.get("id"), (String)"mdr_item_info", (String)"evaluateqty");
        int evaqty = itemEvaQty.getInt("evaluateqty");
        itemEvaQty.set("evaluateqty", (Object)(evaqty + 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemEvaQty});
    }

    private void setOrderEntryEvaluateStatus(DynamicObject itemEvaluate, String evaluateStatus) {
        String orderentryid = itemEvaluate.getString("orderentryid");
        Object orderId = itemEvaluate.getDynamicObject("ordernumber").get("id");
        QFilter qFilter = new QFilter("id", "=", orderId);
        DynamicObject order = BusinessDataServiceHelper.loadSingle((String)"dpa_purorder", (String)"id,billno,itementry.isevaluate,itementry.item,itementry", (QFilter[])qFilter.toArray());
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : itemEntry) {
            String entryId = entry.get("id").toString();
            if (!entryId.equals(orderentryid)) continue;
            entry.set("isevaluate", (Object)evaluateStatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
    }
}

