/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemPriceChangeOpPlugin
extends MdrBaseOperationServicePlugIn {
    private static final String OWNER = "owner";
    private static final String ITEM_PRICE = "itemprice";
    private static final String NEW_PRICE = "newprice";
    private static final String OLD_PRICE = "oldprice";
    private static final String PRICE_FLOAT = "pricefloat";
    private static final String NEW_LOWPRICE = "newlowprice";
    private static final String OLD_LOWPRICE = "oldlowprice";
    private static final String LOWPRICE_FLOAT = "lowpricefloat";
    private static final String F7_ITEM = "item";
    private static final String F7_UNIT = "unit";
    private static final String F7_ASSISTATTR = "assistattr";
    private static final String ENTRY = "entrys";
    private static final String STATUS = "status";
    private static String[] fields = new String[]{"id", "number", "status", "entrys", "entrys.itemprice", "entrys.item", "entrys.unit", "entrys.assistattr", "entrys.newprice", "entrys.oldprice", "entrys.pricefloat", "entrys.newlowprice", "entrys.oldlowprice", "entrys.lowpricefloat", "approverid", "approvetime", "modifierid", "modifytime"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList(fields));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opString = e.getOperationKey();
        Object[] objs = e.getDataEntities();
        switch (opString) {
            case "save": {
                this.saveCheck((DynamicObject[])objs);
                break;
            }
            case "modify": {
                for (Object obj : objs) {
                    if ("1".equals(obj.get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ItemPriceChangeOpPlugin_11", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "delete": {
                for (Object obj : objs) {
                    if ("1".equals((obj = this.getPriceChangeStatus((DynamicObject)obj)).get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"ItemPriceChangeOpPlugin_12", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "submit": {
                for (Object obj : objs) {
                    if ("1".equals((obj = this.getPriceChangeStatus((DynamicObject)obj)).get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ItemPriceChangeOpPlugin_13", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                break;
            }
            case "unsubmit": {
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                for (Object obj : objs) {
                    if ("2".equals((obj = this.getPriceChangeStatus((DynamicObject)obj)).get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u9500\u3002", (String)"ItemPriceChangeOpPlugin_14", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "audit": {
                for (Object obj : objs) {
                    if ("2".equals((obj = this.getPriceChangeStatus((DynamicObject)obj)).get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ItemPriceChangeOpPlugin_15", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "unaudit": {
                for (Object obj : objs) {
                    if ("3".equals((obj = this.getPriceChangeStatus((DynamicObject)obj)).get(STATUS))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ItemPriceChangeOpPlugin_16", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                break;
            }
        }
    }

    private void saveCheck(DynamicObject[] dataEntities) {
        UnitBatchHandler unitBatchHandler = this.getUnitBatchHandler();
        unitBatchHandler.batchLoad(this.getAllItemId(dataEntities));
        List unitIdList = null;
        for (DynamicObject itemPrice : dataEntities) {
            DynamicObject owner = itemPrice.getDynamicObject(OWNER);
            DynamicObjectCollection entrys = itemPrice.getDynamicObjectCollection(ENTRY);
            if (owner == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeOpPlugin_17", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (entrys == null || entrys.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeOpPlugin_18", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject entry : entrys) {
                DynamicObject item = entry.getDynamicObject(F7_ITEM);
                DynamicObject unit = entry.getDynamicObject(F7_UNIT);
                if (item == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeOpPlugin_19", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                if (unit == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceChangeOpPlugin_20", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                unitIdList = unitBatchHandler.getUnitIdList(item.getPkValue());
                if (!unitIdList.contains(unit.getPkValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u5f53\u524d\u5355\u4f4d\u3002", (String)"ItemPriceChangeOpPlugin_21", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                DynamicObject assistattr = entry.getDynamicObject(F7_ASSISTATTR);
                BizValidateUtils.itemAttrValidate((Object)item.get("id"), (DynamicObject)assistattr);
            }
        }
    }

    private Set<Object> getAllItemId(DynamicObject[] dataEntities) {
        HashSet<Object> ids = new HashSet<Object>(dataEntities.length);
        DynamicObjectCollection entrys = null;
        for (DynamicObject itemPrice : dataEntities) {
            entrys = itemPrice.getDynamicObjectCollection(ENTRY);
            for (DynamicObject entry : entrys) {
                ids.add(entry.getDynamicObject(F7_ITEM).getPkValue());
            }
        }
        return ids;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opString = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (opString) {
            case "save": {
                if (!"0".equals(objs[0].get(STATUS))) break;
                objs[0].set(STATUS, (Object)"1");
                break;
            }
            case "submit": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i].set(STATUS, (Object)"2");
                }
                break;
            }
            case "unsubmit": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i].set(STATUS, (Object)"1");
                }
                break;
            }
            case "audit": {
                this.saveChange(objs);
                break;
            }
            case "unaudit": {
                this.deleteChange(objs);
                break;
            }
        }
    }

    private DynamicObject[] saveChange(DynamicObject[] objs) {
        ArrayList<DynamicObject> changeList = null;
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject billObject;
            objs[i] = billObject = this.getPriceChange(objs[i]);
            Object ownerId = billObject.getDynamicObject(OWNER).getPkValue();
            DynamicObjectCollection entrys = (DynamicObjectCollection)billObject.get(ENTRY);
            changeList = new ArrayList<DynamicObject>(entrys.size());
            DynamicObject newChange = null;
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entry = (DynamicObject)entrys.get(j);
                DynamicObject entryPrice = this.getItemPriceByEntry(entry, ownerId);
                if (entryPrice != null) {
                    entry.set(ITEM_PRICE, (Object)entryPrice);
                    newChange = this.addChangeRecord(entry, entryPrice, billObject.getPkValue());
                    if (newChange != null) {
                        changeList.add(newChange);
                    }
                    BigDecimal oldPrice = entryPrice.getBigDecimal("saleprice");
                    BigDecimal oldLowprice = entryPrice.getBigDecimal("lowprice");
                    entry.set(OLD_PRICE, (Object)oldPrice);
                    entry.set(OLD_LOWPRICE, (Object)oldLowprice);
                    if (entry.getBigDecimal(NEW_PRICE) != null && oldPrice != null) {
                        entry.set(PRICE_FLOAT, (Object)entry.getBigDecimal(NEW_PRICE).subtract(oldPrice));
                    }
                    if (entry.getBigDecimal(NEW_LOWPRICE) == null || oldLowprice == null) continue;
                    entry.set(LOWPRICE_FLOAT, (Object)entry.getBigDecimal(NEW_LOWPRICE).subtract(oldLowprice));
                    continue;
                }
                this.addItemPrice(entry, billObject);
            }
            if (changeList.size() > 0) {
                DynamicObject[] newChanges = new DynamicObject[changeList.size()];
                for (int j = 0; j < changeList.size(); ++j) {
                    newChanges[j] = (DynamicObject)changeList.get(j);
                }
                SaveServiceHelper.save((DynamicObject[])newChanges);
            }
            objs[i].set(STATUS, (Object)"3");
            objs[i].set("approverid", (Object)UserServiceHelper.getCurrentUserId());
            objs[i].set("approvetime", (Object)new Date());
        }
        return objs;
    }

    private DynamicObject getItemPriceByEntry(DynamicObject entry, Object ownerPK) {
        Object itemPK = entry.getDynamicObject(F7_ITEM).get("id");
        Object unitPK = entry.getDynamicObject(F7_UNIT).get("id");
        Object assistAttrPK = 0L;
        DynamicObject assistAttr = entry.getDynamicObject(F7_ASSISTATTR);
        if (assistAttr != null) {
            assistAttrPK = assistAttr.get("id");
        }
        QFilter filters = new QFilter("itemid", "=", itemPK);
        filters.and(F7_UNIT, "=", unitPK);
        filters.and(F7_ASSISTATTR, "=", assistAttrPK);
        filters.and(new QFilter("customer", "=", ownerPK));
        String selectField = "id,name,number,saleprice,lowprice,status";
        DynamicObject price = BusinessDataServiceHelper.loadSingle((String)"mdr_item_price", (String)selectField, (QFilter[])filters.toArray());
        return price;
    }

    private DynamicObject addChangeRecord(DynamicObject entry, DynamicObject entryPrice, Object billPk) {
        DynamicObject itemPrice = BusinessDataServiceHelper.loadSingle((Object)entryPrice.getPkValue(), (String)"mdr_item_price");
        itemPrice.set("saleprice", entry.get(NEW_PRICE));
        itemPrice.set("lowprice", entry.get(NEW_LOWPRICE));
        if (!"1".equals(itemPrice.getString(STATUS))) {
            itemPrice.set(STATUS, (Object)"1");
            itemPrice.set("changecount", (Object)0);
            SaveServiceHelper.save((IDataEntityType)itemPrice.getDataEntityType(), (Object[])new DynamicObject[]{itemPrice});
            return null;
        }
        itemPrice.set("changecount", (Object)(itemPrice.getInt("changecount") + 1));
        SaveServiceHelper.save((IDataEntityType)itemPrice.getDataEntityType(), (Object[])new DynamicObject[]{itemPrice});
        DynamicObject newChange = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_changerecord");
        newChange.set("effectprice", entry.get(NEW_PRICE));
        newChange.set("historyprice", entryPrice.get("saleprice"));
        newChange.set("itempriceid", entry.get(ITEM_PRICE));
        newChange.set("rowstatus", (Object)"1");
        newChange.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        newChange.set("modifytime", (Object)new Date());
        newChange.set("auditfier", (Object)UserServiceHelper.getCurrentUserId());
        newChange.set("audittime", (Object)new Date());
        newChange.set("pricechangeid", billPk);
        QFilter f2 = new QFilter("itempriceid", "=", entryPrice.getPkValue());
        String orderBys = "modifytime desc";
        DynamicObject[] oldChange = BusinessDataServiceHelper.load((String)"mdr_item_changerecord", (String)"id,rowstatus", (QFilter[])new QFilter[]{f2}, (String)orderBys, (int)1);
        if (oldChange.length > 0) {
            oldChange[0].set("rowstatus", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])oldChange);
        }
        return newChange;
    }

    private DynamicObject addItemPrice(DynamicObject entry, DynamicObject billObject) {
        Object ownerId = billObject.getDynamicObject(OWNER).getPkValue();
        DynamicObject entryItem = entry.getDynamicObject(F7_ITEM);
        DynamicObject entryUnit = entry.getDynamicObject(F7_UNIT);
        DynamicObject entryAssistAttr = entry.getDynamicObject(F7_ASSISTATTR);
        Object entryAssistAttrPk = 0L;
        if (entryAssistAttr != null) {
            entryAssistAttrPk = entryAssistAttr.get("id");
        }
        DynamicObject oldPrice = PriceUtil.getPriceDynamicObject((Object)entryItem.getPkValue(), (Object)entryUnit.getPkValue(), (Object)entryAssistAttrPk, (Object)ownerId);
        DynamicObject newPrice = null;
        if (oldPrice == null) {
            newPrice = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_price");
            newPrice.set("itemid", (Object)entryItem);
            newPrice.set("saleprice", entry.get(NEW_PRICE));
            newPrice.set("lowprice", entry.get(NEW_LOWPRICE));
            newPrice.set(STATUS, (Object)1);
            newPrice.set(F7_UNIT, (Object)entryUnit);
            newPrice.set(F7_ASSISTATTR, (Object)entryAssistAttr);
            newPrice.set("customer", ownerId);
        } else {
            oldPrice.set(STATUS, (Object)1);
            newPrice = oldPrice;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPrice});
        entry.set(ITEM_PRICE, (Object)newPrice);
        return newPrice;
    }

    private DynamicObject[] deleteChange(DynamicObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject billObject;
            objs[i] = billObject = this.getPriceChange(objs[i]);
            DynamicObjectCollection entrys = (DynamicObjectCollection)billObject.get(ENTRY);
            this.deleteChangeRecord(billObject);
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entryPrice = (DynamicObject)((DynamicObject)entrys.get(j)).get(ITEM_PRICE);
                DynamicObject entryItem = ((DynamicObject)entrys.get(j)).getDynamicObject(F7_ITEM);
                DynamicObject entryUnit = ((DynamicObject)entrys.get(j)).getDynamicObject(F7_UNIT);
                DynamicObject entryAssistAttr = ((DynamicObject)entrys.get(j)).getDynamicObject(F7_ASSISTATTR);
                if (entryPrice != null) {
                    QFilter f2 = new QFilter("itempriceid", "=", entryPrice.getPkValue());
                    String orderBys = "modifytime desc";
                    Object[] oldChange = BusinessDataServiceHelper.load((String)"mdr_item_changerecord", (String)"id,rowstatus", (QFilter[])new QFilter[]{f2}, (String)orderBys, (int)1);
                    if (oldChange.length <= 0) continue;
                    oldChange[0].set("rowstatus", (Object)"1");
                    SaveServiceHelper.save((IDataEntityType)oldChange[0].getDataEntityType(), (Object[])oldChange);
                    continue;
                }
                this.unAuditPrice(entryItem, entryUnit, entryAssistAttr, billObject);
            }
            objs[i].set(STATUS, (Object)1);
            objs[i].set("approverid", null);
            objs[i].set("approvetime", null);
        }
        return objs;
    }

    private void deleteChangeRecord(DynamicObject billObject) {
        QFilter f = new QFilter("pricechangeid", "=", billObject.getPkValue());
        String str = "id,historyprice,effectprice,rowstatus,itempriceid,pricechangeid";
        DynamicObject[] changeRecord = BusinessDataServiceHelper.load((String)"mdr_item_changerecord", (String)str, (QFilter[])new QFilter[]{f});
        Object[] pks = new Object[changeRecord.length];
        for (int j = 0; j < changeRecord.length; ++j) {
            DynamicObject itemPrice = (DynamicObject)changeRecord[j].get("itempriceid");
            itemPrice = BusinessDataServiceHelper.loadSingle((Object)itemPrice.getPkValue(), (String)"mdr_item_price");
            itemPrice.set("saleprice", changeRecord[j].get("historyprice"));
            itemPrice.set("changecount", (Object)(itemPrice.getInt("changecount") - 1));
            SaveServiceHelper.save((IDataEntityType)itemPrice.getDataEntityType(), (Object[])new DynamicObject[]{itemPrice});
            pks[j] = changeRecord[j].getPkValue();
        }
        DeleteServiceHelper.delete((IDataEntityType)changeRecord[0].getDataEntityType(), (Object[])pks);
    }

    private void unAuditPrice(DynamicObject entryItem, DynamicObject entryUnit, DynamicObject entryAssistAttr, DynamicObject billObject) {
        DynamicObject oldPrice;
        Object ownerId = billObject.get(OWNER);
        Object assistAttrPK = 0L;
        if (entryAssistAttr != null) {
            assistAttrPK = entryAssistAttr.get("id");
        }
        if ((oldPrice = PriceUtil.getPriceDynamicObject((Object)entryItem.getPkValue(), (Object)entryUnit.getPkValue(), (Object)assistAttrPK, (Object)ownerId)) != null) {
            QFilter f2 = new QFilter("itempriceid", "=", oldPrice.getPkValue());
            oldPrice.set(STATUS, (Object)0);
            DynamicObject[] oldChanges = BusinessDataServiceHelper.load((String)"mdr_item_changerecord", (String)"id", (QFilter[])f2.toArray());
            if (oldChanges != null && oldChanges.length > 0) {
                HashSet<Object> values = new HashSet<Object>(oldChanges.length);
                for (DynamicObject oldChange : oldChanges) {
                    values.add(oldChange.getPkValue());
                }
                DeleteServiceHelper.delete((IDataEntityType)oldChanges[0].getDataEntityType(), (Object[])values.toArray());
            }
            SaveServiceHelper.save((IDataEntityType)oldPrice.getDataEntityType(), (Object[])new DynamicObject[]{oldPrice});
        }
    }

    private DynamicObject getPriceChangeStatus(DynamicObject obj) {
        return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"mdr_item_pricechange", (String)"id,number,status");
    }

    private DynamicObject getPriceChange(DynamicObject obj) {
        return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"mdr_item_pricechange");
    }
}

