/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.item;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemPriceOpPlugin
extends MdrBaseOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opString = e.getOperationKey();
        List selectRows = e.getValidExtDataEntities();
        DynamicObject dataEntity = null;
        StringBuilder indexStr = new StringBuilder();
        int rowIndex = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (opString) {
            case "save": {
                this.saveCheck(e.getValidExtDataEntities());
                break;
            }
            case "delete": {
                for (ExtendedDataEntity selectRow : selectRows) {
                    rowIndex = selectRow.getRowIndex() + 1;
                    dataEntity = selectRow.getDataEntity();
                    map.put("id", dataEntity.getPkValue());
                    dataEntity = ORMUtil.queryOneByPro((String)"mdr_item_price", (String)"status", map);
                    if ("0".equals(dataEntity.get("status"))) continue;
                    indexStr.append(rowIndex);
                    indexStr.append(rowIndex == selectRows.size() ? "" : ",");
                }
                if (indexStr.toString().isEmpty()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u4e2d\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u8bb0\u5f55,\u4e0d\u80fd\u5220\u9664\u4ef7\u683c\u3002", (String)"ItemPriceOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            case "customaudit": {
                LinkedList<DynamicObject> needAuditDatas = new LinkedList<DynamicObject>();
                for (ExtendedDataEntity selectRow : selectRows) {
                    dataEntity = selectRow.getDataEntity();
                    map.put("id", dataEntity.getPkValue());
                    if (this.auditCheck(dataEntity, map)) continue;
                    needAuditDatas.add(dataEntity);
                }
                if (needAuditDatas.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u5ba1\u6838\u6761\u4ef6\u7684\u6570\u636e", (String)"ItemPriceOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                DynamicObject[] objects = needAuditDatas.toArray(new DynamicObject[needAuditDatas.size()]);
                OperationUtil.invokeOperation((DynamicObject[])objects, (String)"audit");
                break;
            }
            case "audit": {
                break;
            }
            case "unaudit": {
                for (ExtendedDataEntity selectRow : selectRows) {
                    dataEntity = selectRow.getDataEntity();
                    rowIndex = selectRow.getRowIndex() + 1;
                    map.put("id", dataEntity.getPkValue());
                    dataEntity = ORMUtil.queryOneByPro((String)"mdr_item_price", (String)"status,changecount", map);
                    if (!"1".equals(dataEntity.get("status"))) {
                        indexStr.append(rowIndex);
                        indexStr.append(rowIndex == selectRows.size() ? "" : ",");
                    }
                    if (dataEntity.getInt("changecount") <= 0) continue;
                    indexStr.append(rowIndex);
                    indexStr.append(rowIndex == selectRows.size() ? "" : ",");
                }
                if (!indexStr.toString().isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u4e2d\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u975e\u5ba1\u6838\u72b6\u6001\u6216\u5df2\u6709\u53d8\u66f4\u8bb0\u5f55\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u4ef7\u683c\u3002", (String)"ItemPriceOpPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
            }
            case "disable": {
                boolean haveDisable = false;
                for (ExtendedDataEntity selectRow : selectRows) {
                    dataEntity = selectRow.getDataEntity();
                    rowIndex = selectRow.getRowIndex() + 1;
                    map.put("id", dataEntity.getPkValue());
                    dataEntity = ORMUtil.queryOneByPro((String)"mdr_item_price", (String)"status", map);
                    if (!"1".equals(dataEntity.get("status"))) {
                        indexStr.append(rowIndex);
                        indexStr.append(rowIndex == selectRows.size() ? "" : ",");
                    }
                    if (!"2".equals(dataEntity.get("status"))) continue;
                    haveDisable = true;
                }
                if (indexStr.toString().isEmpty()) break;
                if (haveDisable) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u662f\u7981\u7528\u72b6\u6001\u3002", (String)"ItemPriceOpPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u4e2d\u7684\u8bb0\u5f55\u4e2d\u5305\u542b\u975e\u5ba1\u6838\u72b6\u6001\u7684\u8bb0\u5f55\uff0c\u4e0d\u80fd\u7981\u7528\u4ef7\u683c\u3002", (String)"ItemPriceOpPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            case "enable": {
                boolean haveAble = false;
                for (ExtendedDataEntity selectRow : selectRows) {
                    dataEntity = selectRow.getDataEntity();
                    rowIndex = selectRow.getRowIndex() + 1;
                    map.put("id", dataEntity.getPkValue());
                    dataEntity = ORMUtil.queryOneByPro((String)"mdr_item_price", (String)"status", map);
                    if (!"2".equals(dataEntity.get("status"))) {
                        indexStr.append(rowIndex);
                        indexStr.append(rowIndex == selectRows.size() ? "" : ",");
                    }
                    if (!"1".equals(dataEntity.get("status"))) continue;
                    haveAble = true;
                }
                if (indexStr.toString().isEmpty()) break;
                if (haveAble) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u662f\u542f\u7528\u72b6\u6001\u3002", (String)"ItemPriceOpPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u8bb0\u5f55\u624d\u80fd\u88ab\u542f\u7528\u3002", (String)"ItemPriceOpPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void saveCheck(List<ExtendedDataEntity> list) {
        UnitBatchHandler unitBatchHandler = this.getUnitBatchHandler();
        unitBatchHandler.batchLoad(this.getAllItemId(list));
        List unitIdList = null;
        for (ExtendedDataEntity data : list) {
            DynamicObject itemPrice = data.getDataEntity();
            DynamicObject item = itemPrice.getDynamicObject("itemid");
            DynamicObject unit = itemPrice.getDynamicObject("unit");
            DynamicObject customer = itemPrice.getDynamicObject("customer");
            if (customer == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceOpPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceOpPlugin_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (unit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemPriceOpPlugin_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            unitIdList = unitBatchHandler.getUnitIdList(item.getPkValue());
            if (!unitIdList.contains(unit.getPkValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u5f53\u524d\u5355\u4f4d\u3002", (String)"ItemPriceOpPlugin_8", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            DynamicObject assistAttr = (DynamicObject)itemPrice.get("assistattr");
            BizValidateUtils.itemAttrValidate((Object)item.get("id"), (DynamicObject)assistAttr);
        }
    }

    private Set<Object> getAllItemId(List<ExtendedDataEntity> list) {
        HashSet<Object> ids = new HashSet<Object>(list.size());
        DynamicObject itemPrice = null;
        for (ExtendedDataEntity data : list) {
            itemPrice = data.getDataEntity();
            ids.add(itemPrice.getDynamicObject("itemid").getPkValue());
        }
        return ids;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opString = e.getOperationKey();
        Object[] objs = e.getDataEntities();
        switch (opString) {
            case "audit": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.getPriceStatus(objs[i]);
                    objs[i].set("status", (Object)1);
                }
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                break;
            }
            case "unaudit": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.getPriceStatus((DynamicObject)objs[i]);
                    objs[i].set("status", (Object)0);
                }
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                break;
            }
            case "disable": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.getPriceStatus((DynamicObject)objs[i]);
                    objs[i].set("status", (Object)2);
                }
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                break;
            }
            case "enable": {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.getPriceStatus((DynamicObject)objs[i]);
                    objs[i].set("status", (Object)1);
                }
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                break;
            }
        }
    }

    private boolean auditCheck(DynamicObject dataEntity, Map<String, Object> map) {
        dataEntity = ORMUtil.queryOneByPro((String)"mdr_item_price", (String)"status,saleprice", map);
        BigDecimal saleprice = (BigDecimal)dataEntity.get("saleprice");
        return !"0".equals(dataEntity.get("status")) || saleprice.compareTo(BigDecimal.ZERO) == 0;
    }

    private DynamicObject getPriceStatus(DynamicObject obj) {
        return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"mdr_item_price", (String)"id,status");
    }
}

