/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.item;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.validator.BatchFastValidator;

public class ItemPricePolicySaveValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        this.savecheck(datas);
        this.repetitioncheck(datas);
    }

    public void submit(ExtendedDataEntity[] datas) {
        this.repetitioncheck(datas);
    }

    private void savecheck(ExtendedDataEntity[] datas) {
        DynamicObject pricePolicy = null;
        ExtendedDataEntity data = null;
        List unitIdList = null;
        for (int i = 0; i < this.dataEntities.length; ++i) {
            data = datas[i];
            pricePolicy = data.getDataEntity();
            DynamicObject owner = pricePolicy.getDynamicObject("owner");
            DynamicObject customer = pricePolicy.getDynamicObject("customer");
            DynamicObject region = pricePolicy.getDynamicObject("region");
            DynamicObject item = pricePolicy.getDynamicObject("item");
            DynamicObject unit = pricePolicy.getDynamicObject("unit");
            DynamicObject assistAttr = pricePolicy.getDynamicObject("assistattr");
            Integer itemqtyfrom = pricePolicy.getInt("qtyfrom");
            Integer itemqtyto = pricePolicy.getInt("qtyto");
            BigDecimal itemprice = pricePolicy.getBigDecimal("price");
            BigDecimal itemminprice = pricePolicy.getBigDecimal("lowestprice");
            Date begindate = pricePolicy.getDate("begindate");
            Date enddate = pricePolicy.getDate("enddate");
            if (owner == null) {
                this.addFatalErrorMessage(data, "\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                continue;
            }
            Object ownerid = owner.get("id");
            if (customer != null && !CustomerUtil.isAuthRelation((Object)ownerid, (Object)customer.get("id"))) {
                this.addFatalErrorMessage(data, String.format("\u9500\u552e\u6e20\u9053\u3010%s\u3011\u8ddf\u8ba2\u8d27\u6e20\u9053\u3010%s\u3011\u4e0d\u5b58\u5728\u8ba2\u8d27\u5173\u7cfb\u3002", owner.getString("number"), customer.getString("number")));
                continue;
            }
            if (region != null && !BizValidateUtils.isRegionOwner((Object)region.get("id"), (Object)ownerid)) {
                this.addFatalErrorMessage(data, "\u5f53\u524d\u533a\u57df\u4e0d\u5c5e\u4e8e\u5f52\u5c5e\u6e20\u9053\u3002");
                continue;
            }
            if (item == null) {
                this.addFatalErrorMessage(data, "\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                continue;
            }
            if (unit == null) {
                this.addFatalErrorMessage(data, "\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                continue;
            }
            UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
            unitIdList = unitBatchHandler.getUnitIdList(item.getPkValue());
            if (!unitIdList.contains(unit.getPkValue())) {
                this.addFatalErrorMessage(data, "\u5546\u54c1\u6ca1\u6709\u5f53\u524d\u5355\u4f4d\u3002");
                continue;
            }
            BizValidateUtils.itemAttrValidate((Object)item.get("id"), (DynamicObject)assistAttr);
            if (BigDecimal.ZERO.compareTo(itemprice) == 0) {
                this.addFatalErrorMessage(data, "\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0\u3002");
                continue;
            }
            if (begindate == null || enddate == null) {
                this.addFatalErrorMessage(data, "\u751f\u6548\u65e5\u671f\u6216\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                continue;
            }
            if (begindate.after(enddate)) {
                this.addFatalErrorMessage(data, "\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\u3002");
                continue;
            }
            if ((itemqtyfrom > 0 || itemqtyto > 0) && itemqtyfrom > itemqtyto && itemqtyto != 0) {
                this.addFatalErrorMessage(data, "\u9500\u552e\u91cf\uff08\u5230\uff09\u987b\u5927\u4e8e\u9500\u552e\u91cf\uff08\u4ece\uff09\u3002");
                continue;
            }
            if (BigDecimal.ZERO.compareTo(itemminprice) >= 0 || itemprice.compareTo(itemminprice) >= 0) continue;
            this.addFatalErrorMessage(data, "\u6700\u4f4e\u9650\u4ef7\u4e0d\u80fd\u5927\u4e8e\u4ef7\u683c\u3002");
        }
    }

    private void repetitioncheck(ExtendedDataEntity[] datas) {
        DynamicObject pricePolicy = null;
        ExtendedDataEntity data = null;
        for (int i = 0; i < datas.length; ++i) {
            data = datas[i];
            pricePolicy = data.getDataEntity();
            DynamicObject owner = pricePolicy.getDynamicObject("owner");
            DynamicObject customergroup = pricePolicy.getDynamicObject("customergroup");
            DynamicObject customer = pricePolicy.getDynamicObject("customer");
            Integer priority = pricePolicy.getInt("priority");
            DynamicObject region = pricePolicy.getDynamicObject("region");
            DynamicObject item = pricePolicy.getDynamicObject("item");
            DynamicObject unit = pricePolicy.getDynamicObject("unit");
            DynamicObject assistAttr = pricePolicy.getDynamicObject("assistattr");
            Integer itemqtyfrom = pricePolicy.getInt("qtyfrom");
            Integer itemqtyto = pricePolicy.getInt("qtyto");
            Date begindate = pricePolicy.getDate("begindate");
            Date enddate = pricePolicy.getDate("enddate");
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(enddate);
            cal2.set(11, 23);
            cal2.set(12, 59);
            cal2.set(13, 59);
            enddate = cal2.getTime();
            QFilter qFilter = new QFilter("id", "!=", pricePolicy.get("id")).and("owner", "=", owner.getPkValue()).and("customergroup", "=", customergroup == null ? Integer.valueOf(0) : customergroup.getPkValue()).and("customer", "=", customer == null ? Integer.valueOf(0) : customer.getPkValue()).and("priority", "=", (Object)priority).and("region", "=", region == null ? Integer.valueOf(0) : region.getPkValue()).and("item", "=", item == null ? Integer.valueOf(0) : item.getPkValue()).and("unit", "=", unit == null ? Integer.valueOf(0) : unit.getPkValue()).and("assistattr", "=", assistAttr == null ? Integer.valueOf(0) : assistAttr.getPkValue()).and("qtyfrom", "=", (Object)itemqtyfrom).and("qtyto", "=", (Object)itemqtyto).and("begindate", "=", (Object)begindate).and("enddate", "=", (Object)enddate);
            if (!QueryServiceHelper.exists((String)"mdr_price_policy", (QFilter[])qFilter.toArray())) continue;
            this.addFatalErrorMessage(data, "\u5df2\u5b58\u5728\u76f8\u540c\u6570\u636e\u7684\u4ef7\u683c\u653f\u7b56\u3002");
        }
    }
}

