/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.item;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ItempriceImportOp
implements IImportPlugin {
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        try {
            ArrayList<String> errormsgs = new ArrayList<String>();
            JSONObject owner = (JSONObject)data.get("owner");
            JSONObject customer = (JSONObject)data.get("customer");
            JSONObject customergroup = (JSONObject)data.get("customergroup");
            JSONObject item = (JSONObject)data.get("item");
            errormsgs.addAll(this.checkOwner(owner, "\u9500\u552e"));
            errormsgs.addAll(this.checkCustomerAndItsType(customer, customergroup));
            errormsgs.addAll(this.checkitem(item));
            if (errormsgs.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String msg : errormsgs) {
                    sb.append(msg);
                }
                throw new KDBizException(sb.toString());
            }
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private List<String> checkCustomerAndItsType(JSONObject customer, JSONObject customergroup) throws KDBizException {
        ArrayList<String> re = new ArrayList<String>();
        if (null != customer && null == customergroup) {
            re.addAll(this.checkOwner(customer, "\u8ba2\u8d27"));
            return re;
        }
        if (null == customer && null != customergroup) {
            re.addAll(this.checkCustomerTpye(customergroup));
        }
        return re;
    }

    private List<String> checkOwner(JSONObject owner, String type) throws KDBizException {
        ArrayList<String> re = new ArrayList<String>();
        String number = owner.getString("number");
        String name = owner.getString("name");
        if (number.isEmpty()) {
            String tip = ResManager.loadKDString((String)String.format("%s\u6e20\u9053\u7684\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\r\n", type), (String)"ItempriceImportOp_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
            return re;
        }
        DynamicObject ownernum = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"name", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (ownernum == null) {
            String tip = ResManager.loadKDString((String)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u76f8\u5173\u6e20\u9053\u4fe1\u606f\r\n", number), (String)"ItempriceImportOp_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
            return re;
        }
        if (!(name.isEmpty() || ownernum.getString("name").isEmpty() || name.equals(ownernum.getString("name")))) {
            String tip = ResManager.loadKDString((String)String.format("\u7f16\u53f7\u4e3a%s\u7684%s\u6e20\u9053\u7f16\u7801\u4e0e\u6e20\u9053\u540d\u79f0\u4e3a%s\u6821\u9a8c\u5931\u8d25\r\n", number, type, name), (String)"ItempriceImportOp_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
        }
        return re;
    }

    private List<String> checkCustomerTpye(JSONObject customergroup) {
        String tip;
        ArrayList<String> re = new ArrayList<String>();
        String number = customergroup.getString("number");
        String name = customergroup.getString("name");
        if (number.isEmpty()) {
            String tip2 = ResManager.loadKDString((String)"\u6e20\u9053\u7c7b\u578b\u7684\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\r\n", (String)"ItempriceImportOp_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip2);
            return re;
        }
        DynamicObject typeName = QueryServiceHelper.queryOne((String)"mdr_customer_group", (String)"name", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (typeName == null) {
            tip = ResManager.loadKDString((String)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6e20\u9053\u7c7b\u578b\r\n", number), (String)"ItempriceImportOp_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
        }
        if (null != name && null != typeName && !name.equals(typeName.getString("name"))) {
            tip = ResManager.loadKDString((String)String.format("\u7f16\u7801\u4e3a%s\u7684\u6e20\u9053\u7c7b\u578b\u7684\u5bfc\u5165\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\r\n", number), (String)"ItempriceImportOp_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
        }
        return re;
    }

    private List<String> checkitem(JSONObject item) {
        ArrayList<String> re = new ArrayList<String>();
        String number = item.getString("number");
        String name = item.getString("name");
        if (number.isEmpty()) {
            String tip = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u7801\r\n", (String)"ItempriceImportOp_8", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
            return re;
        }
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"name", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        if (items == null || items.length == 0) {
            String tip = ResManager.loadKDString((String)String.format("\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1\r\n", number), (String)"ItempriceImportOp_9", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
            return re;
        }
        ArrayList<String> names = new ArrayList<String>(items.length);
        for (DynamicObject iteminfo : items) {
            names.add(iteminfo.getString("name"));
        }
        if (!name.isEmpty() && !names.contains(name)) {
            String tip = ResManager.loadKDString((String)String.format("\u5bfc\u5165\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u5546\u54c1\u540d\u79f0\u4e0d\u4e00\u81f4\r\n", number), (String)"ItempriceImportOp_10", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
            re.add(tip);
        }
        return re;
    }
}

