/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.item;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class PricePolicyBatchChangeOpPlugin
extends MdrBaseOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.updateItemPricePolicy(e.getDataEntities());
    }

    public void updateItemPricePolicy(DynamicObject[] dataEntities) {
        DynamicObject obj = null;
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject[] pricePolicyArray;
            obj = dataEntities[i];
            String pricePolicys = obj.getString("pricepolicys");
            BigDecimal price = obj.getBigDecimal("price");
            Date begindate = obj.getDate("begindate");
            Date enddate = obj.getDate("enddate");
            if (null == begindate && null == enddate && BigDecimal.ZERO.compareTo(price) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c\u4ef7\u683c\uff0c\u751f\u6548\u65e5\u671f\uff0c\u5931\u6548\u65e5\u671f \u4e0d\u80fd\u90fd\u4e3a\u7a7a!", (String)"PricePolicyBatchChangeOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(price) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0!", (String)"PricePolicyBatchChangeOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (pricePolicys == null || pricePolicys.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ef7\u683c\u653f\u7b56\u7684\u8bb0\u5f55!", (String)"PricePolicyBatchChangeOpPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            String[] pricePolicyIds = pricePolicys.split(",");
            QFilter f = new QFilter("id", "in", Arrays.stream(pricePolicyIds).map(strId -> Long.parseLong(strId)).collect(Collectors.toList()));
            for (DynamicObject pricePolicy : pricePolicyArray = BusinessDataServiceHelper.load((String)"mdr_price_policy", (String)"id,price,begindate,enddate", (QFilter[])f.toArray())) {
                if (price != null && price.doubleValue() > 0.0) {
                    pricePolicy.set("price", (Object)price);
                }
                if (begindate != null) {
                    pricePolicy.set("begindate", (Object)begindate);
                }
                if (enddate == null) continue;
                pricePolicy.set("enddate", (Object)enddate);
            }
            SaveServiceHelper.save((DynamicObject[])pricePolicyArray);
        }
    }
}

