/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.money;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.handler.BalanceHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ReceivingBillOpPlugin
extends MdrBaseOperationServicePlugIn {
    private static final Set<String> RECEVTYPE_NEEDED_ADD = new HashSet<String>(){
        {
            this.add("2");
            this.add("4");
        }
    };

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("orderid");
        e.getFieldKeys().add("ordertype");
        e.getFieldKeys().add("writeoffid");
        e.getFieldKeys().add("receivingtype");
        e.getFieldKeys().add("owner");
        e.getFieldKeys().add("isaddnew");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("receivedamount");
        e.getFieldKeys().add("amounttobepaid");
        e.getFieldKeys().add("paystatus");
        e.getFieldKeys().add("totalorderamount");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("contactscustomer");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (key) {
            case "audit": {
                for (DynamicObject obj : objs) {
                    if (!"C".equals(obj.get("status"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355%s\u5ba1\u6838\u5931\u8d25\uff1a\u5355\u636e\u5df2\u5ba1\u6838\uff01", (String)"ReceivingBillOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), obj.get("number")));
                }
                break;
            }
            case "delete": {
                for (DynamicObject obj : objs) {
                    if (!"C".equals(obj.get("status"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355%s\u5220\u9664\u5931\u8d25\uff1a\u5355\u636e\u5df2\u5ba1\u6838\uff01", (String)"ReceivingBillOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), obj.get("number")));
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject obj : objs) {
                    if ("C".equals(obj.get("status"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355%s\u5ba1\u6838\u5931\u8d25\uff1a\u5355\u636e\u672a\u5ba1\u6838\uff01", (String)"ReceivingBillOpPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]), obj.get("number")));
                }
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (key) {
            case "save": {
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject saleorder = null;
                    String orderId = objs[i].getString("orderid");
                    String orderType = objs[i].getString("ordertype");
                    String writeoffid = objs[i].getString("writeoffid");
                    if (!StringUtils.isNotEmpty((String)orderId)) continue;
                    saleorder = this.loadOrderData(orderId, orderType);
                    objs[i].set("owner", saleorder.get("owner"));
                    if (!StringUtils.isNotEmpty((String)writeoffid)) continue;
                    this.checkOrder(saleorder, objs[i]);
                }
                break;
            }
            case "audit": {
                ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i].getBoolean("isaddnew")) {
                        try {
                            this.updateBalance(objs[i], "audit");
                            successObjs.add(objs[i]);
                        }
                        catch (Exception ex) {
                            if (this.isFromListPage()) {
                                StringBuilder errorStr = new StringBuilder();
                                errorStr.append(OP.getName((String)key)).append("\u5931\u8d25,").append(objs[i].getString("number")).append(",\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e\u3002");
                                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", objs[i].getPkValue(), i, i + 1, key, OP.getName((String)key), errorStr.toString(), ErrorLevel.Error);
                                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                                continue;
                            }
                            throw new KDBizException("\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e\u3002");
                        }
                    } else {
                        successObjs.add(objs[i]);
                    }
                    String orderId = objs[i].getString("orderid");
                    String orderType = objs[i].getString("ordertype");
                    String writeoffid = objs[i].getString("writeoffid");
                    String receivingtype = objs[i].getString("receivingtype");
                    if ((!StringUtils.isNotEmpty((String)orderId) || !StringUtils.isNotEmpty((String)writeoffid)) && !"2".equals(receivingtype)) continue;
                    DynamicObject saleorder = this.loadOrderData(orderId, orderType);
                    this.updateOrder(saleorder, objs[i]);
                    SaleOrderHandler.handleStatusAfterSignOrDelivery((DynamicObject)saleorder);
                    SaveServiceHelper.save((IDataEntityType)saleorder.getDataEntityType(), (Object[])new DynamicObject[]{saleorder});
                }
                e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
                break;
            }
            case "unaudit": {
                ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i].getBoolean("isaddnew")) {
                        try {
                            this.updateBalance(objs[i], "unaudit");
                            successObjs.add(objs[i]);
                        }
                        catch (Exception ex) {
                            if (this.isFromListPage()) {
                                StringBuilder errorStr = new StringBuilder();
                                errorStr.append(OP.getName((String)key)).append("\u5931\u8d25,").append(objs[i].getString("number")).append(",\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e\u3002");
                                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", objs[i].getPkValue(), i, i + 1, key, OP.getName((String)key), errorStr.toString(), ErrorLevel.Error);
                                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                                continue;
                            }
                            throw new KDBizException("\u9884\u6536\u6b3e\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u9884\u6536\u6b3e\u3002");
                        }
                    } else {
                        successObjs.add(objs[i]);
                    }
                    String orderId = objs[i].getString("orderid");
                    String orderType = objs[i].getString("ordertype");
                    String writeoffid = objs[i].getString("writeoffid");
                    String receivingtype = objs[i].getString("receivingtype");
                    if ((!StringUtils.isNotEmpty((String)orderId) || !StringUtils.isNotEmpty((String)writeoffid)) && !"2".equals(receivingtype)) continue;
                    DynamicObject saleorder = this.loadOrderData(orderId, orderType);
                    this.cancelOrder(saleorder, objs[i]);
                    SaleOrderHandler.handleStatusAfterSignOrDelivery((DynamicObject)saleorder);
                    SaveServiceHelper.save((IDataEntityType)saleorder.getDataEntityType(), (Object[])new DynamicObject[]{saleorder});
                }
                e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
                break;
            }
        }
    }

    private DynamicObject loadOrderData(String orderId, String orderType) {
        DynamicObject saleorder = null;
        if (StringUtils.isNotEmpty((String)orderType) && orderType.equals("rebate")) {
            saleorder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"drm_rebatebill");
        } else if (StringUtils.isNotEmpty((String)orderType) && orderType.equals("saleorder")) {
            saleorder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
        }
        if (saleorder == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5173\u8054\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u8bd5", (String)"ReceivingBillOpPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        return saleorder;
    }

    private void updateBalance(DynamicObject receivingBill, String operate) {
        boolean isAudit = false;
        boolean isAdvance = false;
        boolean isAdd = false;
        String recvType = receivingBill.getString("receivingtype");
        if (recvType.equals("0")) {
            isAdvance = true;
        } else if (recvType.equals("1")) {
            isAdvance = false;
        } else {
            return;
        }
        if (operate.equals("audit")) {
            isAudit = true;
        }
        isAdd = isAudit == isAdvance;
        this.updateBalance(receivingBill, isAdd);
    }

    private void updateBalance(DynamicObject receivingBill, boolean isAdd) {
        DynamicObject owner = receivingBill.getDynamicObject("owner");
        Object ownerPK = null;
        if (owner != null) {
            ownerPK = owner.get("id");
        }
        DynamicObject customer = receivingBill.getDynamicObject("contactscustomer");
        Object customerPK = null;
        if (customer != null) {
            customerPK = customer.get("id");
        }
        BigDecimal amount = receivingBill.getBigDecimal("amount");
        if (!isAdd) {
            amount = amount.negate();
        }
        BalanceHandler.updateBalance((Object)ownerPK, (Object)customerPK, (BigDecimal)amount, null);
    }

    private void checkOrder(DynamicObject order, DynamicObject recv) {
        if (order != null) {
            if (order.get("paystatus").equals(SaleOrderPayStatus.ALREADY_PAID.getFlagStr())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4ee3\u6536\u6b3e\u72b6\u6001\u4e3a\u5df2\u6536\u6b3e\uff01", (String)"ReceivingBillOpPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            BigDecimal recvamount = recv.getBigDecimal("amount");
            BigDecimal amounttobepaid = order.getBigDecimal("amounttobepaid");
            if (amounttobepaid.compareTo(recvamount) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8ba2\u5355\u5f85\u6536\u91d1\u989d\uff01", (String)"ReceivingBillOpPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void cancelOrder(DynamicObject order, DynamicObject recv) {
        if (order != null) {
            boolean isAdd = this.isAmountNeedAdd(recv);
            BigDecimal recvamount = recv.getBigDecimal("amount");
            if (!isAdd) {
                recvamount = recvamount.negate();
            }
            BigDecimal amounttobepaid = order.getBigDecimal("amounttobepaid");
            BigDecimal receivedamount = order.getBigDecimal("receivedamount");
            BigDecimal totalorderamount = order.getBigDecimal("totalorderamount");
            receivedamount = receivedamount.subtract(recvamount);
            if ((amounttobepaid = amounttobepaid.add(recvamount)).compareTo(totalorderamount) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u91d1\u989d\uff01", (String)"ReceivingBillOpPlugin_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (amounttobepaid.compareTo(BigDecimal.ZERO) != 0) {
                order.set("paystatus", (Object)SaleOrderPayStatus.NOT_PAID.getFlagStr());
            }
            order.set("amounttobepaid", (Object)amounttobepaid);
            order.set("receivedamount", (Object)receivedamount);
            SaveServiceHelper.save((IDataEntityType)order.getDataEntityType(), (Object[])new DynamicObject[]{order});
        }
    }

    private void updateOrder(DynamicObject order, DynamicObject recv) {
        if (order != null) {
            boolean isAdd = this.isAmountNeedAdd(recv);
            if (order.get("paystatus").equals(SaleOrderPayStatus.ALREADY_PAID.getFlagStr())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4ee3\u6536\u6b3e\u72b6\u6001\u4e3a\u5df2\u6536\u6b3e\uff01", (String)"ReceivingBillOpPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            BigDecimal recvamount = recv.getBigDecimal("amount");
            if (!isAdd) {
                recvamount = recvamount.negate();
            }
            BigDecimal amounttobepaid = order.getBigDecimal("amounttobepaid");
            BigDecimal receivedamount = order.getBigDecimal("receivedamount");
            BigDecimal totalorderamount = order.getBigDecimal("totalorderamount");
            receivedamount = receivedamount.add(recvamount);
            amounttobepaid = amounttobepaid.subtract(recvamount);
            if (receivedamount.compareTo(totalorderamount) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6536\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8ba2\u5355\u5e94\u6536\u91d1\u989d\uff01", (String)"ReceivingBillOpPlugin_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (amounttobepaid.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u8ba2\u5355\u5f85\u6536\u91d1\u989d\uff01", (String)"ReceivingBillOpPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (amounttobepaid.compareTo(BigDecimal.ZERO) == 0) {
                order.set("paystatus", (Object)SaleOrderPayStatus.ALREADY_PAID.getFlagStr());
            }
            order.set("amounttobepaid", (Object)amounttobepaid);
            order.set("receivedamount", (Object)receivedamount);
        }
    }

    private boolean isAmountNeedAdd(DynamicObject recv) {
        String recvType = recv.getString("receivingtype");
        return RECEVTYPE_NEEDED_ADD.contains(recvType);
    }
}

