/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.oem.completereport;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class OEMCompleteReportDeletePlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("itementry");
        e.getFieldKeys().add("deliverableqty");
        e.getFieldKeys().add("alterqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] selCompleteReportInfos = e.getDataEntities();
        for (int i = 0; i < selCompleteReportInfos.length; ++i) {
            DynamicObject oldCompleteReportInfo = selCompleteReportInfos[i];
            DynamicObject completeReportInfo = BusinessDataServiceHelper.loadSingle((Object)oldCompleteReportInfo.get("id"), (String)"bbc_oemcompletereport", (String)"itementry.totalcompleteqty,itementry.sourceentryid,itementry.nowcompleteqty");
            DynamicObject oemOrderInfo = BusinessDataServiceHelper.loadSingle((Object)oldCompleteReportInfo.get("sourcebillid"), (String)"bbc_oemsaleorder", (String)"itementry.planproductqty,itementry.completeqty,itementry.deliverableqty,itementry.deliveredqty,itementry.alterqty,itementry.existstoreqty,productstatus");
            this.retrography(completeReportInfo, oemOrderInfo);
            this.productstatusChange(oemOrderInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oemOrderInfo});
        }
    }

    private void retrography(DynamicObject completeReportInfo, DynamicObject oemOrderInfo) {
        DynamicObjectCollection completeInfoEntry = completeReportInfo.getDynamicObjectCollection("itementry");
        DynamicObjectCollection oemInfoEntry = oemOrderInfo.getDynamicObjectCollection("itementry");
        for (int i = 0; i < completeInfoEntry.size(); ++i) {
            for (int j = 0; j < oemInfoEntry.size(); ++j) {
                long oemInfoEntryId;
                String sourceentryid = ((DynamicObject)completeInfoEntry.get(i)).getString("sourceentryid");
                if (!sourceentryid.equals(String.valueOf(oemInfoEntryId = ((Long)((DynamicObject)oemInfoEntry.get(j)).getPkValue()).longValue()))) continue;
                BigDecimal deliveredqty = ((DynamicObject)oemInfoEntry.get(j)).getBigDecimal("deliveredqty");
                BigDecimal deliverableqty = ((DynamicObject)oemInfoEntry.get(j)).getBigDecimal("deliverableqty");
                BigDecimal nowcompleteqty = ((DynamicObject)completeInfoEntry.get(i)).getBigDecimal("nowcompleteqty");
                if (nowcompleteqty.subtract(deliverableqty.subtract(deliveredqty)).compareTo(BigDecimal.ZERO) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6ee1\u8db3\u672c\u6b21\u5b8c\u5de5\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8eOEM\u8ba2\u5355\u7684\u7d2f\u8ba1\u53ef\u53d1\u8d27\u6570\u91cf-\u7d2f\u8ba1\u5df2\u53d1\u8d27\u6570\u91cf\u624d\u5141\u8bb8\u5220\u9664", (String)"OEMCompleteReportDeletePlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                BigDecimal oldValueCompleteQty = (BigDecimal)((DynamicObject)oemInfoEntry.get(j)).get("completeqty");
                BigDecimal newValueCompleteQty = oldValueCompleteQty.subtract(nowcompleteqty);
                ((DynamicObject)oemInfoEntry.get(j)).set("completeqty", (Object)newValueCompleteQty);
                BigDecimal existstoreqty = (BigDecimal)((DynamicObject)oemInfoEntry.get(j)).get("existstoreqty");
                ((DynamicObject)oemInfoEntry.get(j)).set("deliverableqty", (Object)existstoreqty.add(newValueCompleteQty));
            }
        }
    }

    private void productstatusChange(DynamicObject oemOrderInfo) {
        DynamicObjectCollection oemItemEntryInfo = oemOrderInfo.getDynamicObjectCollection("itementry");
        BigDecimal totalalterqty = BigDecimal.ZERO;
        BigDecimal totaldeliverableqty = BigDecimal.ZERO;
        for (DynamicObject itemEntry : oemItemEntryInfo) {
            totalalterqty = totalalterqty.add(itemEntry.getBigDecimal("alterqty"));
            totaldeliverableqty = totaldeliverableqty.add(itemEntry.getBigDecimal("deliverableqty"));
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) > 0 && totaldeliverableqty.compareTo(totalalterqty) < 0) {
            oemOrderInfo.set("productstatus", (Object)"D");
            return;
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) == 0) {
            oemOrderInfo.set("productstatus", (Object)"C");
            return;
        }
        oemOrderInfo.set("productstatus", (Object)"E");
    }
}

