/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.oem.completereport;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class OEMCompleteReportSavePlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("itementry");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] selCompleteReportInfos = e.getDataEntities();
        for (int i = 0; i < selCompleteReportInfos.length; ++i) {
            DynamicObject completeReportInfo = selCompleteReportInfos[i];
            String sourcebillid = (String)completeReportInfo.get("sourcebillid");
            DynamicObject oemOrderInfo = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"bbc_oemsaleorder", (String)"itementry.completeqty,itementry.existstoreqty,itementry.deliverableqty,itementry.alterqty,productstatus");
            this.toCompleteqty(completeReportInfo, oemOrderInfo, "completeqty");
            this.productstatusChange(oemOrderInfo);
            completeReportInfo.set("billstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oemOrderInfo});
        }
    }

    private void toCompleteqty(DynamicObject completeReportInfo, DynamicObject oemOrderInfo, String completeqty) {
        DynamicObjectCollection oemCompleteReportItemEntryCollection = completeReportInfo.getDynamicObjectCollection("itementry");
        DynamicObjectCollection oemSaleOrderItemEntrycollection = oemOrderInfo.getDynamicObjectCollection("itementry");
        for (int i = 0; i < oemCompleteReportItemEntryCollection.size(); ++i) {
            for (int j = 0; j < oemSaleOrderItemEntrycollection.size(); ++j) {
                long oemSaleOrderEntryID;
                String sourceEntryID = ((DynamicObject)oemCompleteReportItemEntryCollection.get(i)).getString("sourceentryid");
                if (!sourceEntryID.equals(String.valueOf(oemSaleOrderEntryID = ((Long)((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).getPkValue()).longValue()))) continue;
                BigDecimal nowcompleteqty = (BigDecimal)((DynamicObject)oemCompleteReportItemEntryCollection.get(i)).get("nowcompleteqty");
                BigDecimal oldValueCompleteqty = (BigDecimal)((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).get("completeqty");
                BigDecimal oldTotalcompleteqty = (BigDecimal)((DynamicObject)oemCompleteReportItemEntryCollection.get(i)).get("totalcompleteqty");
                if (oldTotalcompleteqty.compareTo(oldValueCompleteqty) != 0) {
                    oldTotalcompleteqty = oldValueCompleteqty;
                }
                ((DynamicObject)oemCompleteReportItemEntryCollection.get(i)).set("totalcompleteqty", (Object)oldTotalcompleteqty.add(nowcompleteqty));
                BigDecimal newValueCompleteQty = oldValueCompleteqty.add(nowcompleteqty);
                BigDecimal alterqty = ((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).getBigDecimal("alterqty");
                BigDecimal existstoreqty = ((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).getBigDecimal("existstoreqty");
                if (newValueCompleteQty.compareTo(alterqty.subtract(existstoreqty)) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u64cd\u4f5c\u4e0b,\u53cd\u5199\u7684\u7d2f\u8ba1\u5df2\u5b8c\u5de5\u6570\u91cf\uff1a%s\u4e0d\u80fd\u5927\u4e8e\u4e0b\u8fbe\u6570\u91cf\uff1a%s\u548c\u73b0\u6709\u5e93\u5b58\u91cf%s\u4e4b\u5dee,\u8bf7\u70b9\u51fb\u9000\u51fa\u91cd\u65b0\u751f\u6210\u5b8c\u5de5\u6c47\u62a5", (String)"OEMCompleteReportSavePlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), newValueCompleteQty, alterqty, existstoreqty));
                }
                ((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).set(completeqty, (Object)newValueCompleteQty);
                ((DynamicObject)oemSaleOrderItemEntrycollection.get(j)).set("deliverableqty", (Object)existstoreqty.add(newValueCompleteQty));
            }
        }
    }

    private void productstatusChange(DynamicObject oemOrderInfo) {
        DynamicObjectCollection oemItemEntryInfo = oemOrderInfo.getDynamicObjectCollection("itementry");
        BigDecimal totalalterqty = BigDecimal.ZERO;
        BigDecimal totaldeliverableqty = BigDecimal.ZERO;
        for (DynamicObject itemEntry : oemItemEntryInfo) {
            totalalterqty = totalalterqty.add(itemEntry.getBigDecimal("alterqty"));
            totaldeliverableqty = totaldeliverableqty.add(itemEntry.getBigDecimal("deliverableqty"));
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) > 0 && totaldeliverableqty.compareTo(totalalterqty) < 0) {
            oemOrderInfo.set("productstatus", (Object)"D");
            return;
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) == 0) {
            oemOrderInfo.set("productstatus", (Object)"C");
            return;
        }
        oemOrderInfo.set("productstatus", (Object)"E");
    }
}

