/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.oemsaleorder;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class OEMSaleOrderInventoryReportPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("productstatus");
        e.getFieldKeys().add("sendstatus");
        e.getFieldKeys().add("SOURCEBILLID");
        e.getFieldKeys().add("sourcebillentryid");
        e.getFieldKeys().add("itementry");
        e.getFieldKeys().add("alterqty");
        e.getFieldKeys().add("deliverableqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject oemOrderInfo = e.getDataEntities()[0];
        DynamicObjectCollection oemOrderItemEntryInfo = oemOrderInfo.getDynamicObjectCollection("itementry");
        this.productstatusChange(oemOrderInfo, oemOrderItemEntryInfo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oemOrderInfo});
    }

    private void productstatusChange(DynamicObject oemOrderInfo, DynamicObjectCollection oemOrderItemEntryInfo) {
        BigDecimal totalalterqty = BigDecimal.ZERO;
        BigDecimal totaldeliverableqty = BigDecimal.ZERO;
        for (DynamicObject itemEntry : oemOrderItemEntryInfo) {
            totalalterqty = totalalterqty.add(itemEntry.getBigDecimal("alterqty"));
            totaldeliverableqty = totaldeliverableqty.add(itemEntry.getBigDecimal("deliverableqty"));
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) > 0 && totaldeliverableqty.compareTo(totalalterqty) < 0) {
            oemOrderInfo.set("productstatus", (Object)"D");
            return;
        }
        if (totaldeliverableqty.compareTo(BigDecimal.ZERO) == 0) {
            oemOrderInfo.set("productstatus", (Object)"C");
            return;
        }
        oemOrderInfo.set("productstatus", (Object)"E");
    }
}

