/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.region;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class LogisticsSendOpPlugin
extends MdrBaseOperationServicePlugIn {
    private static final String ORDER_ISSENDED = "issended";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("order");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String opString;
        super.beforeExecuteOperationTransaction(e);
        switch (opString = e.getOperationKey()) {
            case "audit": 
            case "unaudit": 
            case "delete": {
                this.checkStatusForOperate(e.getSelectedRows(), opString);
                break;
            }
            case "submit": {
                this.checkSaleOrderRepeats(e.getDataEntities());
                break;
            }
            case "submitlist": {
                this.isSaleOrderlist(e.getSelectedRows());
                break;
            }
            case "save": {
                this.checkSaleOrderRepeats(e.getDataEntities());
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opString;
        super.beginOperationTransaction(e);
        switch (opString = e.getOperationKey()) {
            case "save": 
            case "submit": 
            case "submitlist": {
                this.setIsSended(Boolean.TRUE, e.getDataEntities());
                break;
            }
            case "delete": {
                this.setIsSended(Boolean.FALSE, e.getDataEntities());
                break;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String opString;
        switch (opString = e.getOperationKey()) {
            case "audit": {
                this.updateSaleOrderByAudit(e.getDataEntities());
                break;
            }
            case "unaudit": {
                this.updateSaleOrderByUnAudit(e.getDataEntities());
                break;
            }
        }
    }

    protected void updateSaleOrderByAudit(DynamicObject[] dynamicObjects) {
        for (DynamicObject dataEntity : dynamicObjects) {
            DynamicObject logisticsInfo = this.queryLogisticsInfo(dataEntity.getPkValue());
            BigDecimal transportamount = logisticsInfo.getBigDecimal("transportamount");
            BigDecimal transportprice = logisticsInfo.getBigDecimal("transportprice");
            String driverphone = logisticsInfo.getString("driverphone");
            String platenumber = logisticsInfo.getString("platenumber");
            this.updateTransPortInfo(logisticsInfo, transportamount, transportprice, driverphone, platenumber);
        }
    }

    private void updateSaleOrderByUnAudit(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject logisticsInfo = this.queryLogisticsInfo(dataEntity.getPkValue());
            BigDecimal transportamount = BigDecimal.ZERO;
            BigDecimal transportprice = BigDecimal.ZERO;
            this.updateTransPortInfo(logisticsInfo, transportamount, transportprice, "", "");
        }
    }

    private void updateTransPortInfo(DynamicObject logisticsInfo, BigDecimal transportamount, BigDecimal transportprice, String driverphone, String platenumber) {
        try (TXHandle h = TX.beginRequired();){
            try {
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", logisticsInfo.getDynamicObject("order").getPkValue())};
                DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)"id,transportamount,transportprice,driverphone,platenumber,drivertel,carno", (QFilter[])filters);
                if (saleorderInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", (String)"LogisticsSendOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                saleorderInfo.set("transportprice", (Object)transportprice);
                saleorderInfo.set("transportamount", (Object)transportamount);
                saleorderInfo.set("drivertel", (Object)driverphone);
                saleorderInfo.set("carno", (Object)platenumber);
                SaveServiceHelper.save((IDataEntityType)saleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{saleorderInfo});
                QFilter[] qfilters = new QFilter[]{new QFilter("itementry.sourcebillid", "=", saleorderInfo.getPkValue())};
                DynamicObject[] dispatchInfos = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id,sync,totalqty,transportamount,carno,drivertel,transportprice", (QFilter[])qfilters);
                BigDecimal sum = BigDecimal.ZERO;
                BigDecimal transportamountsum = BigDecimal.ZERO;
                if (dispatchInfos.length > 0) {
                    MessageResponse result;
                    HashMap data = new HashMap();
                    boolean hasSync = false;
                    for (DynamicObject dispatchInfo : dispatchInfos) {
                        sum = LogisticsSendOpPlugin.addObject(sum, dispatchInfo.getBigDecimal("totalqty"));
                    }
                    ArrayList list = new ArrayList();
                    for (int j = 0; j < dispatchInfos.length; ++j) {
                        BigDecimal disTotalQty;
                        DynamicObject dispatchInfo = dispatchInfos[j];
                        BigDecimal subTransportAmount = BigDecimal.ZERO;
                        if (BigDecimal.ZERO.compareTo(transportamount) != 0 && BigDecimal.ZERO.compareTo(disTotalQty = dispatchInfo.getBigDecimal("totalqty")) != 0) {
                            if (j == dispatchInfos.length - 1) {
                                subTransportAmount = LogisticsSendOpPlugin.subtractObject(transportamount, transportamountsum);
                            } else if (BigDecimal.ZERO.compareTo(sum) != 0) {
                                subTransportAmount = LogisticsSendOpPlugin.multiplyObject(disTotalQty, transportamount, 2);
                                subTransportAmount = LogisticsSendOpPlugin.divideObject(subTransportAmount, sum, 2);
                                transportamountsum = LogisticsSendOpPlugin.addObject(transportamountsum, subTransportAmount);
                            }
                        }
                        dispatchInfo.set("transportamount", (Object)subTransportAmount);
                        dispatchInfo.set("transportprice", (Object)transportprice);
                        dispatchInfo.set("drivertel", (Object)driverphone);
                        dispatchInfo.set("carno", (Object)platenumber);
                        if (!DispatchOrderSyncStatus.ALREADY_SYNC.getFlagStr().equals(dispatchInfo.getString("sync"))) continue;
                        HashMap<String, Object> orderInfo = new HashMap<String, Object>();
                        orderInfo.put("orderid", dispatchInfo.get("id"));
                        orderInfo.put("transportamount", subTransportAmount);
                        orderInfo.put("transportprice", transportprice);
                        orderInfo.put("drivertel", driverphone);
                        orderInfo.put("carno", platenumber);
                        list.add(orderInfo);
                        data.put("data", list);
                        hasSync = true;
                    }
                    SaveServiceHelper.save((DynamicObject[])dispatchInfos);
                    if (hasSync && !(result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.WDH_TRANSPORTPRICE_CHANGE, data, null, (RequestContext)RequestContext.get())).isSuccess()) {
                        throw new KDBizException(result.getErrorMessage());
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void setIsSended(Boolean isSended, DynamicObject[] objs) {
        if (objs.length == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            QFilter f = new QFilter("id", "=", obj.getDynamicObject("order").getPkValue());
            DynamicObject saleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_saleorder", (String)"id,issended", (QFilter[])f.toArray());
            if (saleorderInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", (String)"LogisticsSendOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            saleorderInfo.set(ORDER_ISSENDED, (Object)(isSended != false ? "1" : "0"));
            SaveServiceHelper.save((IDataEntityType)saleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{saleorderInfo});
        }
    }

    protected DynamicObject queryLogisticsInfo(Object Logisticsid) {
        DynamicObject logisticsInfo = BusinessDataServiceHelper.loadSingle((Object)Logisticsid, (String)"mdr_logistics_send");
        if (logisticsInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6d41\u6d3e\u8f66\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"LogisticsSendOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        return logisticsInfo;
    }

    protected void checkStatusForOperate(List<ExtendedDataEntity> selectRows, String opString) {
        DynamicObject dataEntity = null;
        HashMap<String, Object> params = new HashMap<String, Object>(selectRows.size());
        for (ExtendedDataEntity selectRow : selectRows) {
            dataEntity = selectRow.getDataEntity();
            params.put("id", dataEntity.getPkValue());
            dataEntity = ORMUtil.queryOneByPro((String)"mdr_logistics_send", (String)"status", params);
            if (dataEntity == null) continue;
            Object status = dataEntity.get("status");
            switch (opString) {
                case "audit": {
                    if (!"A".equals(status)) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u624d\u80fd\u5ba1\u6838", (String)"LogisticsSendOpPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                case "unaudit": {
                    if (!"A".equals(status)) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u624d\u80fd\u53cd\u5ba1\u6838", (String)"LogisticsSendOpPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                case "delete": {
                    if (!"C".equals(status)) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u72b6\u6001\u4e0d\u80fd\u5220\u9664", (String)"LogisticsSendOpPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected void isSaleOrderlist(List<ExtendedDataEntity> selectRows) {
        DynamicObject dataEntity = null;
        for (ExtendedDataEntity selectRow : selectRows) {
            dataEntity = selectRow.getDataEntity();
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", dataEntity.getPkValue())};
            DynamicObject logisticssendInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_logistics_send", (String)"id,order", (QFilter[])filters);
            this.checkSaleOrderRepeat(logisticssendInfo);
        }
    }

    protected void checkSaleOrderRepeats(DynamicObject[] dataEntities) {
        DynamicObject logisticssendInfo = null;
        for (int i = 0; i < dataEntities.length; ++i) {
            logisticssendInfo = dataEntities[i];
            this.checkSaleOrderRepeat(logisticssendInfo);
        }
    }

    protected void checkSaleOrderRepeat(DynamicObject logisticssendInfo) {
        Object orderId;
        if (logisticssendInfo.getDynamicObject("order") != null && (orderId = logisticssendInfo.getDynamicObject("order").getPkValue()) != null) {
            QFilter[] qfilter;
            DynamicObject[] logisticssendInfos;
            QFilter filter = new QFilter("order", "=", orderId);
            if (logisticssendInfo.getPkValue() != null) {
                QFilter filter2 = new QFilter("id", "!=", logisticssendInfo.getPkValue());
                filter.and(filter2);
            }
            if ((logisticssendInfos = BusinessDataServiceHelper.load((String)"mdr_logistics_send", (String)"id,number", (QFilter[])(qfilter = new QFilter[]{filter}))).length > 0 && logisticssendInfos[0] != null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e00\u5f20\u8ba2\u5355\u53ea\u80fd\u63d0\u4ea4\u4e00\u5f20\u7269\u6d41\u6d3e\u8f66\u5355\uff01\u5355\u53f7\uff1a%s", (String)"LogisticsSendOpPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]), logisticssendInfos[0].getString("number")));
            }
        }
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return LogisticsSendOpPlugin.toBigDecimal(dec1).subtract(LogisticsSendOpPlugin.toBigDecimal(dec2));
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return LogisticsSendOpPlugin.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (LogisticsSendOpPlugin.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return LogisticsSendOpPlugin.toBigDecimal(dec1).divide(LogisticsSendOpPlugin.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = LogisticsSendOpPlugin.toBigDecimal(dec1).multiply(LogisticsSendOpPlugin.toBigDecimal(dec2));
        return obj.setScale(scale, 6);
    }

    public static BigDecimal addObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return LogisticsSendOpPlugin.toBigDecimal(dec1).add(LogisticsSendOpPlugin.toBigDecimal(dec2));
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().indexOf(101) > -1) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }
}

