/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.salecontrol;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.cache.model.ItemSaleInfo;
import kd.drp.mdr.common.cache.model.PathSaleInfo;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.ImportCache;
import kd.drp.mdr.opplugin.handle.ImportHandle;

public class SaleControlRuleImport
implements IImportPlugin {
    private ImportHandle handle = new ImportHandle();
    private final ImportCache cache = new ImportCache();
    private Boolean companyControl = null;
    private PathSaleInfo rules;
    private ItemSaleInfo info;
    private Object preOwnerId = null;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        CheckResult result = this.checkImportData(data);
        if (result.isSuccess()) {
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(result.getMsg()));
        return false;
    }

    private CheckResult checkImportData(Map<String, Object> data) {
        try {
            String ownerNumber = this.handle.getNumber(data, "owner");
            if (StringUtils.isEmpty((String)ownerNumber)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"owner(\u6240\u5c5e\u6e20\u9053)\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleControlRuleImport_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            Object ownerId = this.queryOwnerId(ownerNumber);
            if (ownerId == null) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728", (String)"SaleControlRuleImport_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber));
            }
            CheckResult result = this.checkCanSaleFlag(data, ownerId, ownerNumber);
            if (!result.isSuccess()) {
                return result;
            }
            QFilter fs = new QFilter("owner", "=", ownerId);
            if (data.get("customer") != null && data.get("customergroup") != null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053\u4e0e\u6e20\u9053\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u5bfc\u5165", (String)"SaleControlRuleImport_15", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            if (data.get("item") != null && data.get("itemclass") != null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u4e0e\u5546\u54c1\u5206\u7c7b\u4e0d\u53ef\u4ee5\u540c\u65f6\u5b58\u5728", (String)"SaleControlRuleImport_16", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            result = this.checkCustomer(data, ownerNumber, ownerId, fs);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.checkItem(data, ownerNumber, ownerId, fs);
            if (!result.isSuccess()) {
                return result;
            }
            boolean exists = QueryServiceHelper.exists((String)"mdr_salecontrol", (QFilter[])fs.toArray());
            if (exists) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u89c4\u5219\u5df2\u5b58\u5728,\u65e0\u9700\u5bfc\u5165", (String)"SaleControlRuleImport_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return CheckResult.returnFalse((String)e.getMessage());
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkItem(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String itemNumber = this.handle.getNumber(data, "item");
        if (StringUtils.isEmpty((String)itemNumber)) {
            return this.checkItemClass(data, fs);
        }
        Object itemId = this.cache.getItemIdFromCache(itemNumber);
        boolean canSale = this.checkCanSale(itemId, ownerId);
        if (!canSale) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u53ef\u9500\u5546\u54c1\u3010%s\u3011", (String)"SaleControlRuleImport_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber, itemNumber));
        }
        fs.and("item", "=", itemId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkItemClass(Map<String, Object> data, QFilter fs) {
        String itemClassNumber = this.handle.getNumber(data, "itemclass");
        if (StringUtils.isEmpty((String)itemClassNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u548c\u5546\u54c1\u5206\u7c7b\u5fc5\u987b\u8f93\u5165\u5176\u4e2d\u4e00\u4e2a", (String)"SaleControlRuleImport_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        Object itemClassId = this.cache.getItemClassIdFromCache(itemClassNumber);
        if (itemClassId == null) {
            return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7bitemclass\u3010", (String)"SaleControlRuleImport_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]) + itemClassNumber + ResManager.loadKDString((String)"\u3011\u4e0d\u5b58\u5728", (String)"SaleControlRuleImport_6", (String)"drp-bbc-opplugin", (Object[])new Object[0])));
        }
        fs.and("itemclass", "=", itemClassId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkCustomer(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String customerNumber = this.handle.getNumber(data, "customer");
        if (StringUtils.isEmpty((String)customerNumber)) {
            return this.checkRegion(data, ownerNumber, ownerId, fs);
        }
        Object customerId = this.cache.getCustomerIdFromCache(customerNumber);
        if (customerId == null) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u6388\u6743\u7684\u6e20\u9053\u3010%s\u3011", (String)"SaleControlRuleImport_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber, customerNumber));
        }
        ItemSaleInfo itemSaleInfo = this.getItemSaleInfo();
        boolean isMarketability = itemSaleInfo.getMarketabilitys(ownerId, customerId);
        if (!isMarketability) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u7684\u6e20\u9053\u3010%s\u3011\u672a\u5f00\u542f\u53ef\u9500\u63a7\u5236", (String)"SaleControlRuleImport_8", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber, customerNumber));
        }
        fs.and("customer", "=", customerId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkRegion(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String regionNumber = this.handle.getNumber(data, "region");
        if (StringUtils.isEmpty((String)regionNumber)) {
            return this.checkCustomerGroup(data, ownerNumber, ownerId, fs);
        }
        Object regionId = this.cache.getRegionIdFromCache(regionNumber, ownerId);
        if (regionId == null) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u533a\u57df\u3010%s\u3011", (String)"SaleControlRuleImport_9", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber, regionNumber));
        }
        fs.and("region", "=", regionId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkCustomerGroup(Map<String, Object> data, String ownerNumber, Object ownerId, QFilter fs) {
        String groupNumber = this.handle.getNumber(data, "customergroup");
        if (StringUtils.isEmpty((String)groupNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053\u3001\u533a\u57df\u3001\u6e20\u9053\u5206\u7ec4\u5fc5\u987b\u8f93\u5165\u5176\u4e2d\u4e00\u4e2a", (String)"SaleControlRuleImport_10", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        Object groupId = this.cache.getcustomerGroupIdFromCache(groupNumber, ownerId);
        if (groupId == null) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u6e20\u9053\u5206\u7ec4\u3010%s\u3011", (String)"SaleControlRuleImport_11", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber, groupNumber));
        }
        fs.and("customergroup", "=", groupId);
        return CheckResult.returnTrue();
    }

    private CheckResult checkCanSaleFlag(Map<String, Object> data, Object ownerId, String ownerNumber) {
        String customerStrategy = this.cache.getStrategyFromCache(ownerId);
        String canSale = data.get("cansale").toString();
        if (!("B".equals(canSale) || "A".equals(canSale) || "C".equals(canSale))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"cansale\u8f93\u5165\u4e0d\u5408\u6cd5", (String)"SaleControlRuleImport_12", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        switch (customerStrategy) {
            case "B": {
                if ("B".equals(canSale) || "C".equals(canSale)) break;
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u53ea\u80fd\u505a\u4e0d\u53ef\u9500\u89c4\u5219", (String)"SaleControlRuleImport_13", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber));
            }
            case "A": {
                if ("A".equals(canSale)) break;
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6e20\u9053owner\u3010%s\u3011\u4e0b\u53ea\u80fd\u505a\u53ef\u9500\u89c4\u5219", (String)"SaleControlRuleImport_14", (String)"drp-bbc-opplugin", (Object[])new Object[0]), ownerNumber));
            }
        }
        return CheckResult.returnTrue();
    }

    private ItemSaleInfo getItemSaleInfo() {
        if (this.info == null) {
            this.info = new ItemSaleInfo();
        }
        return this.info;
    }

    private PathSaleInfo getPathSaleInfo(Object ownerId) {
        PathSaleInfo rules = null;
        if (ownerId.equals(this.preOwnerId)) {
            rules = this.rules;
        } else {
            ItemSaleInfo localInfo = this.getItemSaleInfo();
            rules = localInfo.querySaleRules(ownerId);
            this.preOwnerId = ownerId;
            this.rules = rules;
        }
        return rules;
    }

    private boolean checkCanSale(Object itemId, Object ownerId) {
        PathSaleInfo rules = this.getPathSaleInfo(ownerId);
        return rules.isItemCanSale(itemId);
    }

    private Object queryOwnerId(String ownerNumber) {
        if (!this.isCompanyControl()) {
            return this.handle.queryMyOwnerId(ownerNumber);
        }
        return this.cache.getCustomerIdFromCache(ownerNumber);
    }

    private boolean isCompanyControl() {
        if (this.companyControl == null) {
            this.companyControl = SysParamsUtil.isCompanyItemControl();
        }
        return this.companyControl;
    }
}

