/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.bbc.opplugin.saleorder.SaleContractBaseOppPlugin;
import kd.drp.mdr.common.status.SaleContractStatusEnum;

public class AbstractSaleContractBillOppPlugin
extends SaleContractBaseOppPlugin {
    @Override
    protected void checkSave(DynamicObject dynamicObject) {
        super.checkSave(dynamicObject);
        if (!AbstractSaleContractBillOppPlugin.isAddNew(dynamicObject)) {
            SaleContractStatusEnum[] billstatuses = new SaleContractStatusEnum[]{SaleContractStatusEnum.SAVED, SaleContractStatusEnum.SUBMITED};
            this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c", (String)"AbstractSaleContractBillOppPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
    }

    protected void checkIsExist(DynamicObject dynamic, SaleContractStatusEnum[] billstatuses, String oppAlias) {
        if (null == billstatuses || billstatuses.length == 0) {
            return;
        }
        ArrayList<String> billstatusList = new ArrayList<String>(billstatuses.length);
        for (int i = 0; i < billstatuses.length; ++i) {
            SaleContractStatusEnum billstatus = billstatuses[i];
            billstatusList.add(billstatus.getValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter(this.getPK(dynamic), "=", dynamic.getPkValue()), new QFilter(this.getBillstatusField(), "in", (Object)billstatusList.toArray())};
        boolean exists = QueryServiceHelper.exists((String)dynamic.getDataEntityType().getName(), (QFilter[])filters);
        if (!exists) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < billstatuses.length; ++i) {
                SaleContractStatusEnum billstatus = billstatuses[i];
                String statusAlias = billstatus.getAlias();
                if (i == 0) {
                    sb.append(statusAlias);
                    continue;
                }
                if (i == billstatuses.length - 1) {
                    sb.append(ResManager.loadKDString((String)"\u6216", (String)"AbstractSaleContractBillOppPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0])).append(statusAlias);
                    continue;
                }
                sb.append('\u3001').append(statusAlias);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f%s\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s", (String)"AbstractSaleContractBillOppPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]), sb, oppAlias));
        }
    }

    @Override
    protected void submitBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)SaleContractStatusEnum.SUBMITED.getValue());
        }
    }

    protected void submitListBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)SaleContractStatusEnum.SUBMITED.getValue());
        }
    }

    @Override
    protected StringBuilder getSubmitListSelector(DynamicObject info) {
        StringBuilder selector = super.getSubmitListSelector(info);
        if (selector.length() == 0) {
            selector.append(this.getBillstatusField()).append('\n');
        } else {
            selector.append(',').append(this.getBillstatusField()).append('\n');
        }
        return selector;
    }

    @Override
    protected void auditBefore(BeforeOperationArgs args) {
        super.auditBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)SaleContractStatusEnum.AUDIDPASS.getValue());
        }
    }

    @Override
    protected void unauditBefore(BeforeOperationArgs args) {
        super.unauditBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)SaleContractStatusEnum.SAVED.getValue());
        }
    }

    @Override
    protected void checkSubmit(DynamicObject dynamicObject) {
        super.checkSubmit(dynamicObject);
        this.checkBillInWorkFlow(dynamicObject);
    }

    protected void checkBillInWorkFlow(DynamicObject dynamicObject) {
    }

    @Override
    protected void checkAudit(DynamicObject dynamicObject) {
        super.checkAudit(dynamicObject);
        if (AbstractSaleContractBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5355\u636e", (String)"AbstractSaleContractBillOppPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        SaleContractStatusEnum[] billstatuses = new SaleContractStatusEnum[]{SaleContractStatusEnum.SUBMITED, SaleContractStatusEnum.AUDITING};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractSaleContractBillOppPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
    }

    @Override
    protected void checkDelete(DynamicObject dynamicObject) {
        super.checkDelete(dynamicObject);
        if (AbstractSaleContractBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e", (String)"AbstractSaleContractBillOppPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        SaleContractStatusEnum[] billstatuses = new SaleContractStatusEnum[]{SaleContractStatusEnum.SAVED, SaleContractStatusEnum.SUBMITED};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u5220\u9664", (String)"AbstractSaleContractBillOppPlugin_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
    }

    @Override
    protected void checkUnAudit(DynamicObject dynamicObject) {
        super.checkUnAudit(dynamicObject);
        if (AbstractSaleContractBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e", (String)"AbstractSaleContractBillOppPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        SaleContractStatusEnum[] billstatuses = new SaleContractStatusEnum[]{SaleContractStatusEnum.AUDIDPASS};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"AbstractSaleContractBillOppPlugin_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
    }

    protected String getBillstatusField() {
        return "billstatus";
    }
}

