/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mdr.common.status.DispatchOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class AmountConfirmOpPlugin
extends MdrBaseOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            Object userid = UserUtil.getUserID();
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user");
            data.set("confirmuser", (Object)user);
            data.set("confirmtime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas;
        super.endOperationTransaction(e);
        for (DynamicObject data : datas = e.getDataEntities()) {
            this.unWriteDispatchOrderStatus(data);
            this.unWriteSaleOrderStatus(data);
        }
    }

    private void unWriteDispatchOrderStatus(DynamicObject data) {
        Object billid = data.get("billid");
        QFilter filter = new QFilter("itementry.sourcebillid", "=", billid);
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"mdr_dispatch_order", (String)"id,confirmstatus,billno", (QFilter[])filter.toArray());
        if (orders != null && orders.length > 0) {
            for (DynamicObject order : orders) {
                order.set("confirmstatus", (Object)DispatchOrderConfirmStatus.AMOUNTCONFIRMED.getFlagStr());
                OrderOperateLogHandler.save((DynamicObject)order, (String)"amountconfirm", (String)ResManager.loadKDString((String)"\u5e94\u6536\u77ed\u4fe1\u786e\u8ba4", (String)"AmountConfirmOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            SaveServiceHelper.save((DynamicObject[])orders);
        }
    }

    private void unWriteSaleOrderStatus(DynamicObject data) {
        Object billid = data.get("billid");
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mdr_saleorder");
        order.set("confirmstatus", (Object)SaleOrderConfirmStatus.AMOUNTCONFIRMED.getFlagStr());
        OrderOperateLogHandler.save((DynamicObject)order, (String)"amountconfirm", (String)ResManager.loadKDString((String)"\u5e94\u6536\u77ed\u4fe1\u786e\u8ba4", (String)"AmountConfirmOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{order});
        Object billno = order.get("billno");
        Object easnumber = order.getDynamicObject("customer").get("easnumber");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contactscustomer", billno);
        param.put("eascustomernumber", easnumber);
        SynResult synResult = AmountConfirmOpPlugin.synAmountOrder(param);
        if (!synResult.isSuccess()) {
            throw new KDBizException(synResult.getMsg());
        }
    }

    private static SynResult synAmountOrder(Map<String, Object> data) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.WDH_OTHERBILL_CONFIRM, data, null, (RequestContext)RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4", (String)"AmountConfirmOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
                }
                issyn = false;
                synresult.setMsg(errorMessage);
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }
}

