/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.model.CurrentInfo;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.DispatchOrderUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DispatchOrderValidPlugin
extends MdrBaseOperationServicePlugIn {
    private volatile boolean isChangeoOrderWhenInValid = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("orderstatus");
        fieldKeys.add("invalidreason");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        CurrentInfo current = new CurrentInfo();
        int len = datas.length;
        for (int i = 0; i < len; ++i) {
            datas[i].set("billstatus", (Object)"A");
            datas[i].set("invalidreason", (Object)"");
            datas[i].set("orderstatus", (Object)DispatchOrderStatus.TEMP_SAVE.getFlagStr());
            datas[i].set("modifier", current.getUserId());
            datas[i].set("modifytime", (Object)current.getNow());
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.isChangeoOrderWhenInValid = SysParamsUtil.isChangeoOrderWhenInValid();
        if (this.isChangeoOrderWhenInValid) {
            DynamicObject[] datas = e.getDataEntities();
            this.changOrder(datas);
        }
    }

    private void changOrder(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            this.changeOrder(data);
            DispatchOrderUtil.handleStoreForward((DynamicObject)data);
        }
    }

    private void changeOrder(DynamicObject order) {
        HashMap saleOrderEntryMap = new HashMap();
        DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("itementry");
        DynamicObject saleOrder = null;
        for (DynamicObject orderEntry : orderEntrys) {
            Object saleOrderId = orderEntry.get("sourcebillid");
            if (saleOrder == null) {
                saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"bbc_saleorder");
                if (saleOrder == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u9500\u552e\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"DispatchOrderValidPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection saleOrderEntrys = saleOrder.getDynamicObjectCollection("itementry");
                saleOrderEntryMap.putAll(CommonUtils.collection2Map((String)"id", (List)saleOrderEntrys));
            }
            DynamicObject saleOrderEntry = (DynamicObject)saleOrderEntryMap.get(orderEntry.getLong("sourceentryid"));
            saleOrderEntry.set("qty", orderEntry.get("qty"));
        }
        if (null != saleOrder) {
            saleOrder.set("orderstatus", (Object)SaleOrderStatus.CHANGING.getFlagStr());
            OperationUtil.invokeOperation(saleOrder, (String)"save");
        }
    }
}

