/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SOAuditReverseContractOpPlugin
extends MdrBaseOperationServicePlugIn {
    private static String[] status = new String[]{"C", "D", "E", "F", "G", "H", "J", "K", "L"};

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.auterAfter(e);
    }

    protected void auterAfter(EndOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject dny = objs[i];
            DynamicObjectCollection dnyEntryCol = dny.getDynamicObjectCollection("itementry");
            if (this.isContainsField(dny, "itementry")) {
                if (dnyEntryCol == null || dnyEntryCol.size() == 0) continue;
                DynamicObject entry = (DynamicObject)dnyEntryCol.get(0);
                if (this.isContainsField(entry, "itementry.sourcebillid")) {
                    this.reverseToSaleContract(dny);
                    continue;
                }
                StringBuilder selector = this.getSelector();
                DynamicObject checkInfo = BusinessDataServiceHelper.loadSingle((Object)dny.getPkValue(), (String)dny.getDataEntityType().getName(), (String)selector.toString());
                this.reverseToSaleContract(checkInfo);
                continue;
            }
            StringBuilder selector = this.getSelector();
            DynamicObject checkInfo = BusinessDataServiceHelper.loadSingle((Object)dny.getPkValue(), (String)dny.getDataEntityType().getName(), (String)selector.toString());
            this.reverseToSaleContract(checkInfo);
        }
    }

    private StringBuilder getSelector() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("billno,");
        selector.append("itementry,");
        selector.append("itementry.id,");
        selector.append("itementry.sourcebillid,");
        selector.append("itementry.sourcebillentryid,");
        selector.append("itementry.orderamount,");
        selector.append("itementry.item,");
        selector.append("itementry.item.id,");
        selector.append("itementry.item.number,");
        selector.append("itementry.item.name");
        return selector;
    }

    protected void reverseToSaleContract(DynamicObject dny) {
        String number = dny.getString("billno");
        DynamicObjectCollection entryCol = dny.getDynamicObjectCollection("itementry");
        if (entryCol != null && entryCol.size() != 0) {
            HashSet<String> set = new HashSet<String>();
            HashSet<String> billSet = new HashSet<String>();
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryCol.get(i);
                String sourcebillid = dynamicObject.getString("sourcebillid");
                String sourcebillentryid = dynamicObject.getString("sourcebillentryid");
                if (sourcebillid == null || sourcebillid.trim().length() == 0 || sourcebillentryid == null || sourcebillentryid.trim().length() == 0 || set.contains(sourcebillentryid)) continue;
                set.add(sourcebillentryid);
                Map<String, BigDecimal> totalMap = this.getOrderTotalInfo(sourcebillid, sourcebillentryid);
                DynamicObject conInfo = this.getContractInfo(sourcebillid);
                DynamicObject contractEntry = this.getContractEntryInfo(conInfo, sourcebillentryid);
                if (contractEntry == null) continue;
                billSet.add(sourcebillid);
                BigDecimal amtDif = BigDecimalUtil.subtractObject((Object)totalMap.get("AMOUNT"), (Object)contractEntry.getBigDecimal("taxamount"));
                if (amtDif != null && amtDif.floatValue() > 0.01f) {
                    int rowNumber = i + 1;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355[%s]\u7b2c%s\u884c\uff0c\u9500\u552e\u8ba2\u5355\u7684\u91d1\u989d\u7d2f\u8ba1%s\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5206\u5f55\u91d1\u989d%s", (String)"SOAuditReverseContractOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), number, rowNumber, totalMap.get("AMOUNT"), contractEntry.getBigDecimal("taxamount")));
                }
                BigDecimal qtyDif = BigDecimalUtil.subtractObject((Object)totalMap.get("QTY"), (Object)contractEntry.getBigDecimal("qty"));
                if (qtyDif != null && qtyDif.floatValue() > 0.01f) {
                    int rowNumber = i + 1;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355[%s]\u7b2c%s\u884c\uff0c\u9500\u552e\u8ba2\u5355\u7684\u6570\u91cf\u7d2f\u8ba1%s\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5206\u5f55\u6570\u91cf%s", (String)"SOAuditReverseContractOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), number, rowNumber, totalMap.get("QTY"), contractEntry.getBigDecimal("qty")));
                }
                contractEntry.set("totalorderqty", (Object)totalMap.get("QTY"));
                contractEntry.set("totalorderamt", (Object)totalMap.get("AMOUNT"));
                contractEntry.set("unorderqty", (Object)BigDecimalUtil.subtractObject((Object)contractEntry.get("qty"), (Object)contractEntry.get("totalorderqty")));
                BusinessDataServiceHelper.save((IDataEntityType)conInfo.getDataEntityType(), (Object[])new DynamicObject[]{conInfo});
            }
            for (Object e : billSet) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "=", e)};
                String selector = "id,totalbillorderqty,totalbillorderamt,entryentity,entryentity.taxamount,entryentity.qty,entryentity.totalorderqty,totalorderamt,unorderqty";
                DynamicObject contract = BusinessDataServiceHelper.loadSingle(e, (String)"mdr_salecontract", (String)selector);
                DynamicObjectCollection entrys = contract.getDynamicObjectCollection("entryentity");
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal qty = BigDecimal.ZERO;
                if (entrys != null && entrys.size() != 0) {
                    for (int i = 0; i < entrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        amount = BigDecimalUtil.addObject((Object)amount, (Object)entry.get("totalorderamt"));
                        qty = BigDecimalUtil.addObject((Object)qty, (Object)entry.get("totalorderqty"));
                    }
                }
                contract.set("totalbillorderqty", (Object)qty);
                contract.set("totalbillorderamt", (Object)amount);
                BusinessDataServiceHelper.save((IDataEntityType)contract.getDataEntityType(), (Object[])new DynamicObject[]{contract});
            }
        }
    }

    private Map<String, BigDecimal> getOrderTotalInfo(String sourcebillid, String sourcebillentryid) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("sourcebillid", "=", (Object)sourcebillid));
        filterList.add(new QFilter("sourcebillentryid", "=", (Object)sourcebillentryid));
        filterList.add(new QFilter("order.orderstatus", "in", (Object)status));
        DynamicObject[] saleorderEntryCol = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)"orderamount,qty", (QFilter[])filterList.toArray(new QFilter[1]));
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int j = 0; j < saleorderEntryCol.length; ++j) {
            DynamicObject saleorderEntry = saleorderEntryCol[j];
            totalAmount = BigDecimalUtil.addObject((Object)totalAmount, (Object)saleorderEntry.getBigDecimal("orderamount"));
            totalQty = BigDecimalUtil.addObject((Object)totalQty, (Object)saleorderEntry.getBigDecimal("qty"));
        }
        map.put("AMOUNT", totalAmount);
        map.put("QTY", totalQty);
        return map;
    }

    protected DynamicObject getContractEntryInfo(DynamicObject contractInfo, String sourcebillentryid) {
        DynamicObjectCollection entryCol;
        if (contractInfo != null && (entryCol = contractInfo.getDynamicObjectCollection("entryentity")) != null && entryCol.size() != 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                if (!sourcebillentryid.equals(entry.getPkValue().toString())) continue;
                return entry;
            }
        }
        return null;
    }

    protected DynamicObject getContractInfo(String sourcebillid) {
        String selector = "id,totalbillorderqty,totalbillorderamt,entryentity,entryentity.id,entryentity.taxamount,entryentity.qty,entryentity.totalorderqty,totalorderamt,unorderqty,entryentity.totalorderamt,entryentity.unorderqty";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)};
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"mdr_salecontract", (String)selector, (QFilter[])filters);
        if (contracts != null && contracts.length != 0) {
            return contracts[0];
        }
        return null;
    }

    protected boolean isContainsField(DynamicObject info, String field) {
        boolean rs = true;
        try {
            Object object = info.get(field);
        }
        catch (Exception e) {
            rs = false;
        }
        return rs;
    }
}

