/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SOSubmitCheckOppPlugin
extends MdrBaseOperationServicePlugIn {
    private static String[] status = new String[]{"B", "C", "D", "E", "F", "G", "H", "J", "K", "L"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("itementry.sourcebillid");
        e.getFieldKeys().add("itementry.sourcebillentryid");
        e.getFieldKeys().add("billno");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.checkSaleContract(e);
    }

    protected void checkSaleContract(EndOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject dny = objs[i];
            this.reverseToSaleContract(dny);
        }
    }

    protected void reverseToSaleContract(DynamicObject dny) {
        String number = dny.getString("billno");
        DynamicObjectCollection entryCol = dny.getDynamicObjectCollection("itementry");
        if (entryCol != null && entryCol.size() != 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                String sourcebillid = entry.getString("sourcebillid");
                String sourcebillentryid = entry.getString("sourcebillentryid");
                if (sourcebillid == null || sourcebillid.trim().length() == 0 || sourcebillentryid == null || sourcebillentryid.trim().length() == 0 || set.contains(sourcebillentryid)) continue;
                set.add(sourcebillentryid);
                Map<String, BigDecimal> totalMap = this.getOrderTotalInfo(sourcebillid, sourcebillentryid, dny);
                DynamicObject conInfo = this.getContractInfo(sourcebillid);
                DynamicObject contractEntry = this.getContractEntryInfo(conInfo, sourcebillentryid);
                if (contractEntry == null) continue;
                BigDecimal amtDif = BigDecimalUtil.subtractObject((Object)totalMap.get("AMOUNT"), (Object)contractEntry.getBigDecimal("taxamount"));
                if (amtDif != null && amtDif.floatValue() > 0.01f) {
                    int rowNumber = i + 1;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\uff0c\u9500\u552e\u8ba2\u5355[%s]\u7b2c%s\u884c\uff0c\u9500\u552e\u8ba2\u5355\u7684\u91d1\u989d\u7d2f\u8ba1%s\uff08\u5305\u542b\u5df2\u63d0\u4ea4\uff09\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5206\u5f55\u91d1\u989d%s", (String)"SOSubmitCheckOppPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), number, rowNumber, SOSubmitCheckOppPlugin.setScale(BigDecimalUtil.toBigDecimal((Object)totalMap.get("AMOUNT")), 2), SOSubmitCheckOppPlugin.setScale(BigDecimalUtil.toBigDecimal((Object)contractEntry.getBigDecimal("taxamount")), 2)));
                }
                BigDecimal qtyDif = BigDecimalUtil.subtractObject((Object)totalMap.get("QTY"), (Object)contractEntry.getBigDecimal("qty"));
                if (qtyDif == null || !(qtyDif.floatValue() > 0.01f)) continue;
                int rowNumber = i + 1;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\uff0c\u9500\u552e\u8ba2\u5355[%s]\u7b2c%s\u884c\uff0c\u9500\u552e\u8ba2\u5355\u7684\u6570\u91cf\u7d2f\u8ba1%s\uff08\u5305\u542b\u5df2\u63d0\u4ea4\uff09\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5206\u5f55\u6570\u91cf%s", (String)"SOSubmitCheckOppPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), number, rowNumber, SOSubmitCheckOppPlugin.setScale(BigDecimalUtil.toBigDecimal((Object)totalMap.get("QTY")), 2), SOSubmitCheckOppPlugin.setScale(BigDecimalUtil.toBigDecimal((Object)contractEntry.getBigDecimal("qty")), 2)));
            }
        }
    }

    public static BigDecimal setScale(BigDecimal value, int p) {
        if (value == null) {
            return null;
        }
        return value.setScale(p, 4);
    }

    private Map<String, BigDecimal> getOrderTotalInfo(String sourcebillid, String sourcebillentryid, DynamicObject dny) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)sourcebillid);
        filter.and(new QFilter("sourcebillentryid", "=", (Object)sourcebillentryid));
        filter.and(new QFilter("order.orderstatus", "in", (Object)status));
        DynamicObject[] saleorderEntryCol = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)"orderamount,qty", (QFilter[])filter.toArray());
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int j = 0; j < saleorderEntryCol.length; ++j) {
            DynamicObject saleorderEntry = saleorderEntryCol[j];
            totalAmount = BigDecimalUtil.addObject((Object)totalAmount, (Object)saleorderEntry.getBigDecimal("orderamount"));
            totalQty = BigDecimalUtil.addObject((Object)totalQty, (Object)saleorderEntry.getBigDecimal("qty"));
        }
        map.put("AMOUNT", totalAmount);
        map.put("QTY", totalQty);
        return map;
    }

    protected DynamicObject getContractEntryInfo(DynamicObject contractInfo, String sourcebillentryid) {
        DynamicObjectCollection entryCol;
        if (contractInfo != null && (entryCol = contractInfo.getDynamicObjectCollection("entryentity")) != null && entryCol.size() != 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                if (!sourcebillentryid.equals(entry.getPkValue().toString())) continue;
                return entry;
            }
        }
        return null;
    }

    protected DynamicObject getContractInfo(String sourcebillid) {
        String selector = "id,totalbillorderqty,totalbillorderamt,entryentity,entryentity.id,entryentity.taxamount,entryentity.qty,entryentity.totalorderqty,totalorderamt,unorderqty,entryentity.totalorderamt,entryentity.unorderqty";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)};
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"mdr_salecontract", (String)selector, (QFilter[])filters);
        if (contracts != null && contracts.length != 0) {
            return contracts[0];
        }
        return null;
    }

    protected boolean isContainsField(DynamicObject info, String field) {
        boolean rs = true;
        try {
            info.get(field);
        }
        catch (Exception e) {
            rs = false;
        }
        return rs;
    }
}

