/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.bbc.opplugin.saleorder.AbstractSaleContractBillOppPlugin;
import kd.drp.bbc.opplugin.saleorder.SynSaleContractUtil;
import kd.drp.mdr.common.status.SaleContractStatusEnum;
import kd.drp.mdr.common.util.SysParamsUtil;

public class SaleContractOpPlugin
extends AbstractSaleContractBillOppPlugin {
    protected void fileAfter(EndOperationTransactionArgs e) {
        Object[] datas = e.getDataEntities();
        if (datas != null && datas.length > 0) {
            for (int i = 0; i < datas.length; ++i) {
                datas[i] = BusinessDataServiceHelper.loadSingle((Object)datas[i].getPkValue(), (String)datas[i].getDataEntityType().getName(), (String)"billstatus");
                datas[i].set("billstatus", (Object)"F");
            }
            BusinessDataServiceHelper.save((IDataEntityType)datas[0].getDataEntityType(), (Object[])datas);
        }
    }

    @Override
    protected void auditAfter(EndOperationTransactionArgs e) {
        super.auditAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynSaleContractUtil.synSaleContract(datas[i].getPkValue());
            }
        }
    }

    @Override
    protected void unauditAfter(EndOperationTransactionArgs e) {
        super.unauditAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynSaleContractUtil.synSaleContractDelete(datas[i]);
            }
        }
    }

    protected List<String[]> getRequiredFieldList() {
        return null;
    }

    @Override
    protected List<String[]> getCanNotRepeatFieldList() {
        return null;
    }

    protected void signBefore(BeforeOperationArgs args) {
        DynamicObject[] objs = args.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            this.checkSign(objs[i]);
        }
    }

    protected void signAfter(EndOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            this.sign(objs[i]);
        }
    }

    protected void sign(DynamicObject dynamicObject) {
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("issigned");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())};
        DynamicObject dynInfo = BusinessDataServiceHelper.loadSingle((String)dynamicObject.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filters);
        dynInfo.set("issigned", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynInfo});
    }

    protected void checkSign(DynamicObject dyn) {
        if (!SaleContractOpPlugin.isAddNew(dyn)) {
            SaleContractStatusEnum[] billstatuses = new SaleContractStatusEnum[]{SaleContractStatusEnum.AUDIDPASS};
            this.checkIsExist(dyn, billstatuses, ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c", (String)"SaleContractOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", dyn.getPkValue()), new QFilter("issigned", "=", (Object)Boolean.TRUE)};
            boolean exists = QueryServiceHelper.exists((String)dyn.getDataEntityType().getName(), (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u7b7e\u8ba2\uff0c\u4e0d\u80fd\u91cd\u590d\u7b7e\u8ba2\uff01", (String)"SaleContractOpPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected void checkUnAudit(DynamicObject dyn) {
        super.checkUnAudit(dyn);
        if (!SaleContractOpPlugin.isAddNew(dyn)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", dyn.getPkValue()), new QFilter("issigned", "=", (Object)Boolean.TRUE)};
            boolean exists = QueryServiceHelper.exists((String)dyn.getDataEntityType().getName(), (QFilter[])filters);
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7b7e\u8ba2\u5408\u540c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01", (String)"SaleContractOpPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

