/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderAllotPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("orderstatus");
        fieldKeys.add("sync");
        fieldKeys.add("itementry.qty");
        fieldKeys.add("itementry.allotedqty");
        fieldKeys.add("itementry.allotenqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        CheckResult result = this.checkCanAllot(datas);
        if (!result.isSuccess()) {
            e.cancel = true;
            e.setCancelMessage(result.getMsg());
            return;
        }
    }

    private CheckResult checkCanAllot(DynamicObject[] datas) {
        if (datas.length == 0 || datas.length > 1) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u5206\u914d\uff01", (String)"SaleOrderAllotPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u5206\u8d27\u548c\u90e8\u5206\u5206\u8d27\u4e14\u672a\u540c\u6b65\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u5206\u914d\uff01", (String)"SaleOrderAllotPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
        SaleOrderStatus orderStatus = SaleOrderUtil.getOrderStatus((DynamicObject)datas[0]);
        if (!SaleOrderStatus.PENDING_DISPATCH.equals((Object)orderStatus) && !SaleOrderStatus.PART_DISPATCH.equals((Object)orderStatus)) {
            return CheckResult.returnFalse((String)msg);
        }
        SaleOrderSyncStatus orderSyncStatus = SaleOrderUtil.getOrderSyncStatus((DynamicObject)datas[0]);
        if (SaleOrderSyncStatus.SYNC_ING.equals((Object)orderSyncStatus) || SaleOrderSyncStatus.ALREADY_SYNC.equals((Object)orderSyncStatus)) {
            return CheckResult.returnFalse((String)msg);
        }
        BigDecimal qty = null;
        BigDecimal allotQty = null;
        DynamicObjectCollection entrys = datas[0].getDynamicObjectCollection("itementry");
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            qty = ((DynamicObject)entrys.get(i)).getBigDecimal("qty");
            if (qty.compareTo(allotQty = ((DynamicObject)entrys.get(i)).getBigDecimal("allotenqty")) <= 0) continue;
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5df2\u5206\u914d\u5b8c\uff0c\u4e0d\u80fd\u518d\u5206\u914d\uff01", (String)"SaleOrderAllotPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
    }
}

