/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.iAlgorithm.LocalPageCache;
import kd.drp.mdr.iAlgorithm.OrderAlgorithm;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderConfirmApart
extends MdrBaseOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckQtyValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject order : e.getDataEntities()) {
            DynamicObject parentorder = BusinessDataServiceHelper.loadSingle((Object)order.get("id"), (String)"bbc_saleorder");
            DynamicObject childorder = BusinessDataServiceHelper.newDynamicObject((String)"bbc_saleorder");
            childorder.set("billno", order.get("billno"));
            childorder.set("creator", UserUtil.getUserID());
            childorder.set("createtime", (Object)new Date());
            childorder.set("parentorderid", order.get("parentorderid"));
            DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)childorder, (DynamicObject)parentorder, new HashSet<String>(Arrays.asList(this.getIgnoredCopyFields())));
            childorder.set("billno", order.get("billno"));
            DynamicObjectCollection col = order.getDynamicObjectCollection("itementry");
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject splitentry = (DynamicObject)col.get(i);
                Object entryid = splitentry.get("entryid");
                BigDecimal qty = splitentry.getBigDecimal("qty");
                BigDecimal parentqty = splitentry.getBigDecimal("parentqty");
                this.dealEntrys(parentorder, childorder, entryid, parentqty, qty);
            }
            this.reCalHeadAndSave(parentorder, childorder);
        }
    }

    protected BigDecimal getNullToZero(DynamicObject obj, String key) {
        BigDecimal value = obj.getBigDecimal(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    protected void dealEntrys(DynamicObject parentorder, DynamicObject childorder, Object entryid, BigDecimal parentqty, BigDecimal qty) {
        if (parentqty.compareTo(qty) == 0) {
            return;
        }
        DynamicObjectCollection parentorderentrys = parentorder.getDynamicObjectCollection("itementry");
        DynamicObjectCollection childorderentrys = childorder.getDynamicObjectCollection("itementry");
        int index = this.getIndexByEntryid(parentorderentrys, entryid);
        DynamicObject parententry = (DynamicObject)parentorderentrys.get(index);
        DynamicObject childentry = childorderentrys.addNew();
        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)childentry, (DynamicObject)parententry);
        if (parentqty.compareTo(BigDecimal.ZERO) == 0) {
            parentorderentrys.remove(index);
        } else {
            this.updateParentEntry(parentorder, parententry, parentqty, qty);
            this.updateChildEntry(parententry, childentry);
        }
    }

    protected void reCalHeadAndSave(DynamicObject parentorder, DynamicObject childorder) {
        new OrderAlgorithm(parentorder, (IPageCache)new LocalPageCache()).calTotalFields();
        new OrderAlgorithm(childorder, (IPageCache)new LocalPageCache()).calTotalFields();
        BigDecimal usedbalance = this.getNullToZero(parentorder, "usedbalance");
        if (usedbalance.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal parenttotalorderamount = this.getNullToZero(parentorder, "totalorderamount");
            BigDecimal childtotalorderamount = this.getNullToZero(childorder, "totalorderamount");
            BigDecimal parentusedbalance = BigDecimal.ZERO;
            if (parenttotalorderamount.compareTo(BigDecimal.ZERO) > 0) {
                parentusedbalance = usedbalance.multiply(parenttotalorderamount).divide(parenttotalorderamount.add(childtotalorderamount), 2, RoundingMode.HALF_UP);
            }
            parentorder.set("usedbalance", (Object)parentusedbalance);
            childorder.set("usedbalance", (Object)usedbalance.subtract(parentusedbalance));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentorder, childorder});
    }

    protected void updateParentEntry(DynamicObject parentorder, DynamicObject parententry, BigDecimal parentqty, BigDecimal qty) {
        for (String[] qtyfield : this.getQtyFields()) {
            BigDecimal oldqty = parententry.getBigDecimal(qtyfield[0]);
            DynamicObject unit = parententry.getDynamicObject(qtyfield[1]);
            int precision = unit == null ? 0 : unit.getInt("precision");
            parententry.set(qtyfield[0], (Object)oldqty.multiply(parentqty).divide(qty, precision, RoundingMode.HALF_UP));
        }
        for (String[] amountfield : this.getAmountFields()) {
            BigDecimal oldamount = parententry.getBigDecimal(amountfield[0]);
            int precision = parentorder.getDynamicObject(amountfield[1]).getInt("amtprecision");
            parententry.set(amountfield[0], (Object)oldamount.multiply(parentqty).divide(qty, precision, RoundingMode.HALF_UP));
        }
    }

    protected void updateChildEntry(DynamicObject parententry, DynamicObject childentry) {
        for (String[] qtyfield : this.getQtyFields()) {
            BigDecimal oldqty = childentry.getBigDecimal(qtyfield[0]);
            childentry.set(qtyfield[0], (Object)oldqty.subtract(parententry.getBigDecimal(qtyfield[0])));
        }
        for (String[] amountfield : this.getAmountFields()) {
            BigDecimal oldamount = childentry.getBigDecimal(amountfield[0]);
            childentry.set(amountfield[0], (Object)oldamount.subtract(parententry.getBigDecimal(amountfield[0])));
        }
    }

    protected int getIndexByEntryid(DynamicObjectCollection col, Object entryid) {
        for (int i = 0; i < col.size(); ++i) {
            if (!entryid.equals(((DynamicObject)col.get(i)).getPkValue())) continue;
            return i;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u5408\u4e2d\u627e\u4e0d\u5230%s\u7684\u5bf9\u8c61", (String)"SaleOrderConfirmApart_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), entryid));
    }

    protected String[] getIgnoredCopyFields() {
        return new String[]{"billno", "itementry", "creator", "createtime", "modifier", "modifytime", "parentorderid"};
    }

    protected String[][] getQtyFields() {
        return new String[][]{{"qty", "unit"}, {"baseqty", "baseunit"}, {"assistqty", "assistunit"}};
    }

    protected String[][] getAmountFields() {
        return new String[][]{{"itemamount", "currency"}, {"primamount", "currency"}, {"promotionamount", "currency"}, {"rebateamount", "currency"}, {"taxamount", "currency"}, {"discountamount", "currency"}, {"tax", "currency"}, {"amount", "currency"}, {"entryusedrebate", "currency"}, {"localtax", "localcurrency"}, {"localtaxamount", "localcurrency"}, {"localamount", "localcurrency"}};
    }

    private static class CheckQtyValidator
    extends AbstractValidator {
        private CheckQtyValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity data : this.getDataEntities()) {
                DynamicObjectCollection entrys = data.getDataEntity().getDynamicObjectCollection("itementry");
                BigDecimal tatalparentqty = BigDecimal.ZERO;
                BigDecimal totalchildqty = BigDecimal.ZERO;
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    tatalparentqty = tatalparentqty.add(entry.getBigDecimal("parentqty"));
                    totalchildqty = totalchildqty.add(entry.getBigDecimal("childqty"));
                }
                if (tatalparentqty.compareTo(BigDecimal.ZERO) != 0 && totalchildqty.compareTo(BigDecimal.ZERO) != 0) continue;
                this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u6240\u6709\u5206\u5f55\u7684\u5b50\u5355\u6570\u91cf\u6216\u6bcd\u5355\u6570\u91cf\u90fd\u4e3a0\uff0c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u62c6\u5355\u6570\u91cf", (String)"SaleOrderConfirmApart_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

