/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.cache.LRUCache;
import kd.drp.mdr.common.cache.model.ItemSaleInfo;
import kd.drp.mdr.common.cache.model.PathSaleInfo;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.opplugin.ImportCache;
import kd.drp.mdr.opplugin.handle.ImportHandle;

public class SaleOrderImportPlugin
implements IImportPlugin {
    private ImportHandle handle = new ImportHandle();
    private final ImportCache cache = new ImportCache();
    private PathSaleInfo rules;
    private ItemSaleInfo info;
    private String customerRelationKey;
    private boolean isUseWareHouseRule = SysParamsUtil.isUseWareHouseRule();
    private DynamicObject currency = null;
    private LRUCache<String, List<Object>> wareHousesMap;
    private LRUCache<String, Integer> leadTimeCache;
    private LRUCache<String, Object> regionCache;
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private UnitBatchHandler unitHandler;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        CheckResult result = null;
        try {
            result = this.checkImportData(data);
        }
        catch (Exception e) {
            result = new CheckResult(false, e.getMessage());
        }
        if (result.isSuccess()) {
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(result.getMsg()));
        return false;
    }

    private CheckResult checkImportData(Map<String, Object> data) {
        CheckResult result;
        if (this.currency == null) {
            this.currency = this.getDefaultCurrency();
        }
        if (!(result = this.handlerOwner(data)).isSuccess()) {
            return result;
        }
        result = this.handlerCustomer(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerDispatch(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerSaler(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerRecipt(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerHeadWarehouse(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerDirectCustomer(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerReceivableCompany(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerTransportType(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerHeadDate(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerCustomerPhone(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerEntrys(data);
        if (!result.isSuccess()) {
            return result;
        }
        this.handlerRegion(data);
        this.createAmountInfos(data);
        return CheckResult.returnTrue();
    }

    private void createAmountInfos(Map<String, Object> data) {
        JSONArray entrys = (JSONArray)data.get("itementry");
        Map<String, BigDecimal> vals = SaleOrderImportPlugin.handleOrderTotalQtysAndAmounts(entrys);
        for (Map.Entry<String, BigDecimal> val : vals.entrySet()) {
            data.put(val.getKey(), val.getValue());
        }
    }

    private CheckResult handlerCustomerPhone(Map<String, Object> data) {
        String customerPhone = data.get("customerphone").toString();
        if (!StringUtils.isEmpty((String)customerPhone)) {
            return ValidateUtils.validMobPhone((String)customerPhone);
        }
        return CheckResult.returnTrue();
    }

    private void handlerRegion(Map<String, Object> data) {
        JSONObject owner = (JSONObject)data.get("owner");
        JSONObject customer = (JSONObject)data.get("customer");
        Object regionId = this.getRegion(owner.get((Object)ID), customer.get((Object)ID));
        if (regionId != null) {
            this.handleId("region", regionId, data);
        }
    }

    private CheckResult handlerEntrys(Map<String, Object> data) {
        JSONArray entrys = (JSONArray)data.get("itementry");
        if (entrys == null || entrys.size() == 0) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderImportPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        CheckResult entryResult = null;
        JSONObject entry = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            entry = entrys.getJSONObject(i);
            entryResult = this.checkEntry(data, entry);
            if (entryResult.isSuccess()) continue;
            return CheckResult.returnFalse((String)entryResult.getMsg());
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerEntryDate(Map<String, Object> data, JSONObject entry) {
        String arrivaldateStr = (String)entry.get((Object)"arrivaldate");
        Date now = DateUtil.getNowDate();
        if (StringUtils.isEmpty((String)arrivaldateStr)) {
            entry.put("entryarrivaldate", data.get("arrivaldate"));
        } else {
            int leadTime;
            Date limitDate;
            JSONObject owner = (JSONObject)data.get("owner");
            JSONObject customer = (JSONObject)data.get("customer");
            Date arrivaldate = DateUtil.formatDate((String)arrivaldateStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (arrivaldate.before(limitDate = DateUtil.getNextDate((Date)now, (int)(leadTime = this.queryLeadTime(owner.get((Object)ID), customer.get((Object)ID)))))) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u5206\u5f55\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\uff1a%s", (String)"SaleOrderImportPlugin_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)limitDate)));
            }
        }
        String confirmarrivaldateStr = (String)entry.get((Object)"confirmarrivaldate");
        if (StringUtils.isEmpty((String)confirmarrivaldateStr)) {
            entry.put("entryconfirmarrivaldate", data.get("confirmarrivaldate"));
        } else {
            Date confirmarrivaldate = DateUtil.formatDate((String)confirmarrivaldateStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (confirmarrivaldate.before(now)) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u5206\u5f55\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a%s", (String)"SaleOrderImportPlugin_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)now)));
            }
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerHeadDate(Map<String, Object> data) {
        int leadTime;
        Date limitDate;
        Date arrivaldate;
        Date now = DateUtil.getNowDate();
        JSONObject owner = (JSONObject)data.get("owner");
        JSONObject customer = (JSONObject)data.get("customer");
        String arrivaldateStr = (String)data.get("arrivaldate");
        if (!StringUtils.isEmpty((String)arrivaldateStr) && (arrivaldate = DateUtil.formatDate((String)arrivaldateStr, (String)"yyyy-MM-dd HH:mm:ss")).before(limitDate = DateUtil.getNextDate((Date)now, (int)(leadTime = this.queryLeadTime(owner.get((Object)ID), customer.get((Object)ID)))))) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u8981\u6c42\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\uff1a", (String)"SaleOrderImportPlugin_3", (String)"drp-bbc-opplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)limitDate)));
        }
        String confirmarrivaldateStr = (String)data.get("confirmarrivaldate");
        if (!StringUtils.isEmpty((String)confirmarrivaldateStr)) {
            Date confirmarrivaldate = DateUtil.formatDate((String)confirmarrivaldateStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (confirmarrivaldate.before(now)) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u4ea4\u8d27\u65e5\u671f\u4e0d\u65e9\u4e8e\uff1a%s", (String)"SaleOrderImportPlugin_4", (String)"drp-bbc-opplugin", (Object[])new Object[0]), DateUtil.getDateFormat((Date)now)));
            }
        } else {
            data.put("confirmarrivaldate", arrivaldateStr);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerTransportType(Map<String, Object> data) {
        String transportTypeNumber = this.handle.getNumber(data, "transporttype");
        if (!StringUtils.isEmpty((String)transportTypeNumber)) {
            Object transportTypeId = this.cache.getTransportTypeIdFromCache(transportTypeNumber);
            if (transportTypeId != null) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u8fd0\u8f93\u65b9\u5f0f\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]), transportTypeNumber));
            }
            this.handleId("transporttype", transportTypeId, data);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerReceivableCompany(Map<String, Object> data) {
        String receivableCompanyNumber = this.handle.getNumber(data, "receivablecompany");
        JSONObject owner = (JSONObject)data.get("owner");
        if (!StringUtils.isEmpty((String)receivableCompanyNumber)) {
            Object receivableCompanyId = this.getReceivableCompanyId(owner.get((Object)ID), receivableCompanyNumber);
            if (receivableCompanyId == null) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u6536\u6b3e\u516c\u53f8\u3010%s\u3011", (String)"SaleOrderImportPlugin_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]), owner.getString(NUMBER), receivableCompanyNumber));
            }
            this.handleId("receivablecompany", receivableCompanyId, data);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerDirectCustomer(Map<String, Object> data) {
        String colName = "directcustomer";
        String directCustomerNumber = this.handle.getNumber(data, colName);
        JSONObject customer = (JSONObject)data.get("customer");
        if (StringUtils.isEmpty((String)directCustomerNumber)) {
            data.put(colName, customer);
        } else {
            Object directCustomerId = this.getDirectCustomerId(customer.get((Object)ID), directCustomerNumber);
            if (directCustomerId == null) {
                return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u76f4\u9001\u6e20\u9053\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]), directCustomerNumber));
            }
            this.handleId(colName, directCustomerId, data);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerHeadWarehouse(Map<String, Object> data) {
        String warehouseNumber = this.handle.getNumber(data, "warehouse");
        if (StringUtils.isEmpty((String)warehouseNumber)) {
            return CheckResult.returnTrue();
        }
        JSONObject owner = (JSONObject)data.get("owner");
        JSONObject customer = (JSONObject)data.get("customer");
        Object warehouseId = this.getHeadWarehouseId(warehouseNumber, owner.get((Object)ID), customer.get((Object)ID));
        if (warehouseId == null) {
            return CheckResult.returnFalse((String)String.format(ResManager.loadKDString((String)"\u5355\u5934\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_8", (String)"drp-bbc-opplugin", (Object[])new Object[0]), warehouseNumber));
        }
        this.handleId("warehouse", warehouseId, data);
        return CheckResult.returnTrue();
    }

    private CheckResult handlerCustomer(Map<String, Object> data) {
        JSONObject owner = (JSONObject)data.get("owner");
        String customerNumber = this.handle.getNumber(data, "customer");
        Object customerId = null;
        if (StringUtils.isEmpty((String)customerNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderImportPlugin_9", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        customerId = this.cache.getCustomerIdFromCache(customerNumber);
        if (customerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5ba2\u6237\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_10", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customerNumber});
        }
        boolean authRelation = this.handle.isAuthRelation(owner.get((Object)ID), customerId);
        if (!authRelation) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u5ba2\u6237\u3010%s\u3011", (String)"SaleOrderImportPlugin_11", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{owner.getString(NUMBER), customerNumber});
        }
        JSONObject obj = (JSONObject)data.get("customer");
        obj.put(ID, customerId);
        return CheckResult.returnTrue();
    }

    private CheckResult handlerOwner(Map<String, Object> data) {
        String ownerNumber = this.handle.getNumber(data, "owner");
        Object ownerId = null;
        if (StringUtils.isEmpty((String)ownerNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderImportPlugin_12", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        ownerId = this.handle.queryMyOwnerId(ownerNumber);
        if (ownerId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u4f9b\u8d27\u6e20\u9053\u3010%s\u3011", (String)"SaleOrderImportPlugin_13", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{ownerNumber});
        }
        JSONObject obj = (JSONObject)data.get("owner");
        obj.put(ID, ownerId);
        return CheckResult.returnTrue();
    }

    private CheckResult handlerRecipt(Map<String, Object> data) {
        String receiptNumber = this.handle.getNumber(data, "receipt");
        JSONObject customer = (JSONObject)data.get("customer");
        if (!StringUtils.isEmpty((String)receiptNumber)) {
            Object receiptId = this.getReceiptId(customer.get((Object)ID), receiptNumber);
            if (receiptId != null) {
                this.handleId("receipt", receiptId, data);
            } else {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5ba2\u6237\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u5f00\u7968\u4fe1\u606f\u3010%s\u3011", (String)"SaleOrderImportPlugin_14", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customer.getString(NUMBER), receiptNumber});
            }
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handlerSaler(Map<String, Object> data) {
        String salerPhone = this.handle.getNumber(data, "saler");
        if (StringUtils.isEmpty((String)salerPhone)) {
            return CheckResult.returnTrue();
        }
        Object id = this.cache.getSysuserIdByPhoneFromCache(salerPhone);
        JSONObject owner = (JSONObject)data.get("owner");
        JSONObject customer = (JSONObject)data.get("customer");
        if (id != null && this.checkSaleExsist(owner.get((Object)ID), customer.get((Object)ID), id)) {
            this.handleId("saler", id, data);
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u4e1a\u52a1\u5458\u3010%s\u3011", (String)"SaleOrderImportPlugin_15", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{owner.getString(NUMBER), salerPhone});
    }

    private CheckResult handlerDispatch(Map<String, Object> data) {
        String dispatcherPhone = this.handle.getNumber(data, "dispatcher");
        if (StringUtils.isEmpty((String)dispatcherPhone)) {
            return CheckResult.returnTrue();
        }
        JSONObject owner = (JSONObject)data.get("owner");
        Object id = this.cache.getSysuserIdByPhoneFromCache(dispatcherPhone);
        if (id != null && this.checkDispatcherExsist(owner.get((Object)ID), id)) {
            this.handleId("dispatcher", id, data);
            return CheckResult.returnTrue();
        }
        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053owner\u3010%s\u3011\u4e0b\u4e0d\u5b58\u5728\u914d\u8d27\u5458\u3010%s\u3011", (String)"SaleOrderImportPlugin_16", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{owner.getString(NUMBER), dispatcherPhone});
    }

    private void handleId(String colName, Object id, Map<String, Object> targetObj) {
        this.handleColValue(colName, ID, id, targetObj);
    }

    private void handleColValue(String colName, String key, Object value, Map<String, Object> targetObj) {
        JSONObject idObj = new JSONObject();
        idObj.put(key, value);
        targetObj.put(colName, idObj);
    }

    private Object getRegion(Object ownerId, Object customerId) {
        if (this.regionCache == null) {
            this.regionCache = new LRUCache(64);
        }
        String key = ownerId.toString() + customerId;
        Object regionId = null;
        if (this.regionCache.containsKey((Object)key)) {
            regionId = this.regionCache.get((Object)key);
        } else {
            QFilter[] fs = new QFilter[]{new QFilter("customer", "=", customerId), new QFilter("authowner", "=", ownerId)};
            DynamicObject regionInfo = QueryServiceHelper.queryOne((String)"mdr_customer_authorize", (String)"region", (QFilter[])fs);
            if (regionInfo != null) {
                regionId = regionInfo.get("region");
            }
            this.regionCache.put((Object)key, regionId);
        }
        return regionId;
    }

    public static Map<String, BigDecimal> handleOrderTotalQtysAndAmounts(JSONArray orderEntrys) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal primAmount = BigDecimal.ZERO;
        BigDecimal itemAmount = BigDecimal.ZERO;
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal hightPriceRatio = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalBaseQty = BigDecimal.ZERO;
        BigDecimal totalAssistQty = BigDecimal.ZERO;
        BigDecimal totalAlterQty = BigDecimal.ZERO;
        BigDecimal totalAlterBaseQty = BigDecimal.ZERO;
        BigDecimal totalAlterAssistQty = BigDecimal.ZERO;
        JSONObject entry = null;
        for (int i = 0; i < orderEntrys.size(); ++i) {
            entry = orderEntrys.getJSONObject(i);
            primAmount = primAmount.add(entry.getBigDecimal("primamount"));
            itemAmount = itemAmount.add(entry.getBigDecimal("itemamount"));
            orderAmount = orderAmount.add(entry.getBigDecimal("orderamount"));
            totalQty = totalQty.add(entry.getBigDecimal("qty"));
            totalBaseQty = totalBaseQty.add(entry.getBigDecimal("baseqty"));
            totalAssistQty = totalAssistQty.add(entry.getBigDecimal("assistqty"));
            totalAlterQty = totalAlterQty.add(entry.getBigDecimal("alterqty"));
            totalAlterBaseQty = totalAlterBaseQty.add(entry.getBigDecimal("alterbaseqty"));
            totalAlterAssistQty = totalAlterAssistQty.add(entry.getBigDecimal("alterassistqty"));
        }
        if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
            hightPriceRatio = orderAmount.subtract(itemAmount).divide(itemAmount, 4, 4).multiply(new BigDecimal(100));
        }
        map.put("totalprimamount", primAmount);
        map.put("totalitemamount", itemAmount);
        map.put("totalorderamount", orderAmount);
        map.put("totalhightpriceratio", hightPriceRatio);
        map.put("amounttobepaid", orderAmount);
        map.put("totalqty", totalQty);
        map.put("totalbaseqty", totalBaseQty);
        map.put("totalassistqty", totalAssistQty);
        map.put("totalalterqty", totalAlterQty);
        map.put("totalalterbaseqty", totalAlterBaseQty);
        map.put("totalalterassistqty", totalAlterAssistQty);
        return map;
    }

    private int queryLeadTime(Object ownerId, Object customerId) {
        String key;
        Integer leadTime;
        if (this.leadTimeCache == null) {
            this.leadTimeCache = new LRUCache(8);
        }
        if ((leadTime = (Integer)this.leadTimeCache.get((Object)(key = ownerId.toString() + customerId))) == null) {
            leadTime = CustomerUtil.getAuthBizInfo((Object)ownerId, (Object)customerId).getInt("leadtime");
            this.leadTimeCache.put((Object)key, (Object)leadTime);
        }
        return leadTime;
    }

    private DynamicObject getDefaultCurrency() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_currency");
    }

    private Object getHeadWarehouseId(String warehouseNumber, Object ownerId, Object customerId) {
        Object id = this.cache.getWareHouseIdFromCache(warehouseNumber);
        if (id == null) {
            return null;
        }
        List<Object> ids = null;
        if (ids == null) {
            ids = this.isUseWareHouseRule ? this.getWareFromCache(ownerId, customerId) : this.getWareFromCache(ownerId);
        }
        if (ids.contains(id)) {
            return id;
        }
        return null;
    }

    private CheckResult checkEntry(Map<String, Object> data, JSONObject entry) {
        CheckResult result = this.handleItem(data, entry);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handleQtyAndAmounts(data, entry);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handleEntryWareHouse(data, entry);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handleEntryReceiveWarehouse(data, entry);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.handlerEntryDate(data, entry);
        if (!result.isSuccess()) {
            return result;
        }
        this.handleCopyInfos(data, entry);
        return CheckResult.returnTrue();
    }

    protected UnitBatchHandler getUnitBatchHandler() {
        if (this.unitHandler == null) {
            this.unitHandler = new UnitBatchHandler();
        }
        return this.unitHandler;
    }

    private void handleCopyInfos(Map<String, Object> data, JSONObject entry) {
        String consignee = entry.getString("consignee");
        String consigneephone = entry.getString("consigneephone");
        String consigneeaddress = entry.getString("consigneeaddress");
        if (StringUtils.isEmpty((String)consignee) || StringUtils.isEmpty((String)consigneephone) || StringUtils.isEmpty((String)consigneeaddress)) {
            entry.put("entryconsignee", data.get("consignee"));
            entry.put("entryconsigneephone", data.get("consigneephone"));
            entry.put("entryaddress", data.get("address"));
        }
    }

    private CheckResult handleEntryReceiveWarehouse(Map<String, Object> data, JSONObject entry) {
        JSONObject customer = (JSONObject)data.get("customer");
        String entryReceiveWarehouse = this.handle.getNumber((Map)entry, "entryreceivewarehouse");
        if (!StringUtils.isEmpty((String)entryReceiveWarehouse)) {
            Object id = this.getEntryReceiveWarehouse(entryReceiveWarehouse, customer.get((Object)ID));
            if (id == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u6536\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_17", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryReceiveWarehouse});
            }
            this.handleId("entryreceivewarehouse", id, (Map<String, Object>)entry);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handleEntryWareHouse(Map<String, Object> data, JSONObject entry) {
        String entryWarehouseNumber = this.handle.getNumber((Map)entry, "entrywarehouse");
        String warehouseNumber = this.handle.getNumber(data, "warehouse");
        if (this.isUseWareHouseRule) {
            if (StringUtils.isNotEmpty((String)warehouseNumber)) {
                if (StringUtils.isNotEmpty((String)entryWarehouseNumber) && !warehouseNumber.equals(entryWarehouseNumber)) {
                    return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u5fc5\u987b\u4e0e\u5355\u5934\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e00\u81f4", (String)"SaleOrderImportPlugin_18", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryWarehouseNumber, warehouseNumber});
                }
                entry.put("entrywarehouse", data.get("warehouse"));
                return CheckResult.returnTrue();
            }
            if (StringUtils.isNotEmpty((String)entryWarehouseNumber)) {
                Object id = this.cache.getWareHouseIdFromCache(entryWarehouseNumber);
                if (id == null) {
                    return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_19", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryWarehouseNumber});
                }
                JSONObject customer = (JSONObject)data.get("customer");
                JSONObject owner = (JSONObject)data.get("owner");
                JSONObject item = (JSONObject)entry.get((Object)"item");
                List<Object> ids = this.getWareFromCache(owner.get((Object)ID), customer.get((Object)ID), item.get((Object)ID));
                if (ids == null || !ids.contains(id)) {
                    return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_19", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryWarehouseNumber});
                }
                this.handleId("entrywarehouse", id, (Map<String, Object>)entry);
            }
        } else if (StringUtils.isNotEmpty((String)entryWarehouseNumber)) {
            Object id = this.cache.getWareHouseIdFromCache(entryWarehouseNumber);
            if (id == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_19", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryWarehouseNumber});
            }
            JSONObject owner = (JSONObject)data.get("owner");
            List<Object> ids = this.getWareFromCache(owner.get((Object)ID));
            if (ids == null || !ids.contains(id)) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u53d1\u8d27\u5730\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_19", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryWarehouseNumber});
            }
            this.handleId("entrywarehouse", id, (Map<String, Object>)entry);
        } else {
            entry.put("entrywarehouse", data.get("warehouse"));
        }
        return CheckResult.returnTrue();
    }

    private CheckResult handleQtyAndAmounts(Map<String, Object> data, JSONObject entry) {
        JSONObject item = entry.getJSONObject("item");
        Object itemId = item.get((Object)ID);
        DynamicObject itemInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"mdr_item_info", (String)"entry_measureunits.measureunit,entry_measureunits.isbaseunit,entry_measureunits.isassistunit");
        DynamicObjectCollection units = itemInfo.getDynamicObjectCollection("entry_measureunits");
        DynamicObject unit = null;
        DynamicObject baseUnit = null;
        DynamicObject assistUnit = null;
        DynamicObject tempUnit = null;
        String unitNumber = this.handle.getNumber((Map)entry, "unit");
        if (StringUtils.isEmpty((String)unitNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderImportPlugin_20", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{item.getString(NUMBER)});
        }
        for (DynamicObject unitRow : units) {
            tempUnit = unitRow.getDynamicObject("measureunit");
            if (unitNumber.equals(tempUnit.getString(NUMBER))) {
                unit = tempUnit;
            }
            if ("1".equals(unitRow.getString("isbaseunit"))) {
                baseUnit = tempUnit;
            }
            if ("1".equals(unitRow.getString("isassistunit"))) {
                assistUnit = tempUnit;
            }
            tempUnit = null;
        }
        if (unit == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_21", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{item.getString(NUMBER), unitNumber});
        }
        this.handleId("unit", unit.get(ID), (Map<String, Object>)entry);
        if (baseUnit == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u672a\u5b9a\u4e49\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d", (String)"SaleOrderImportPlugin_22", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{item.getString(NUMBER)});
        }
        this.handleId("baseunit", baseUnit.get(ID), (Map<String, Object>)entry);
        if (assistUnit != null) {
            this.handleId("assistunit", assistUnit.get(ID), (Map<String, Object>)entry);
        }
        BigDecimal alterQty = entry.getBigDecimal("alterqty");
        BigDecimal alterAssistQty = entry.getBigDecimal("alterassistqty");
        BigDecimal alterBaseQty = null;
        if (alterQty != null && assistUnit != null) {
            alterBaseQty = this.getUnitBatchHandler().getBaseQty(itemId, alterQty, unit.getPkValue());
            alterAssistQty = this.getUnitBatchHandler().getUnitQty(itemId, assistUnit.getPkValue(), alterBaseQty);
        } else if (alterAssistQty != null && assistUnit != null) {
            alterQty = this.getUnitBatchHandler().getQtyFromAssistUnit(itemId, assistUnit.getPkValue(), alterAssistQty, unit.getPkValue());
            alterBaseQty = this.getUnitBatchHandler().getBaseQty(itemId, alterQty, unit.getPkValue());
        }
        if (alterBaseQty == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u4e0b\u5355\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (String)"SaleOrderImportPlugin_23", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        BigDecimal itemPrice = BigDecimal.ZERO;
        BigDecimal price = entry.getBigDecimal("price");
        String custchangeprice = "0";
        if (price == null) {
            price = itemPrice;
        } else {
            custchangeprice = "1";
        }
        BigDecimal ratio = BigDecimal.ZERO;
        if (itemPrice.compareTo(BigDecimal.ZERO) != 0) {
            ratio = price.subtract(itemPrice).divide(itemPrice, 4, 4).multiply(new BigDecimal(100));
        }
        int amtPrecision = this.currency.getInt("amtprecision");
        BigDecimal primAmount = itemPrice.multiply(alterQty).setScale(amtPrecision, 4);
        BigDecimal orderAmount = price.multiply(alterQty).setScale(amtPrecision, 4);
        entry.put("primamount", (Object)primAmount);
        entry.put("itemamount", (Object)primAmount);
        entry.put("orderamount", (Object)orderAmount);
        entry.put("hightpriceratio", (Object)ratio);
        entry.put("itemprice", (Object)itemPrice);
        entry.put("promotedprice", (Object)itemPrice);
        entry.put("rebatedprice", (Object)itemPrice);
        entry.put("qty", (Object)alterQty);
        entry.put("baseqty", (Object)alterBaseQty);
        entry.put("assistqty", (Object)alterAssistQty);
        entry.put("alterbaseqty", (Object)alterBaseQty);
        entry.put("alterassistqty", (Object)alterAssistQty);
        entry.put("custchangeprice", (Object)custchangeprice);
        return CheckResult.returnTrue();
    }

    private CheckResult handleItem(Map<String, Object> data, JSONObject entry) {
        JSONObject owner = (JSONObject)data.get("owner");
        JSONObject customer = (JSONObject)data.get("customer");
        String itemNumber = this.handle.getNumber((Map)entry, "item");
        if (StringUtils.isEmpty((String)itemNumber)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"SaleOrderImportPlugin_24", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        Object itemId = this.cache.getItemIdFromCache(itemNumber);
        if (itemId == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"SaleOrderImportPlugin_25", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{itemNumber});
        }
        if (!this.checkCanSale(itemId, owner.get((Object)ID), customer.get((Object)ID))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5546\u54c1\u3010%s\u3011\u4e0d\u53ef\u9500", (String)"SaleOrderImportPlugin_26", (String)"drp-bbc-opplugin", (Object[])new Object[0]), (Object[])new Object[]{itemNumber});
        }
        this.handleId("item", itemId, (Map<String, Object>)entry);
        return CheckResult.returnTrue();
    }

    private Object getEntryReceiveWarehouse(String entryReceiveWarehouse, Object customerId) {
        if (StringUtils.isEmpty((String)entryReceiveWarehouse)) {
            return CheckResult.returnTrue();
        }
        Object id = this.cache.getWareHouseIdFromCache(entryReceiveWarehouse);
        if (id == null) {
            return null;
        }
        List<Object> ids = this.getWareFromCache(customerId);
        if (ids == null) {
            return null;
        }
        if (ids.contains(id)) {
            return id;
        }
        return null;
    }

    private List<Object> getWareFromCache(final Object ownerId, final Object customerId) {
        String key = ownerId.toString() + customerId;
        return this.getWareFromCache(key, new QueryWareHouse(){

            @Override
            public List<Object> getIds() {
                return WarehouseRuleUtil.getWarehouseList((Object)ownerId, (Object)customerId);
            }
        });
    }

    private List<Object> getWareFromCache(final Object ownerId, final Object customerId, final Object itemId) {
        String key = ownerId.toString() + customerId + itemId;
        return this.getWareFromCache(key, new QueryWareHouse(){

            @Override
            public List<Object> getIds() {
                return WarehouseRuleUtil.getWarehouseList((Object)ownerId, (Object)customerId, (Object)itemId);
            }
        });
    }

    private List<Object> getWareFromCache(final Object customerId) {
        return this.getWareFromCache(customerId.toString(), new QueryWareHouse(){

            @Override
            public List<Object> getIds() {
                return WarehouseRuleUtil.queryWarehouse((Object)customerId);
            }
        });
    }

    private List<Object> getWareFromCache(String key, QueryWareHouse query) {
        if (this.wareHousesMap == null) {
            this.wareHousesMap = new LRUCache(64);
        }
        if (this.wareHousesMap.containsKey((Object)key)) {
            return (List)this.wareHousesMap.get((Object)key);
        }
        List<Object> ids = query.getIds();
        this.wareHousesMap.put((Object)key, ids);
        return ids;
    }

    private boolean checkCanSale(Object itemId, Object ownerId, Object customerId) {
        PathSaleInfo rules = this.getPathSaleInfo(ownerId, customerId);
        return rules.isItemCanSale(itemId);
    }

    private PathSaleInfo getPathSaleInfo(Object ownerId, Object customerId) {
        PathSaleInfo rules = null;
        String currentCustomerRelationKey = this.createCustomerRelationKey(ownerId, customerId);
        if (currentCustomerRelationKey.equals(this.customerRelationKey)) {
            rules = this.rules;
        } else {
            ItemSaleInfo localInfo = this.getItemSaleInfo();
            rules = localInfo.querySaleRules(ownerId, customerId);
            this.customerRelationKey = currentCustomerRelationKey;
            this.rules = rules;
        }
        return rules;
    }

    private String createCustomerRelationKey(Object ownerId, Object customerId) {
        return ownerId + "_" + customerId;
    }

    private ItemSaleInfo getItemSaleInfo() {
        if (this.info == null) {
            this.info = new ItemSaleInfo();
        }
        return this.info;
    }

    private Object getDirectCustomerId(Object customerId, String directCustomerNumber) {
        Object directCustomerId = this.cache.getCustomerIdFromCache(directCustomerNumber);
        if (customerId.equals(directCustomerId) || directCustomerId != null && this.handle.isAuthRelation(customerId, directCustomerId)) {
            return directCustomerId;
        }
        return null;
    }

    private Object getReceiptId(Object customerId, String receiptNumber) {
        QFilter fs = new QFilter("customer", "=", customerId);
        fs.and("taxnum", "=", (Object)receiptNumber);
        DynamicObject recipt = QueryServiceHelper.queryOne((String)"mdr_receipt", (String)ID, (QFilter[])fs.toArray());
        if (recipt == null) {
            return null;
        }
        return recipt.get(ID);
    }

    private Object getReceivableCompanyId(Object ownerId, String receivableCompanyNumber) {
        QFilter fs = new QFilter("customer", "=", ownerId);
        fs.and("warehouse.number", "=", (Object)receivableCompanyNumber);
        DynamicObject info = QueryServiceHelper.queryOne((String)"mdr_warehouse_relation", (String)"id,warehouse.id", (QFilter[])fs.toArray());
        if (info == null) {
            return null;
        }
        return info.get("warehouse.id");
    }

    private boolean checkDispatcherExsist(Object ownerId, Object sysId) {
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("sysuser", "=", sysId);
        fs.and("enable", "=", (Object)"1");
        fs.and("isdispatcher", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"dbd_drp_user", (QFilter[])fs.toArray());
    }

    private boolean checkSaleExsist(Object ownerId, Object customerId, Object sysId) {
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("customer", "=", customerId);
        fs.and("user", "=", sysId);
        return QueryServiceHelper.exists((String)"mdr_cust_saler_relation", (QFilter[])fs.toArray());
    }

    private static interface QueryWareHouse {
        public List<Object> getIds();
    }
}

