/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class SaleOrderSubmitOpPlugin
extends MdrBaseOperationServicePlugIn {
    private static String[] status = new String[]{"B", "C", "D", "E", "F", "G", "h", "J", "K", "L", "M"};

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String opKey = e.getOperationKey();
        if ("submit".equals(opKey)) {
            this.submitBefor(e);
        }
    }

    protected void submitBefor(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject dny = objs[i];
            DynamicObjectCollection dnyEntryCol = dny.getDynamicObjectCollection("itementry");
            if (this.isContainsField(dny, "itementry")) {
                if (dnyEntryCol == null || dnyEntryCol.size() == 0) continue;
                DynamicObject entry = (DynamicObject)dnyEntryCol.get(0);
                boolean isAddNew = SaleOrderSubmitOpPlugin.isAddNew(dny);
                if (isAddNew) {
                    if (!this.isContainsField(entry, "itementry.sourcebillid")) continue;
                    this.checkSubmit(dny);
                    continue;
                }
                if (this.isContainsField(entry, "itementry.sourcebillid")) {
                    this.checkSubmit(dny);
                    continue;
                }
                StringBuilder selector = this.getSelector();
                DynamicObject checkInfo = BusinessDataServiceHelper.loadSingle((Object)dny.getPkValue(), (String)dny.getDataEntityType().getName(), (String)selector.toString());
                this.checkSubmit(checkInfo);
                continue;
            }
            StringBuilder selector = this.getSelector();
            DynamicObject checkInfo = BusinessDataServiceHelper.loadSingle((Object)dny.getPkValue(), (String)dny.getDataEntityType().getName(), (String)selector.toString());
            this.checkSubmit(checkInfo);
        }
    }

    private StringBuilder getSelector() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("billno,");
        selector.append("itementry,");
        selector.append("itementry.sourcebillid,");
        selector.append("itementry.sourcebillentryid,");
        selector.append("itementry.orderamount,");
        selector.append("itementry.item,");
        selector.append("itementry.item.id,");
        selector.append("itementry.item.number,");
        selector.append("itementry.item.name");
        return selector;
    }

    protected void checkSubmit(DynamicObject dny) {
        String number = dny.getString("billno");
        DynamicObjectCollection entryCol = dny.getDynamicObjectCollection("itementry");
        if (entryCol != null && entryCol.size() != 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                BigDecimal contractAmt;
                BigDecimal totalAmount;
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                String sourcebillid = entry.getString("sourcebillid");
                String sourcebillentryid = entry.getString("sourcebillentryid");
                if (sourcebillid == null || sourcebillid.trim().length() == 0 || sourcebillentryid == null || sourcebillentryid.trim().length() == 0 || (totalAmount = this.getOrderAmount(entry, sourcebillid, sourcebillentryid)).compareTo(contractAmt = this.getContractAmt(sourcebillid, sourcebillentryid)) <= 0) continue;
                int rowNumber = i + 1;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355[%s]\u7b2c%s\u884c\uff0c\u9500\u552e\u5355\u7684\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u5206\u5f55\u91d1\u989d", (String)"SaleOrderSubmitOpPlugin_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]), number, rowNumber));
            }
        }
    }

    private BigDecimal getOrderAmount(DynamicObject entry, String sourcebillid, String sourcebillentryid) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("sourcebillid", "=", (Object)sourcebillid));
        filterList.add(new QFilter("sourcebillentryid", "=", (Object)sourcebillentryid));
        filterList.add(new QFilter("order.orderstatus", "in", (Object)status));
        if (entry.getPkValue() != null) {
            filterList.add(new QFilter(entry.getDynamicObjectType().getPrimaryKey().getName(), "<>", entry.getPkValue()));
        }
        DynamicObject[] saleorderEntryCol = BusinessDataServiceHelper.load((String)"mdr_saleorder_entry", (String)"orderamount", (QFilter[])filterList.toArray(new QFilter[1]));
        BigDecimal totalAmount = entry.getBigDecimal("orderamount");
        if (totalAmount == null) {
            totalAmount = BigDecimal.ZERO;
        }
        for (int j = 0; j < saleorderEntryCol.length; ++j) {
            DynamicObject saleorderEntry = saleorderEntryCol[j];
            BigDecimal amount = saleorderEntry.getBigDecimal("orderamount");
            if (amount == null) {
                amount = BigDecimal.ZERO;
            }
            totalAmount = totalAmount.add(amount);
        }
        return totalAmount;
    }

    private BigDecimal getContractAmt(String sourcebillid, String sourcebillentryid) {
        DynamicObjectCollection entryCol;
        BigDecimal amount = BigDecimal.ZERO;
        String selector = "id,entryentity,entryentity.amount";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)};
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"mdr_salecontract", (String)selector, (QFilter[])filters);
        if (contracts != null && contracts.length != 0 && (entryCol = contracts[0].getDynamicObjectCollection("entryentity")) != null && entryCol.size() != 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCol.get(i);
                if (!sourcebillentryid.equals(entry.getPkValue().toString())) continue;
                amount = entry.getBigDecimal("amount");
                if (amount == null) {
                    amount = BigDecimal.ZERO;
                }
                return amount;
            }
        }
        return amount;
    }

    protected static boolean isAddNew(DynamicObject obj) {
        Long longValue;
        Object pkValue = obj.getPkValue();
        if (pkValue == null) {
            return true;
        }
        if (pkValue instanceof Long ? (longValue = (Long)pkValue) == 0L : pkValue.toString().trim().length() == 0) {
            return true;
        }
        return !QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (Object)pkValue);
    }

    protected boolean isContainsField(DynamicObject info, String field) {
        boolean rs = true;
        try {
            Object object = info.get(field);
        }
        catch (Exception e) {
            rs = false;
        }
        return rs;
    }
}

