/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.opplugin.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.model.SynResult;

public class SynSaleContractUtil {
    public static SynResult synSaleContractDelete(DynamicObject saleCon) {
        Object saleConId = saleCon.getPkValue();
        if (saleConId == null || StringUtils.isEmpty((String)saleConId.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c\u5355\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"SynSaleContractUtil_0", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> data2 = new HashMap<String, Object>();
        data2.put("PK_ID", saleConId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", data2);
        return SynSaleContractUtil.synDeleteMessageSendOut(data, saleConId);
    }

    public static SynResult synSaleContract(Object saleConId) {
        if (saleConId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"SynSaleContractUtil_1", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> data = new HashMap<String, Object>(64);
        StringBuilder selector = SynSaleContractUtil.getSelectors();
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", saleConId)};
        DynamicObject[] saleCons = BusinessDataServiceHelper.load((String)"mdr_salecontract", (String)selector.toString(), (QFilter[])filters);
        if (saleCons != null && saleCons.length != 0) {
            String imageServerUrl;
            DynamicObject saleConInfo = saleCons[0];
            if (saleConInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728\uff01", (String)"SynSaleContractUtil_2", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            data.put("PK_ID", saleConInfo.getPkValue());
            data.put("billno", saleConInfo.getString("billno"));
            data.put("settlementtype", saleConInfo.getString("settlementtype.number"));
            data.put("customer", saleConInfo.getString("customer.easnumber"));
            data.put("signAddress", saleConInfo.getString("signaddress"));
            data.put("contractType.number", saleConInfo.getString("contracttype.number"));
            data.put("bizdate", saleConInfo.getDate("bizDate"));
            data.put("validTo", saleConInfo.getDate("validTo"));
            data.put("deliveryAddress", saleConInfo.getString("deliveryAddress"));
            data.put("description", saleConInfo.getString("remark"));
            data.put("creator.phone", saleConInfo.getString("creator.phone"));
            data.put("customergroup.number", saleConInfo.getString("customergroup.number"));
            data.put("totalqty", saleConInfo.getBigDecimal("totalqty"));
            data.put("carryfee", saleConInfo.getBigDecimal("carryfee"));
            data.put("contractprice", saleConInfo.getBigDecimal("contractprice"));
            data.put("netprice", saleConInfo.getBigDecimal("netprice"));
            data.put("paydate", saleConInfo.getDate("paydate"));
            data.put("orderrequire", saleConInfo.getString("orderrequire"));
            data.put("qualityrequire", saleConInfo.getString("qualityrequire"));
            data.put("contratclass", saleConInfo.getString("contratclass"));
            data.put("contractform", saleConInfo.getString("contractform"));
            data.put("distribut.number", saleConInfo.getString("distribut.number"));
            data.put("recoverytype", saleConInfo.getString("recoverytype"));
            if (EntityMetadataCache.getDataEntityType((String)"mdr_salecontract").getAllFields().get("package1") != null) {
                data.put("package1", saleConInfo.getString("package1"));
            }
            if (EntityMetadataCache.getDataEntityType((String)"mdr_salecontract").getAllFields().get("standard") != null) {
                data.put("standard", saleConInfo.getString("standard"));
            }
            data.put("paycondition", saleConInfo.getString("paycondition"));
            data.put("factorytxt", saleConInfo.getString("factorytxt"));
            data.put("package", saleConInfo.getString("package"));
            String bearing = saleConInfo.getString("bearing");
            if ("A".equals(bearing)) {
                data.put("bearing", "\u4f9b\u65b9");
            } else if ("B".equals(bearing)) {
                data.put("bearing", "\u9700\u65b9");
            } else {
                data.put("bearing", "");
            }
            DynamicObjectCollection saleConEntrys = (DynamicObjectCollection)saleConInfo.get("entryentity");
            if (saleConEntrys == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728\u5546\u54c1\uff01", (String)"SynSaleContractUtil_5", (String)"drp-bbc-opplugin", (Object[])new Object[0]));
            }
            ArrayList listMaps = new ArrayList(saleConEntrys.size());
            for (int i = 0; i < saleConEntrys.size(); ++i) {
                DynamicObject saleConEntry = (DynamicObject)saleConEntrys.get(i);
                HashMap<String, Object> entrydata = new HashMap<String, Object>(16);
                entrydata.put("PK_ID", saleConEntry.getPkValue());
                entrydata.put("itemClass.number", saleConEntry.getString("itemclass.easnumber"));
                entrydata.put("item.number", saleConEntry.getString("item.easnum"));
                entrydata.put("baseUnit.number", saleConEntry.getString("baseunit.number"));
                entrydata.put("qty", saleConEntry.getBigDecimal("qty"));
                entrydata.put("assistUnit", saleConEntry.getString("assistunit.number"));
                entrydata.put("assistQty", saleConEntry.getBigDecimal("assitqty"));
                entrydata.put("price", saleConEntry.getBigDecimal("price"));
                entrydata.put("taxPrice", saleConEntry.getBigDecimal("taxprice"));
                entrydata.put("amount", saleConEntry.getBigDecimal("amount"));
                entrydata.put("taxAmount", saleConEntry.getBigDecimal("taxamount"));
                entrydata.put("taxrate", saleConEntry.getBigDecimal("taxrate"));
                entrydata.put("totalorderamt", saleConEntry.getBigDecimal("totalorderamt"));
                entrydata.put("totalorderqty", saleConEntry.getBigDecimal("totalorderqty"));
                listMaps.add(entrydata);
            }
            data.put("entry", listMaps);
            DynamicObjectCollection picEntrys = (DynamicObjectCollection)saleConInfo.get("picentry");
            if (picEntrys != null && picEntrys.size() > 0) {
                for (int i = 0; i < picEntrys.size(); ++i) {
                    DynamicObject picEntry = (DynamicObject)picEntrys.get(i);
                    HashMap<String, Object> entrydata = new HashMap<String, Object>();
                    entrydata.put("PK_ID", picEntry.getPkValue());
                    entrydata.put("picurl", picEntry.getString("picurl"));
                    entrydata.put("thumbnailurl", picEntry.getString("thumbnailurl"));
                    listMaps.add(entrydata);
                }
                data.put("picentry", listMaps);
            }
            if (null == (imageServerUrl = System.getProperty("image.fileserver"))) {
                imageServerUrl = System.getProperty("fileserver");
            }
            data.put("imageServerUrl", imageServerUrl);
            data.put("entry", listMaps);
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("data", new JSONObject(data).toJSONString());
            return SynSaleContractUtil.synMessageSendOut(json, saleConId);
        }
        return null;
    }

    private static StringBuilder getSelectors() {
        StringBuilder selectors = new StringBuilder();
        selectors.append("id,");
        selectors.append("billno,");
        selectors.append("settlementtype,");
        selectors.append("settlementtype.number,");
        selectors.append("customer.easnumber,");
        selectors.append("signaddress,");
        selectors.append("bizdate,");
        selectors.append("validTo,");
        selectors.append("contracttype.number,");
        selectors.append("deliveryAddress,");
        selectors.append("remark,");
        selectors.append("creator.phone,");
        selectors.append("customergroup,");
        selectors.append("customergroup.number,");
        selectors.append("totalqty,");
        selectors.append("carryfee,");
        selectors.append("contractprice,");
        selectors.append("netprice,");
        selectors.append("paydate,");
        selectors.append("orderrequire,");
        selectors.append("qualityrequire,");
        selectors.append("contratclass,");
        selectors.append("contractform,");
        selectors.append("distribut,");
        selectors.append("distribut.number,");
        selectors.append("recoverytype,");
        selectors.append("paycondition,");
        selectors.append("factorytxt,");
        selectors.append("package,");
        selectors.append("bearing,");
        if (EntityMetadataCache.getDataEntityType((String)"mdr_salecontract").getAllFields().get("package1") != null) {
            selectors.append("package1,");
        }
        if (EntityMetadataCache.getDataEntityType((String)"mdr_salecontract").getAllFields().get("standard") != null) {
            selectors.append("standard,");
        }
        selectors.append("entryentity,");
        selectors.append("entryentity.itemclass,");
        selectors.append("entryentity.itemclass.easnumber,");
        selectors.append("entryentity.item,");
        selectors.append("entryentity.item.easnum,");
        selectors.append("entryentity.baseunit,");
        selectors.append("entryentity.baseunit.number,");
        selectors.append("entryentity.qty,");
        selectors.append("entryentity.assistunit,");
        selectors.append("entryentity.assistunit.number,");
        selectors.append("entryentity.assitqty,");
        selectors.append("entryentity.price,");
        selectors.append("entryentity.taxprice,");
        selectors.append("entryentity.amount,");
        selectors.append("entryentity.taxamount,");
        selectors.append("entryentity.taxrate,");
        selectors.append("entryentity.totalorderqty,");
        selectors.append("entryentity.totalorderamt,");
        selectors.append("picentry.picurl,");
        selectors.append("picentry.thumbnailurl");
        return selectors;
    }

    public static SynResult synDeleteMessageSendOut(Map<String, Object> data, Object saleConId) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.SALECONTRACT_DELETE, data, null, (RequestContext)RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4", (String)"SynSaleContractUtil_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
                }
                issyn = false;
                synresult.setMsg(errorMessage);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25%s", (String)"SynSaleContractUtil_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]), synresult.getMsg()));
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static SynResult synMessageSendOut(Map<String, Object> data, Object saleConId) {
        SynResult synresult = new SynResult();
        boolean issyn = true;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)MsgTypeEnum.SALECONTRACT_ADDNEW, data, null, (RequestContext)RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4", (String)"SynSaleContractUtil_6", (String)"drp-bbc-opplugin", (Object[])new Object[0]);
                }
                issyn = false;
                synresult.setMsg(errorMessage);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25%s", (String)"SynSaleContractUtil_7", (String)"drp-bbc-opplugin", (Object[])new Object[0]), synresult.getMsg()));
            }
            synresult.setSuccess(issyn);
        }
        return synresult;
    }

    public static void synSalerOrderRecord(Object saleConId, String errorMessage) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"mdr_synsalecont_record");
        DynamicObject record = new DynamicObject((DynamicObjectType)entityType);
        QFilter qFilter = new QFilter("saleorder", "=", saleConId);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject synsaleorderInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_synsaleorder_record", (String)"id,saleorder,synctime,createdate,exceptioninfo", (QFilter[])filters);
        if (synsaleorderInfo != null) {
            Integer synctime = synsaleorderInfo.getInt("synctime") + 1;
            synsaleorderInfo.set("synctime", (Object)synctime);
            synsaleorderInfo.set("createdate", (Object)new Date());
            synsaleorderInfo.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)synsaleorderInfo.getDataEntityType(), (Object[])new DynamicObject[]{synsaleorderInfo});
        } else {
            record.set("saleorder", saleConId);
            record.set("synctime", (Object)1);
            record.set("createdate", (Object)new Date());
            record.set("exceptioninfo", (Object)errorMessage);
            SaveServiceHelper.save((IDataEntityType)record.getDataEntityType(), (Object[])new DynamicObject[]{record});
        }
    }
}

