/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class ItemStoreQueryRpt
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        DynamicObject customer = arg0.getFilter().getDynamicObject("customerf7");
        return this.getDataSet(customer.get("id"));
    }

    private DataSet getDataSet(Object customerid) {
        ORM orm = ORM.create();
        DataSet standardset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "mdr_item_store", "customer.id,customer.name,item.id,item.itemclass.name,item.name,item.number,warehouse.id,warehouse.name,measureunit.id,measureunit.name,assistattr.id,assistattr.name,qty,orderqty", new QFilter[]{new QFilter("customer.id", "=", customerid)});
        DataSet otherSet = this.getOtherSet(customerid, orm);
        if (otherSet == null) {
            return standardset;
        }
        DataSet set = standardset.join(otherSet, JoinType.LEFT).on("customer.id", "customer.id").on("item.id", "entryentity.item.id").on("measureunit.id", "entryentity.unit.id").on("measureunit.id", "entryentity.assistattr.id").on("warehouse.id", "entryentity.warehouse.id").select(new String[]{"customer.name customername", "item.name itemname", "item.number itemnumber", "item.itemclass.name itemclassname", "measureunit.name unitname", "assistattr.name assistattrname", "warehouse.name warehousename", "qty", "orderqty"}, new String[]{"otherqty"}).finish();
        return set.select(new String[]{"customername", "itemname", "itemnumber", "itemclassname", "assistattrname", "unitname", "warehousename", "qty", "orderqty", "otherqty", "qty+otherqty-orderqty as usableqty"});
    }

    private DataSet getOtherSet(Object customerid, ORM orm) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        String endtime = sdf.format(c.getTime());
        int date = c.get(5);
        c.set(5, date - 1);
        String starttime = sdf.format(c.getTime());
        Date firstTime = null;
        Date lastTime = null;
        try {
            firstTime = sdf.parse(starttime);
            lastTime = sdf.parse(endtime);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"ItemStoreQueryRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(" customer.id,customer.name as customer,entryentity.item.id,entryentity.item.name,entryentity.item.number,entryentity.item.itemclass.name,entryentity.unit.id,entryentity.unit.name,entryentity.assistattr.id,entryentity.assistattr.name,entryentity.warehouse.id,entryentity.warehouse.name,entryentity.qty ");
        sql.append(" from mdr_store_updatebill ");
        sql.append(" where customer.id = ? and bizdate >= ? and bizdate < ?");
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), sql.toString(), new Object[]{Long.parseLong(customerid.toString()), firstTime, lastTime}).groupBy(new String[]{"customer.id", "entryentity.item.id", "entryentity.unit.id", "entryentity.assistattr.id", "entryentity.warehouse.id"}).sum("entryentity.qty", "otherqty").finish();
    }
}

