/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.bbc.report.util.ReportColumnUtil;

public class SaleOrderDayRpt
extends AbstractReportListDataPlugin {
    private Map<String, Object> dateData = new LinkedHashMap<String, Object>();
    private static LocaleString width = new LocaleString("90px");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd");
    private static String qty_suf = "_qty";
    private static String amount_suf = "_amount";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        this.creatReportColumn(columns, ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SaleOrderDayRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]), "count");
        for (String date : this.dateData.keySet()) {
            this.creatReportColumn(columns, date);
        }
        return super.getColumns(columns);
    }

    private void creatReportColumn(List<AbstractReportColumn> columns, String name) {
        this.creatReportColumn(columns, name, name);
    }

    private void creatReportColumn(List<AbstractReportColumn> columns, String showName, String fieldKey) {
        ReportColumnGroup dateGroup = ReportColumnUtil.createColumnGroup(new LocaleString(showName));
        List children = dateGroup.getChildren();
        ReportColumn qtyColumn = ReportColumnUtil.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf", (String)"SaleOrderDayRpt_1", (String)"drp-bbc-report", (Object[])new Object[0])), width, fieldKey + qty_suf, "decimal");
        ReportColumn amountColumn = ReportColumnUtil.createColumn(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"SaleOrderDayRpt_2", (String)"drp-bbc-report", (Object[])new Object[0])), width, fieldKey + amount_suf, "decimal");
        qtyColumn.setScale(2);
        amountColumn.setScale(2);
        children.add(qtyColumn);
        children.add(amountColumn);
        columns.add((AbstractReportColumn)dateGroup);
    }

    public DataSet query(ReportQueryParam p, Object arg1) throws Throwable {
        Date fromDate;
        DynamicObject biztype;
        FilterInfo filterInfo = p.getFilter();
        DynamicObject owner = filterInfo.getDynamicObject("owner");
        QFilter filter = new QFilter("1", "=", (Object)"1");
        filter.and(new QFilter("orderstatus", "in", (Object)new char[]{'C', 'D', 'E', 'F', 'G', 'H', 'K', 'L'}));
        if (owner != null) {
            filter.and("owner", "=", owner.get("id"));
        }
        if ((biztype = filterInfo.getDynamicObject("biztype")) != null) {
            filter.and("biztype", "=", biztype.get("id"));
        }
        if ((fromDate = filterInfo.getDate("fromdate")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\uff01", (String)"SaleOrderDayRpt_3", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
        Calendar calst = Calendar.getInstance();
        calst.setTime(fromDate);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        Date startDate = calst.getTime();
        filter.and("orderdate", ">=", (Object)startDate);
        Date toDate = filterInfo.getDate("todate");
        if (toDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u675f\u65e5\u671f\uff01", (String)"SaleOrderDayRpt_4", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
        Calendar caled = Calendar.getInstance();
        caled.setTime(toDate);
        caled.set(11, 23);
        caled.set(12, 59);
        caled.set(13, 59);
        Date endDate = caled.getTime();
        filter.and("orderdate", "<=", (Object)endDate);
        if (fromDate.after(toDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\uff01", (String)"SaleOrderDayRpt_5", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
        int dateSpace = this.getDateSpace(fromDate, toDate);
        if (dateSpace > 31) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u67e5\u8be2\u4e00\u4e2a\u6708\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8d77\u59cb\u65e5\u671f\uff01", (String)"SaleOrderDayRpt_6", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
        Date tempDate = toDate;
        while (!tempDate.before(fromDate)) {
            this.dateData.put(this.dateFormat.format(tempDate), null);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tempDate);
            calendar.add(6, -1);
            tempDate = calendar.getTime();
        }
        return this.getDataSet(filter);
    }

    private DataSet getDataSet(QFilter filter) throws ParseException {
        DataSet orderSet = this.querySaleorder(filter);
        orderSet = orderSet.groupBy(new String[]{"ownerid", "ownername", "salerid", "salername"}).sum("qty", "count_qty").sum("amount", "count_amount").finish().orderBy(new String[]{"ownerid", "salerid"});
        ArrayList<String> showFieldList = new ArrayList<String>(16);
        showFieldList.add("ownerid");
        showFieldList.add("ownername");
        showFieldList.add("salerid");
        showFieldList.add("salername");
        showFieldList.add("count_qty");
        showFieldList.add("count_amount");
        for (String date : this.dateData.keySet()) {
            Date tempDate = this.dateFormat.parse(date);
            QFilter f = filter.copy().and(this.getDateFilter(tempDate));
            String dayQtyfield = date + qty_suf;
            String dayAmountfield = date + amount_suf;
            DataSet dayOrderSet = this.querySaleorder(f);
            dayOrderSet = dayOrderSet.groupBy(new String[]{"ownerid", "ownername", "salerid", "salername"}).sum("qty", dayQtyfield).sum("amount", dayAmountfield).finish().orderBy(new String[]{"ownerid", "salerid"});
            orderSet = orderSet.join(dayOrderSet, JoinType.LEFT).on("ownerid", "ownerid").on("salerid", "salerid").select(showFieldList.toArray(new String[0]), new String[]{dayQtyfield, dayAmountfield}).finish();
            showFieldList.add(dayQtyfield);
            showFieldList.add(dayAmountfield);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tempDate);
            calendar.add(6, -1);
            tempDate = calendar.getTime();
        }
        DataSet orderAllCountSet = orderSet.copy();
        RowMeta rowMeta = orderAllCountSet.getRowMeta();
        ArrayList<String> fieldStrList = new ArrayList<String>();
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            String alias = rowMeta.getField(i).getAlias();
            if ("ownername".equalsIgnoreCase(alias)) {
                fieldStrList.add(ResManager.loadKDString((String)"'\u603b\u8ba1' as ", (String)"SaleOrderDayRpt_7", (String)"drp-bbc-report", (Object[])new Object[0]) + alias);
                continue;
            }
            if ("salername".equalsIgnoreCase(alias)) {
                fieldStrList.add("'' as " + alias);
                continue;
            }
            if ("ownerid".equalsIgnoreCase(alias) || "salerid".equalsIgnoreCase(alias)) {
                fieldStrList.add("0.0 as " + alias);
                continue;
            }
            fieldStrList.add(alias);
        }
        orderAllCountSet = orderAllCountSet.select(fieldStrList.toArray(new String[0]));
        GroupbyDataSet orderCountGroupSet = orderAllCountSet.groupBy(new String[]{"ownerid", "ownername", "salerid", "salername"}).sum("count_qty").sum("count_amount");
        for (String date : this.dateData.keySet()) {
            String dayQtyfield = date + qty_suf;
            String dayAmountfield = date + amount_suf;
            orderCountGroupSet.sum(dayQtyfield);
            orderCountGroupSet.sum(dayAmountfield);
        }
        orderAllCountSet = orderCountGroupSet.finish();
        orderSet = orderSet.addField("1", "rowtype");
        orderAllCountSet = orderAllCountSet.addField("2", "rowtype");
        orderSet = orderSet.union(orderAllCountSet).orderBy(new String[]{"rowtype"});
        return orderSet;
    }

    public int getCount(DataSet dataSet) {
        int i = 0;
        for (Row row : dataSet.copy()) {
            ++i;
        }
        return i;
    }

    private DataSet querySaleorder(QFilter f) {
        ORM orm = ORM.create();
        DataSet standardset = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "mdr_saleorder", "owner.id as ownerid,owner.name as ownername,region.id as regionid,region.name as regionname,saler.id as salerid, saler.name as salername,orderdate as orderdate,itementry.qty as qty,itementry.orderamount as amount", f.toArray());
        return standardset;
    }

    private QFilter getDateFilter(Date tempDate) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(tempDate);
        caled.setTime(tempDate);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 23);
        caled.set(12, 59);
        caled.set(13, 59);
        Date startDate = calst.getTime();
        Date endDate = caled.getTime();
        QFilter qFilter = new QFilter("orderdate", ">=", (Object)startDate);
        qFilter.and("orderdate", "<=", (Object)endDate);
        return qFilter;
    }

    public int getDateSpace(Date date1, Date date2) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(date1);
        caled.setTime(date2);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }
}

