/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.drp.mdr.common.util.UserUtil;

public class TodaySimpleQueryRpt
extends AbstractReportListDataPlugin {
    List<Object> ownerid = UserUtil.getOwnerIDs();

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        Calendar cal = Calendar.getInstance();
        String start = this.getdatestr(new SimpleDateFormat("yyyy-MM-dd 00:00:00"));
        String end = this.getdatestr(new SimpleDateFormat("yyyy-MM-dd 23:59:59"));
        DataSet dayset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u65e5", (String)"TodaySimpleQueryRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]));
        start = this.getdatestr(new SimpleDateFormat("yyyy-MM-01 00:00:00"));
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        end = format.format(cal.getTime());
        DataSet monthset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u6708", (String)"TodaySimpleQueryRpt_1", (String)"drp-bbc-report", (Object[])new Object[0]));
        start = this.getdatestr(new SimpleDateFormat("yyyy-01-01 00:00:00"));
        end = this.getdatestr(new SimpleDateFormat("yyyy-12-31 23:59:59"));
        DataSet yearset = this.queryregiondataset(start, end, ResManager.loadKDString((String)"\u4eca\u5e74", (String)"TodaySimpleQueryRpt_2", (String)"drp-bbc-report", (Object[])new Object[0]));
        return dayset.union(monthset).union(yearset);
    }

    private String getdatestr(SimpleDateFormat sdf) {
        return sdf.format(new Date());
    }

    private DataSet queryregiondataset(String begindate, String enddate, String dateregion) {
        ORM orm = ORM.create();
        String str = this.getString();
        Object[] ob = this.getObjectValue(begindate, enddate);
        String sql = "select '" + dateregion + "' as dateregion, count(distinct(id)) as orderqty,sum(totalorderamount) as orderamont,sum(totalqty) as orderquantity from bbc_saleorder where owner.id in " + str + " and orderdate > ? and orderdate < ?";
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), sql, ob);
    }

    private String getString() {
        if (this.ownerid.isEmpty()) {
            return "(0)";
        }
        StringBuilder str = new StringBuilder("(");
        for (int i = 0; i < this.ownerid.size(); ++i) {
            str.append("?,");
        }
        return str.substring(0, str.length() - 1) + ")";
    }

    private Object[] getObjectValue(String begindate, String enddate) {
        if (this.ownerid != null) {
            ArrayList<Object> newList = new ArrayList<Object>(this.ownerid);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startTime = null;
            Date endTime = null;
            try {
                startTime = simpleDateFormat.parse(begindate);
                endTime = simpleDateFormat.parse(enddate);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"TodaySimpleQueryRpt_3", (String)"drp-bbc-report", (Object[])new Object[0]));
            }
            newList.add(startTime);
            newList.add(endTime);
            return newList.toArray();
        }
        return null;
    }
}

