/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report;

import java.util.Calendar;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.bbc.report.MdrReportFormPlugin;
import kd.drp.bbc.report.util.ReportUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;

public class UnDispatchRptPlugin
extends MdrReportFormPlugin
implements BeforeF7SelectListener {
    private static final String OWNER_FILTER = "owner";
    private static final String SALER_FILTER = "salerfilter";
    private static final String DISPATCHER_FILTER = "dispatcherfilter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit owner = (BasedataEdit)super.getView().getControl(OWNER_FILTER);
        BasedataEdit dispatcher = (BasedataEdit)super.getView().getControl(DISPATCHER_FILTER);
        BasedataEdit saler = (BasedataEdit)super.getView().getControl(SALER_FILTER);
        owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        dispatcher.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        saler.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.getModel().setValue(DISPATCHER_FILTER, null);
                this.getModel().setValue(SALER_FILTER, null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (OWNER_FILTER.equals(e.getProperty().getName())) {
            QFilter q = new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
            this.getFilter(e).setFilter(q);
        } else if (SALER_FILTER.equals(e.getProperty().getName())) {
            this.setNoTreeF7(e);
            DynamicObjectCollection ownerCollection = this.getModel().getDataEntity().getDynamicObjectCollection(OWNER_FILTER);
            if (ownerCollection == null || ownerCollection.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"UnDispatchRptPlugin_0", (String)"drp-bbc-report", (Object[])new Object[0]));
            }
            HashSet<Object> owners = new HashSet<Object>();
            for (DynamicObject dynamicObject : ownerCollection) {
                dynamicObject = dynamicObject.getDynamicObject("fbasedataid");
                owners.add(dynamicObject.get("id"));
            }
            Set ids = QueryUtil.querySingleCol((String)"mdr_cust_saler_relation", (String)"user", (QFilter[])new QFilter(OWNER_FILTER, "in", owners).toArray());
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)ids));
        } else if (DISPATCHER_FILTER.equals(e.getProperty().getName())) {
            this.setNoTreeF7(e);
            DynamicObjectCollection ownerCollection = this.getModel().getDataEntity().getDynamicObjectCollection(OWNER_FILTER);
            if (ownerCollection == null || ownerCollection.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"UnDispatchRptPlugin_0", (String)"drp-bbc-report", (Object[])new Object[0]));
            }
            HashSet ids = new HashSet(ownerCollection.size());
            for (DynamicObject dynamicObject : ownerCollection) {
                dynamicObject = dynamicObject.getDynamicObject("fbasedataid");
                ids.addAll(UserUtil.getDispathcerIds((Object)dynamicObject.get("id")));
            }
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter(ids));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        ReportUtils.setBillNoFilter(queryParam, OWNER_FILTER, "billnofilter", "saleorder");
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        queryParam.getFilter().addFilterItem("startdate", (Object)c.getTime(), "67");
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        queryParam.getFilter().addFilterItem("enddate", (Object)ca.getTime(), "67");
    }
}

