/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report.order;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.UserUtil;

public class OwnerDataRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String OWNER_FILTER = "ownerfilter";
    private static final String CUSTOMER_FILTER = "customerfilter";
    private static final String BILLNO_FILTER = "billnofilter";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (OWNER_FILTER.equals(e.getProperty().getName())) {
            QFilter q = new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
            this.getFilter(e).setFilter(q);
        } else if (CUSTOMER_FILTER.equals(e.getProperty().getName())) {
            DynamicObjectCollection ownerCollection = (DynamicObjectCollection)this.getModel().getValue(OWNER_FILTER);
            List<Object> selectedOwnerIds = null;
            selectedOwnerIds = ownerCollection.isEmpty() ? UserUtil.getOwnerIDs() : this.getSelectedOwnerIds4Filter(ownerCollection);
            List<Object> customerids = this.getCustomerIds(selectedOwnerIds);
            QFilter q = new QFilter("id", "in", customerids);
            this.getFilter(e).setFilter(q);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Object> selectedOwnerIds = null;
        List<Object> selectedCustomerIds = null;
        DynamicObjectCollection ownerCollection = null;
        try {
            ownerCollection = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(OWNER_FILTER).getValue();
            selectedOwnerIds = ownerCollection == null ? UserUtil.getOwnerIDs() : this.getSelectedIds(ownerCollection);
        }
        catch (Exception e) {
            selectedOwnerIds = (List<Object>)queryParam.getFilter().getFilterItem(OWNER_FILTER).getValue();
        }
        try {
            DynamicObjectCollection customerCollection = (DynamicObjectCollection)queryParam.getFilter().getFilterItem(CUSTOMER_FILTER).getValue();
            selectedCustomerIds = customerCollection == null ? this.getCustomerIds(selectedOwnerIds) : this.getSelectedIds(customerCollection);
        }
        catch (Exception e) {
            selectedCustomerIds = this.getCustomerIds(selectedOwnerIds);
        }
        queryParam.getFilter().getFilterItem(OWNER_FILTER).setValue(selectedOwnerIds);
        queryParam.getFilter().getFilterItem(CUSTOMER_FILTER).setValue(selectedCustomerIds);
        List<Object> billnos = this.getBillnos(selectedOwnerIds);
        queryParam.getFilter().addFilterItem(BILLNO_FILTER, (Object)ownerCollection, "17");
        queryParam.getFilter().getFilterItem(BILLNO_FILTER).setValue(billnos);
    }

    private List<Object> getBillnos(List<Object> selectedOwnerIds) {
        QFilter f = null;
        ArrayList<Object> ids = new ArrayList<Object>();
        for (Object ownerid : selectedOwnerIds) {
            f = SaleOrderUtil.getSaleOrderSalerFilter((Object)ownerid);
            Set billnos = QueryUtil.querySingleCol((String)"mdr_saleorder", (String)"billno", (QFilter[])f.toArray());
            ids.addAll(billnos);
        }
        return ids;
    }

    private List<Object> getSelectedIds(DynamicObjectCollection collection) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject o : collection) {
            ids.add(o.get("id"));
        }
        return ids;
    }

    private List<Object> getCustomerIds(List<Object> selectedOwnerIds) {
        ArrayList<Object> customerids = new ArrayList<Object>();
        for (Object owner : selectedOwnerIds) {
            customerids.addAll(this.getOwnerIds(owner));
        }
        return customerids;
    }

    private List<Object> getSelectedOwnerIds4Filter(DynamicObjectCollection ownerCollection) {
        ArrayList<Object> ownerids = new ArrayList<Object>();
        for (DynamicObject ownerfilter : ownerCollection) {
            DynamicObject owner = (DynamicObject)ownerfilter.get(1);
            ownerids.add(owner.get("id"));
        }
        return ownerids;
    }

    private Set<Object> getOwnerIds(Object ownerid) {
        Set ids = null;
        if (UserUtil.isSaler((Object)ownerid)) {
            ids = CustomerSalerUtil.queryCustomerPKBySaler((Object)ownerid, (Object)UserUtil.getUserID());
        } else {
            Set regionIds = UserUtil.queryUserRegionsWithAllSubs((Object)ownerid);
            if (regionIds.isEmpty()) {
                return CustomerUtil.getAuthSubsIds((Object)ownerid);
            }
            ids = CustomerUtil.queryCustomerByRegion((Object)ownerid, (Object)regionIds);
        }
        return ids;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit owner = (BasedataEdit)super.getView().getControl(OWNER_FILTER);
        BasedataEdit customer = (BasedataEdit)super.getView().getControl(CUSTOMER_FILTER);
        owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "startdate": 
            case "enddate": {
                this.dateChanged();
            }
        }
    }

    private void dateChanged() {
        Date startdate = this.getModel().getDataEntity().getDate(START_DATE);
        Date enddate = this.getModel().getDataEntity().getDate(END_DATE);
        if (startdate == null || enddate == null) {
            return;
        }
        if (startdate.after(enddate)) {
            this.getModel().setValue(START_DATE, (Object)enddate);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (String)"OwnerDataRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
    }

    private ListFilterParameter getFilter(BeforeF7SelectEvent evt) {
        return ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
    }
}

