/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.bbc.report.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.bbc.report.MdrReportFormPlugin;
import kd.drp.bbc.report.util.ReportUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;

public class SaleOrderRpt
extends MdrReportFormPlugin
implements BeforeF7SelectListener {
    private static final String OWNER_FILTER = "ownerfilter";
    private static final String BILLNO_FILTER = "billnofilter";
    private static final String CUSTOMER_FILTER = "customerfilter";
    private static final String SALER_FILTER = "salerfilter";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (OWNER_FILTER.equals(e.getProperty().getName())) {
            QFilter q = new QFilter("id", "in", (Object)UserUtil.getOwnerIDs());
            this.getFilter(e).setFilter(q);
        } else if (CUSTOMER_FILTER.equals(e.getProperty().getName())) {
            DynamicObjectCollection ownerCollection = this.getModel().getDataEntity().getDynamicObjectCollection(OWNER_FILTER);
            if (ownerCollection == null || ownerCollection.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"SaleOrderRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]));
            }
            HashSet<Object> owners = new HashSet<Object>();
            for (DynamicObject dynamicObject : ownerCollection) {
                dynamicObject = dynamicObject.getDynamicObject("fbasedataid");
                owners.add(dynamicObject.get("id"));
            }
            Set authSubsIds = CustomerUtil.getAuthSubsIdsByIds(owners);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)authSubsIds));
        } else if (SALER_FILTER.equals(e.getProperty().getName())) {
            this.setNoTreeF7(e);
            DynamicObjectCollection ownerCollection = this.getModel().getDataEntity().getDynamicObjectCollection(OWNER_FILTER);
            if (ownerCollection == null || ownerCollection.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"SaleOrderRpt_0", (String)"drp-bbc-report", (Object[])new Object[0]));
            }
            HashSet<Object> owners = new HashSet<Object>();
            for (DynamicObject dynamicObject : ownerCollection) {
                dynamicObject = dynamicObject.getDynamicObject("fbasedataid");
                owners.add(dynamicObject.get("id"));
            }
            Set ids = QueryUtil.querySingleCol((String)"mdr_cust_saler_relation", (String)"user", (QFilter[])new QFilter("owner", "in", owners).toArray());
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)WebUtil.getIdQFilter((Collection)ids));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        Object salerValue;
        super.beforeQuery(queryParam);
        List<Object> customerIds = new ArrayList<Object>();
        List<Object> salerIds = new ArrayList<Object>();
        ReportUtils.setBillNoFilter(queryParam);
        Object customerValue = queryParam.getFilter().getFilterItem(CUSTOMER_FILTER).getValue();
        if (customerValue != null) {
            if (customerValue instanceof DynamicObjectCollection) {
                DynamicObjectCollection customerCollection = (DynamicObjectCollection)customerValue;
                customerIds = this.getSelectedOwnerIds(customerCollection);
            } else if (customerValue instanceof DynamicObject) {
                customerIds.add(((DynamicObject)customerValue).get("id"));
            }
            queryParam.getFilter().getFilterItem(CUSTOMER_FILTER).setValue(customerIds);
        }
        if ((salerValue = queryParam.getFilter().getFilterItem(SALER_FILTER).getValue()) != null) {
            if (salerValue instanceof DynamicObjectCollection) {
                DynamicObjectCollection salerCollection = (DynamicObjectCollection)salerValue;
                salerIds = this.getSelectedOwnerIds(salerCollection);
            } else if (salerValue instanceof DynamicObject) {
                salerIds.add(((DynamicObject)salerValue).get("id"));
            }
            queryParam.getFilter().getFilterItem(SALER_FILTER).setValue(salerIds);
        }
    }

    private List<Object> getSelectedOwnerIds(DynamicObjectCollection ownerCollection) {
        ArrayList<Object> ownerids = new ArrayList<Object>();
        for (DynamicObject owner : ownerCollection) {
            ownerids.add(owner.get("id"));
        }
        return ownerids;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit owner = (BasedataEdit)super.getView().getControl(OWNER_FILTER);
        BasedataEdit customer = (BasedataEdit)super.getView().getControl(CUSTOMER_FILTER);
        BasedataEdit saler = (BasedataEdit)super.getView().getControl(SALER_FILTER);
        owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        saler.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "startdate": 
            case "enddate": {
                this.dateChanged();
                break;
            }
            case "ownerfilter": {
                this.getModel().setValue(CUSTOMER_FILTER, null);
                this.getModel().setValue(SALER_FILTER, null);
            }
        }
    }

    private void dateChanged() {
        Date startdate = this.getModel().getDataEntity().getDate(START_DATE);
        Date enddate = this.getModel().getDataEntity().getDate(END_DATE);
        if (startdate == null || enddate == null) {
            return;
        }
        if (startdate.after(enddate)) {
            this.getModel().setValue(START_DATE, (Object)enddate);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (String)"SaleOrderRpt_1", (String)"drp-bbc-report", (Object[])new Object[0]));
        }
    }
}

