/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.mservice;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.upgrade.AbstractUpgradePlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.UpgradeResult;

public class DbdItemSaleContentUpgradePlugin
extends AbstractUpgradePlugin {
    private static Log log = LogFactory.getLog(DbdItemSaleContentUpgradePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = super.afterExecuteSql(ver, iteration, dbKey, sqlFileName);
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID("dbd");
        appLogInfo.setBizObjID("dbd_itemsale_content");
        appLogInfo.setOpName("\u96f6\u552e\u7ecf\u8425\u76ee\u5f55\u5386\u53f2\u6570\u636e\u5347\u7ea7");
        try (TXHandle h = TX.requiresNew();){
            try {
                this.upgradeDbdItemsaleConentData();
                appLogInfo.setOpDescription("\u5347\u7ea7\u6210\u529f");
            }
            catch (SQLException e) {
                log.error((Throwable)e);
                h.markRollback();
                appLogInfo.setOpDescription(e.getMessage());
            }
            finally {
                ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
                service.addLog(appLogInfo);
            }
        }
        return upgradeResult;
    }

    private void upgradeDbdItemsaleConentData() throws SQLException {
        String querySql = "SELECT FCREATEORGID,FCURRENCYID,FCUSTOMERID,FITEMID,MAX(FMEMBERPRICE) AS MAXFMEMBERPRICE,  MAX(FRETAILPRICE) AS MAXFRETAILPRICE,MIN(FRETAILPRICE) AS MINFRETAILPRICE ,MIN(FMEMBERPRICE) AS MINFMEMBERPRICE  FROM T_DBD_SALEITEM_CONTENT WHERE FHEADID  NOT IN (SELECT FID FROM T_DBD_SI_CONTENT_HEAD)  GROUP BY FCREATEORGID ,FCURRENCYID ,FCUSTOMERID,FITEMID; ";
        List dataList = (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)querySql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(32);
                while (rs.next()) {
                    HashMap<String, Number> data = new HashMap<String, Number>();
                    data.put("FCREATEORGID", rs.getLong("FCREATEORGID"));
                    data.put("FCURRENCYID", rs.getLong("FCURRENCYID"));
                    data.put("FCUSTOMERID", rs.getLong("FCUSTOMERID"));
                    data.put("FITEMID", rs.getLong("FITEMID"));
                    data.put("MAXFMEMBERPRICE", rs.getBigDecimal("MAXFMEMBERPRICE"));
                    data.put("MAXFRETAILPRICE", rs.getBigDecimal("MAXFRETAILPRICE"));
                    data.put("MINFMEMBERPRICE", rs.getBigDecimal("MINFMEMBERPRICE"));
                    data.put("MINFRETAILPRICE", rs.getBigDecimal("MINFRETAILPRICE"));
                    dataList.add(data);
                }
                return dataList;
            }
        });
        if (!CollectionUtils.isEmpty((Collection)dataList)) {
            StringBuilder sqlBuilder = new StringBuilder();
            long[] FIds = DB.genGlobalLongIds((int)dataList.size());
            for (int i = 0; i < dataList.size(); ++i) {
                ((Map)dataList.get(i)).put("FID", FIds[i]);
            }
            List<Object[]> rowList = this.getParamList(dataList);
            sqlBuilder.setLength(0);
            sqlBuilder.append("INSERT INTO T_DBD_SI_CONTENT_HEAD (FCREATEORGID,FCURRENCYID,FCUSTOMERID,FITEMID,FMAXMEMBERPRICE,FMAXRETAILPRICE,FMINMEMBERPRICE,FMINRETAILPRICE,FID)  VALUES(?,?,?,?,?,?,?,?,?) ");
            DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sqlBuilder.toString(), rowList);
            sqlBuilder.setLength(0);
            ArrayList<Object[]> rowList2 = new ArrayList<Object[]>(dataList.size());
            for (Map data : dataList) {
                ArrayList row = new ArrayList(5);
                row.add(data.get("FID"));
                row.add(data.get("FCREATEORGID"));
                row.add(data.get("FCURRENCYID"));
                row.add(data.get("FCUSTOMERID"));
                row.add(data.get("FITEMID"));
                rowList2.add(row.toArray());
            }
            sqlBuilder.append("UPDATE T_DBD_SALEITEM_CONTENT  SET FHEADID = ? WHERE FCREATEORGID = ? AND FCURRENCYID = ? AND  FCUSTOMERID = ?  AND  FITEMID = ?");
            DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sqlBuilder.toString(), rowList2);
        }
    }

    private List<Object[]> getParamList(List<Map<String, Object>> dataList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(32);
        for (Map<String, Object> rowDataMap : dataList) {
            ArrayList<Object> dataValueList = new ArrayList<Object>(8);
            dataValueList.add(rowDataMap.get("FCREATEORGID"));
            dataValueList.add(rowDataMap.get("FCURRENCYID"));
            dataValueList.add(rowDataMap.get("FCUSTOMERID"));
            dataValueList.add(rowDataMap.get("FITEMID"));
            dataValueList.add(rowDataMap.get("MAXFMEMBERPRICE"));
            dataValueList.add(rowDataMap.get("MAXFRETAILPRICE"));
            dataValueList.add(rowDataMap.get("MINFMEMBERPRICE"));
            dataValueList.add(rowDataMap.get("MINFRETAILPRICE"));
            dataValueList.add(rowDataMap.get("FID"));
            paramsList.add(dataValueList.toArray());
        }
        return paramsList;
    }
}

