/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.dbd.business.handle.DrpUserHelper;
import kd.drp.dbd.mservice.api.DrpUserService;

public class DrpUserServiceImpl
implements DrpUserService {
    private static Log log = LogFactory.getLog(DrpUserHelper.class);

    public JSONObject insertDrpUser(Long sysUserId, Long ownerId) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"success");
        if (null == sysUserId || null == ownerId) {
            return resp;
        }
        DynamicObject drpUser = QueryServiceHelper.queryOne((String)"dbd_drp_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("sysuser", "=", (Object)sysUserId), new QFilter("owner", "=", (Object)ownerId)});
        if (null != drpUser) {
            return resp;
        }
        HashMap<String, Long> param = new HashMap<String, Long>(8);
        param.put("sysuser", sysUserId);
        param.put("owner", ownerId);
        boolean isSuccess = DrpUserHelper.insertDrpUser(param);
        if (!isSuccess) {
            resp.put("code", (Object)1);
            resp.put("msg", (Object)"failure");
            log.debug("CustomerId = [" + sysUserId + "] create drp user userId = [" + ownerId + "] failure.");
        }
        return resp;
    }

    public JSONObject insertDrpAdmin(Long userId, Long customerId) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"success");
        DynamicObject[] admins = BusinessDataServiceHelper.load((String)"dbd_customer_admin", (String)"id", (QFilter[])new QFilter[]{new QFilter("customer", "=", (Object)customerId), new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId())});
        if (null != admins && admins.length > 0) {
            return resp;
        }
        HashMap<String, Long> param = new HashMap<String, Long>(8);
        param.put("customer", customerId);
        param.put("user", userId);
        param.put("creator", UserServiceHelper.getCurrentUserId());
        boolean isSuccess = DrpUserHelper.insertDrpAdmin(param);
        if (!isSuccess) {
            resp.put("code", (Object)1);
            resp.put("msg", (Object)"failure");
            log.debug("CustomerId = [" + customerId + "] Create drp admin userId = [" + userId + "] failure.");
        }
        return resp;
    }

    public JSONObject deleteDrpUser(Long sysUserId, Long ownerId) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"success");
        HashMap<String, Long> param = new HashMap<String, Long>(8);
        param.put("sysuser", sysUserId);
        param.put("owner", ownerId);
        boolean isSuccess = DrpUserHelper.deleteDrpUser(param);
        if (!isSuccess) {
            resp.put("code", (Object)1);
            resp.put("msg", (Object)"failure");
            log.debug("CustomerId = [" + sysUserId + "] delete drp user userId = [" + ownerId + "] failure.");
        }
        return resp;
    }

    public List<JSONObject> deleteDrpUser(List<Map<Long, Long>> sysUserIdAndOwnerIdMapList) {
        if (CollectionUtils.isEmpty(sysUserIdAndOwnerIdMapList)) {
            ArrayList<JSONObject> respList = new ArrayList<JSONObject>(0);
            return respList;
        }
        ArrayList<JSONObject> respList = new ArrayList<JSONObject>(sysUserIdAndOwnerIdMapList.size());
        HashMap<String, Long> param = new HashMap<String, Long>(8);
        int i = 0;
        for (Map<Long, Long> sysUserIdAndOwnerIdMap : sysUserIdAndOwnerIdMapList) {
            Long sysUserId = sysUserIdAndOwnerIdMap.keySet().iterator().next();
            Long ownerId = sysUserIdAndOwnerIdMap.values().iterator().next();
            param.put("sysuser", sysUserId);
            param.put("owner", ownerId);
            boolean isSuccess = DrpUserHelper.deleteDrpUser(param);
            JSONObject resp = new JSONObject();
            resp.put("code", (Object)0);
            resp.put("seq", (Object)i++);
            if (!isSuccess) {
                resp.put("code", (Object)1);
                log.debug("CustomerId = [" + sysUserId + "] delete drp user userId = [" + ownerId + "] failure.");
            }
            respList.add(resp);
        }
        return respList;
    }
}

