/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.drp.dbd.business.payhelper.PayTradeHelper;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.PayResult;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.RefundResult;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.dbd.mservice.api.PayService;

public class PayServiceImpl
implements PayService {
    public JSONObject tradePay(JSONObject payData, long payChannelId, String authCode, BigDecimal payAmount) {
        CheckOutCounterInfo counterInfo = new CheckOutCounterInfo();
        counterInfo.setBillNo(payData.getString("billNo"));
        counterInfo.setOperatorId(payData.getLong("operatorId").longValue());
        counterInfo.setOperaTime(payData.getDate("operaTime"));
        counterInfo.setStoreId(payData.getLong("storeId").longValue());
        counterInfo.setSubject(payData.getString("subject"));
        if (PaymentModeEnum.getKey((String)"wechatpay") == payChannelId) {
            counterInfo.setBody(payData.getString("body"));
            counterInfo.setSpbillCreateIp("127.0.0.1");
        }
        PayResult payResult = PayTradeHelper.getPayData((CheckOutCounterInfo)counterInfo, (long)payChannelId, (String)authCode, (BigDecimal)payAmount);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tradeStatus", (Object)payResult.getTradeStatus());
        jsonObject.put("errorMessage", (Object)payResult.getErrorMessage());
        jsonObject.put("tradeResponse", (Object)payResult.getPayResponse());
        return jsonObject;
    }

    public JSONObject tradeRefund(JSONObject refundData, long payChannelId, String tradeNo, String outTradeNo, BigDecimal refundAmount) {
        RefundInfo refundInfo = new RefundInfo();
        refundInfo.setBillNo(refundData.getString("billNo"));
        refundInfo.setOperatorId(refundData.getLong("operatorId").longValue());
        refundInfo.setOperaTime(refundData.getDate("operaTime"));
        refundInfo.setStoreId(refundData.getLong("storeId").longValue());
        refundInfo.setIsDeposit(refundData.getBoolean("isDeposit"));
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundInfo, (long)payChannelId, (String)tradeNo, (String)outTradeNo, (BigDecimal)refundAmount);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tradeStatus", (Object)refundResult.getTradeStatus());
        jsonObject.put("errorMessage", (Object)refundResult.getErrorMessage());
        jsonObject.put("tradeResponse", (Object)refundResult.getRefundResponse());
        return jsonObject;
    }
}

