/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.model.CheckResult;

public class CustomerAddressImportPlugin
implements IImportPlugin {
    private Map<Object, String> admindivisionCache = new HashMap<Object, String>();

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        CheckResult result = this.checkImportData(data);
        if (result.isSuccess()) {
            return true;
        }
        importlogs.add(new ImportLogger.ImportLog(result.getMsg()));
        return false;
    }

    private CheckResult checkImportData(Map<String, Object> data) {
        Object addressId = data.get("address");
        String address2 = (String)data.get("address2");
        String detailAddress = null;
        if (null != addressId) {
            String addressStr = this.getAdminDivisionName(addressId);
            detailAddress = addressStr + address2;
            data.put("detailaddress", address2);
        } else {
            data.put("detailaddress", address2);
        }
        return CheckResult.returnTrue();
    }

    private String getAdminDivisionName(Object adminId) {
        String adminName = this.admindivisionCache.get(adminId);
        if (adminName == null) {
            adminName = "";
            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)adminId, (String)"bd_admindivision");
            while (adminDivision != null) {
                adminName = adminDivision.getString("name") + adminName;
                adminDivision = this.getParentAdminDivisionById(adminDivision.getPkValue());
            }
            this.admindivisionCache.put(adminId, adminName);
        }
        return adminName;
    }

    private DynamicObject getParentAdminDivisionById(Object id) {
        DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_admindivision");
        DynamicObject parent = adminDivision.getDynamicObject("parent");
        return parent;
    }
}

