/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.dbd.business.handle.DrpUserHelper;
import kd.drp.mdr.common.enums.ControlStrategy;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAuditOp
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("ordercustomer");
        fieldKeys.add("number");
        fieldKeys.add("classstandardid");
        fieldKeys.add("customergroupid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperationResult operationResult;
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> customerAuthorizes = new ArrayList<DynamicObject>();
        long customerStandardId = 0L;
        DynamicObject customerStandardApply = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"mdr_cust_standard_apply");
        if (customerStandardApply != null && customerStandardApply.getDynamicObject("classstandardid") != null) {
            customerStandardId = customerStandardApply.getDynamicObject("classstandardid").getLong("id");
        }
        DynamicObject customerAuthorize = null;
        for (DynamicObject customer : e.getDataEntities()) {
            customerAuthorize = this.getCustomerAuthorizeFromCustomer(customer, customerStandardId);
            if (customerAuthorize == null) continue;
            customerAuthorizes.add(customerAuthorize);
        }
        if (CollectionUtils.isEmpty(customerAuthorizes) || !(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"mdr_customer_authorize", (DynamicObject[])customerAuthorizes.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            // empty if block
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            long customerId = dataEntity.getLong("id");
            long currentUserId = UserServiceHelper.getCurrentUserId();
            DynamicObject customerAdmin = QueryServiceHelper.queryOne((String)"dbd_customer_admin", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)currentUserId), new QFilter("customer", "=", (Object)customerId)});
            if (null != customerAdmin) continue;
            HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>();
            param.put("user", Long.valueOf(currentUserId));
            param.put("customer", Long.valueOf(customerId));
            param.put("creator", Long.valueOf(currentUserId));
            param.put("createtime", new Date());
            if (DrpUserHelper.insertDrpAdmin(param)) continue;
            throw new KDBizException("\u521b\u5efa\u6e20\u9053\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private DynamicObject getCustomerAuthorizeFromCustomer(DynamicObject customer, long customerStandardId) {
        if (customer.getDynamicObject("ordercustomer") != null) {
            long orderCustomerId = Long.parseLong(customer.getDynamicObject("ordercustomer").getPkValue().toString());
            long customerId = Long.parseLong(customer.getPkValue().toString());
            if (customerId != orderCustomerId) {
                QFilter[] filters = new QFilter[]{new QFilter("authowner", "=", customer.getDynamicObject("ordercustomer").getPkValue()), new QFilter("customer", "=", customer.getPkValue())};
                DynamicObject customerAuthorize = QueryServiceHelper.queryOne((String)"mdr_customer_authorize", (String)F7Utils.appendSelectCols((String)"id", (String[])new String[0]), (QFilter[])filters);
                if (customerAuthorize == null) {
                    return this.createCustomerAuthorizeFromCustomer(customer, customerStandardId);
                }
            }
        }
        return null;
    }

    private DynamicObject createCustomerAuthorizeFromCustomer(DynamicObject customer, long customerStandardId) {
        DynamicObject customerAuthorize = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_authorize");
        customerAuthorize.set("number", (Object)(customer.getDynamicObject("ordercustomer").getString("number") + "_" + customer.getString("number")));
        DynamicObjectUtils.setF7Value((DynamicObject)customerAuthorize, (String)"authowner", (String)"mdr_customer", (Object)customer.getDynamicObject("ordercustomer").getPkValue(), null);
        DynamicObjectUtils.setF7Value((DynamicObject)customerAuthorize, (String)"customer", (String)"mdr_customer", (Object)customer.getPkValue(), null);
        if (!customer.getDynamicObjectCollection("custclassentity").isEmpty() && customerStandardId > 0L) {
            for (DynamicObject customerClass : customer.getDynamicObjectCollection("custclassentity")) {
                DynamicObject customerGroup;
                if (customerStandardId != customerClass.getDynamicObject("classstandardid").getLong("id") || (customerGroup = customerClass.getDynamicObject("customergroupid")) == null || customerGroup.getLong("id") <= 0L) continue;
                DynamicObjectUtils.setF7Value((DynamicObject)customerAuthorize, (String)"customergroup", (String)"mdr_customer_group", (Object)customerGroup.getLong("id"), null);
            }
        }
        customerAuthorize.set("parentinvtype", (Object)"0");
        customerAuthorize.set("discountrate", (Object)BigDecimal.ZERO);
        customerAuthorize.set("taxrate", (Object)BigDecimal.ZERO);
        customerAuthorize.set("leadtime", (Object)0);
        customerAuthorize.set("marketability", (Object)Boolean.FALSE);
        customerAuthorize.set("onlycash", (Object)Boolean.FALSE);
        customerAuthorize.set("creditcontrol", (Object)Boolean.FALSE);
        customerAuthorize.set("ctrlstrategy", (Object)ControlStrategy.SHARE_IN_GLOBAL.toString());
        customerAuthorize.set("enable", (Object)Enable.ENABLE.toString());
        DynamicObjectUtils.setF7Value((DynamicObject)customerAuthorize, (String)"creator", (String)"bos_user", (Object)UserUtil.getUserID(), null);
        customerAuthorize.set("createtime", (Object)new Date());
        return customerAuthorize;
    }
}

