/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAuthorizeBatchSaveOP
extends MdrBaseOperationServicePlugIn {
    private static final String ENTRY_NAME = "entryentity";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs arg) {
        DynamicObject[] saleControlRules = arg.getDataEntities();
        DynamicObject saleRule = saleControlRules[0];
        DynamicObjectCollection ruleCollection = saleRule.getDynamicObjectCollection(ENTRY_NAME);
        int rows = ruleCollection.size();
        if (rows == 0) {
            throw new KDBizException("\u8bf7\u5148\u6dfb\u52a0\u8981\u4fdd\u5b58\u7684\u8ba2\u8d27\u5173\u7cfb\uff01");
        }
        StringBuilder sb = new StringBuilder();
        try (TXHandle h = TX.required();){
            try {
                int row = 0;
                DynamicObject[] ruleArr = new DynamicObject[rows];
                for (DynamicObject rule : ruleCollection) {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_authorize");
                    Object hundredrate = rule.get("hundredrate");
                    BigDecimal disRate = new BigDecimal(hundredrate.toString()).divide(new BigDecimal("100.00")).setScale(4);
                    rule.set("discountrate", (Object)disRate);
                    obj.set("authowner", (Object)saleRule.getDynamicObject("authowner"));
                    obj.set("customer", (Object)rule.getDynamicObject("customer"));
                    obj.set("customergroup", (Object)rule.getDynamicObject("customergroup"));
                    obj.set("parentinvtype", rule.get("parentinvtype"));
                    obj.set("hundredrate", hundredrate);
                    obj.set("discountrate", (Object)disRate);
                    obj.set("leadtime", rule.get("leadtime"));
                    obj.set("logistics", rule.get("logistics"));
                    obj.set("taxrate", rule.get("taxrate"));
                    obj.set("taxrateid", (Object)rule.getDynamicObject("taxrateid"));
                    obj.set("marketability", rule.get("marketability"));
                    obj.set("onlycash", rule.get("onlycash"));
                    obj.set("creditcontrol", rule.get("creditcontrol"));
                    obj.set("enable", rule.get("enable"));
                    obj.set("ctrlstrategy", rule.get("ctrlstrategy"));
                    OperationUtil.addDefaultInfo((DynamicObject)obj);
                    ruleArr[row] = obj;
                    ++row;
                }
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"mdr_customer_authorize", (DynamicObject[])ruleArr, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(String.format("\u8ba2\u8d27\u5173\u7cfb\uff1a%s - ", result.getMessage()));
                    HashSet rowIndex = result.getValidateResult().getErrorDataIndexs();
                    int index = 0;
                    for (Integer rowin : rowIndex) {
                        List validResultList = result.getValidateResult().getValidateErrors();
                        sb.append(String.format("\u7b2c%d\u884c\uff1a", rowin + 1));
                        int resultSize = validResultList.size();
                        for (int i = 0; i < resultSize; ++i) {
                            ValidateResult validation = (ValidateResult)validResultList.get(i);
                            OperateErrorInfo info = (OperateErrorInfo)validation.getAllErrorInfo().get(index);
                            sb.append(info.getMessage());
                            if (i == resultSize - 1) {
                                sb.append('\uff1b');
                                continue;
                            }
                            sb.append('\uff0c');
                        }
                        ++index;
                    }
                    if (sb.length() > 0) {
                        throw new KDBizException(sb.toString());
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw new KDBizException(e.getLocalizedMessage());
            }
        }
    }
}

