/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAuthorizeBatchUpOP
extends MdrBaseOperationServicePlugIn {
    public static HashMap<String, Integer> updatefields = new HashMap();
    private static final int TYPE_STRING = 1;
    private static final int TYPE_BIGINT = 2;
    private static final int TYPE_DECIMAL = 3;
    private static final int TYPE_CHAR = 4;
    private static final int TYPE_BOOLEAN = 5;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        DynamicObject updobj = objs[0];
        String editField = updobj.getString("editfield");
        if (StringUtils.isNotBlank((CharSequence)editField)) {
            this.customerAuthorize(editField, this.getSelectedAuthorizeIds(updobj), updobj);
        }
    }

    private void customerAuthorize(String editField, Object[] authorizeIds, DynamicObject updobj) {
        String columnName = null;
        switch (editField) {
            case "customergroup": {
                columnName = "FCUSTOMERGROUPID";
                DynamicObject obj = updobj.getDynamicObject(editField);
                if (obj != null) {
                    this.batchEditAuthorize(columnName, obj.get("id"), authorizeIds);
                    break;
                }
                throw new KDBizException("\u6e20\u9053\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "parentinvtype": {
                columnName = "FPARENTINVTYPE";
                Object parentinvtype = updobj.get(editField);
                if (parentinvtype != null) {
                    this.batchEditAuthorize(columnName, parentinvtype, authorizeIds);
                    break;
                }
                throw new KDBizException("\u663e\u793a\u4e0a\u7ea7\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "hundredrate": {
                columnName = "FHUNDREDRATE";
                Object hundredrate = updobj.get(editField);
                if (hundredrate == null) {
                    throw new KDBizException("\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                }
                this.batchEditAuthorize(columnName, hundredrate, authorizeIds);
                columnName = "FDISCOUNTRATE";
                BigDecimal disRate = new BigDecimal(hundredrate.toString()).divide(new BigDecimal("100.00")).setScale(4);
                this.batchEditAuthorize(columnName, disRate, authorizeIds);
                break;
            }
            case "leadtime": {
                columnName = "FLEADTIME";
                Object leadtime = updobj.get(editField);
                if (leadtime != null) {
                    this.batchEditAuthorize(columnName, leadtime, authorizeIds);
                    break;
                }
                throw new KDBizException("\u8ba2\u8d27\u63d0\u524d\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "logistics": {
                columnName = "FLOGISTICS";
                DynamicObject logistics = updobj.getDynamicObject(editField);
                if (logistics != null) {
                    this.batchEditAuthorize(columnName, logistics.get("id"), authorizeIds);
                    break;
                }
                throw new KDBizException("\u5e38\u7528\u7269\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "taxrate": {
                columnName = "FTAXRATE";
                Object taxrate = updobj.get(editField);
                if (taxrate != null) {
                    this.batchEditAuthorize(columnName, taxrate, authorizeIds);
                    break;
                }
                throw new KDBizException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "marketability": {
                columnName = "FMARKETABILITY";
                Object marketability = updobj.get(editField);
                if (marketability != null) {
                    this.batchEditAuthorize(columnName, marketability, authorizeIds);
                    break;
                }
                throw new KDBizException("\u53ef\u9500\u5546\u54c1\u63a7\u5236\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "onlycash": {
                columnName = "FONLYCASH";
                Object onlycash = updobj.get(editField);
                if (onlycash != null) {
                    this.batchEditAuthorize(columnName, onlycash, authorizeIds);
                    break;
                }
                throw new KDBizException("\u4ec5\u73b0\u9500\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "creditcontrol": {
                columnName = "FCREDITCONTROL";
                Object creditcontrol = updobj.get(editField);
                if (creditcontrol != null) {
                    this.batchEditAuthorize(columnName, creditcontrol, authorizeIds);
                    break;
                }
                throw new KDBizException("\u4fe1\u7528\u63a7\u5236\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void batchEditAuthorize(String columnName, Object updateValue, Object[] authorizeIds) {
        this.batchEdit(columnName, updateValue, authorizeIds);
    }

    private void batchEdit(String columnName, Object updateValue, Object[] authorizeIds) {
        try {
            if (authorizeIds != null && authorizeIds.length > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE ");
                sql.append(" T_MDR_CUSTOMER_AUTHORIZE ");
                sql.append(" SET ");
                sql.append(columnName);
                sql.append(" = ? WHERE FAUTHORIZEID = ? ");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(authorizeIds.length);
                Object[] params = null;
                for (Object authorizeId : authorizeIds) {
                    params = new Object[2];
                    if (updateValue != null) {
                        if (updatefields.get(columnName) != null) {
                            if (updatefields.get(columnName).equals(1)) {
                                params[0] = updateValue == null ? "" : updateValue;
                            } else if (updatefields.get(columnName).equals(2)) {
                                params[0] = updateValue == null ? 0L : Long.parseLong(updateValue.toString());
                            } else if (updatefields.get(columnName).equals(3)) {
                                params[0] = updateValue == null ? BigDecimal.ZERO : new BigDecimal(updateValue.toString());
                            } else if (updatefields.get(columnName).equals(4)) {
                                params[0] = Character.valueOf(updateValue == null ? (char)'0' : updateValue.toString().charAt(0));
                            } else if (updatefields.get(columnName).equals(5)) {
                                params[0] = Character.valueOf((char)(updateValue != null && updateValue.toString().equalsIgnoreCase("true") ? 49 : 48));
                            }
                        }
                    } else {
                        params[0] = updateValue;
                    }
                    params[1] = Long.valueOf(authorizeId.toString());
                    paramsList.add(params);
                }
                DB.executeBatch((DBRoute)new DBRoute("mdr"), (String)sql.toString(), paramsList);
                BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mdr_customer_authorize"));
                this.updateTreeCache(authorizeIds);
            }
        }
        catch (Exception e) {
            throw new KDBizException("\u8ba2\u8d27\u5173\u7cfb\u6279\u91cf\u4fee\u6539\u5931\u8d25");
        }
    }

    private Object[] getSelectedAuthorizeIds(DynamicObject updobj) {
        String ids = updobj.getString("authorizeids");
        Object[] authorizeids = new String[]{};
        if (!StringUtils.isNotBlank((CharSequence)ids)) {
            return new Object[0];
        }
        authorizeids = ids.split(",");
        return authorizeids;
    }

    private void updateTreeCache(Object[] authorizeIds) {
        if (authorizeIds != null && authorizeIds.length > 0) {
            ArrayList<Long> idlist = new ArrayList<Long>();
            for (Object id : authorizeIds) {
                idlist.add(Long.valueOf(id.toString()));
            }
            QFilter qFilter = new QFilter("id", "in", idlist);
            DynamicObjectCollection conll = QueryServiceHelper.query((String)"mdr_customer_authorize", (String)"customer,authowner,customergroup,parentinvtype,hundredrate,leadtime,logistics,taxrate,marketability,onlycash,creditcontrol,enable,isdefault", (QFilter[])new QFilter[]{qFilter});
            ArrayList<AuthCust> newRelation = new ArrayList<AuthCust>();
            for (DynamicObject data : conll) {
                newRelation.add(new AuthCust(Long.valueOf(data.getLong("authowner")), Long.valueOf(data.getLong("customer")), data.getString("enable"), data.getBoolean("marketability"), data.getBoolean("isdefault")));
            }
            CustomerTreeCache.updateTreeCacheAdd(newRelation);
        }
    }

    static {
        updatefields.put("FLOGISTICS", 1);
        updatefields.put("FLEADTIME", 2);
        updatefields.put("FHUNDREDRATE", 3);
        updatefields.put("FDISCOUNTRATE", 3);
        updatefields.put("FTAXRATE", 3);
        updatefields.put("FPARENTINVTYPE", 4);
        updatefields.put("FMARKETABILITY", 5);
        updatefields.put("FONLYCASH", 5);
        updatefields.put("FCREDITCONTROL", 5);
    }
}

