/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.customer.validator.CustomerAuthValidator;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAuthorizeDelete
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("customer");
        fieldKeys.add("authowner");
        fieldKeys.add("marketability");
        fieldKeys.add("enable");
        fieldKeys.add("isdefault");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CustomerAuthValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] relations = e.getDataEntities();
        this.updateCustomerHasNoOwner(relations);
    }

    private void updateCustomerHasNoOwner(DynamicObject[] relations) {
        DynamicObject[] customers;
        if (relations == null || relations.length <= 0) {
            return;
        }
        int preSize = relations.length;
        HashSet<Object> allIds = new HashSet<Object>(preSize);
        for (DynamicObject relation : relations) {
            allIds.add(relation.getDynamicObject("customer").getPkValue());
        }
        QFilter fs = new QFilter("customer", "in", allIds);
        Set exsistId = QueryUtil.querySingleCol((String)"mdr_customer_authorize", (String)"customer", (QFilter[])fs.toArray());
        allIds.removeAll(exsistId);
        fs = new QFilter("id", "in", allIds);
        String selectCols = QueryUtil.getSelectCols((String[])new String[]{"id", "hasowner"});
        for (DynamicObject customer : customers = BusinessDataServiceHelper.load((String)"mdr_customer", (String)selectCols, (QFilter[])fs.toArray())) {
            customer.set("hasowner", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])customers);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] relations = e.getDataEntities();
        if (relations == null || relations.length <= 0) {
            return;
        }
        ArrayList<AuthCust> deleteRelations = new ArrayList<AuthCust>(relations.length);
        for (DynamicObject relation : relations) {
            deleteRelations.add(new AuthCust(relation));
        }
        CustomerTreeCache.updateTreeCacheDelete(deleteRelations);
    }
}

