/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.customer.validator.CustomerAuthValidator;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.model.AuthCust;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAuthorizeSaveplugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(String.join((CharSequence)",", "authowner", "number"));
        fieldKeys.add(String.join((CharSequence)",", "customer", "number"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CustomerAuthValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        this.updateCustomerHasOwner(datas);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length <= 0) {
            return;
        }
        int preSize = datas.length;
        ArrayList<AuthCust> newRelation = new ArrayList<AuthCust>(preSize);
        for (DynamicObject data : datas) {
            newRelation.add(new AuthCust(data));
        }
        CustomerTreeCache.updateTreeCacheAdd(newRelation);
    }

    private void updateCustomerHasOwner(DynamicObject[] datas) {
        DynamicObject[] customers;
        if (datas == null || datas.length <= 0) {
            return;
        }
        HashSet<Object> customerIds = new HashSet<Object>();
        for (DynamicObject data : datas) {
            if (!DynamicObjectUtils.isNewCreate((DynamicObject)data)) continue;
            customerIds.add(data.getDynamicObject("customer").get("id"));
        }
        if (customerIds.size() == 0) {
            return;
        }
        QFilter fs = new QFilter("id", "in", customerIds);
        String selectCols = QueryUtil.getSelectCols((String[])new String[]{"id", "hasowner"});
        for (DynamicObject customer : customers = BusinessDataServiceHelper.load((String)"mdr_customer", (String)selectCols, (QFilter[])fs.toArray())) {
            customer.set("hasowner", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])customers);
    }
}

