/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerRelAuditPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("channel");
        fieldKeys.add("customer");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dynObjs = e.getDataEntities();
        ArrayList<DynamicObject> newDynObjList = new ArrayList<DynamicObject>();
        for (int i = 0; i < dynObjs.length; ++i) {
            QFilter q = new QFilter("authowner", "=", dynObjs[i].get("channel.id")).and("customer", "=", dynObjs[i].get("customer.id"));
            if (QueryServiceHelper.exists((String)"mdr_customer_authorize", (QFilter[])q.toArray())) continue;
            DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_authorize");
            dynObj.set("number", (Object)this.getNumber(dynObjs[i]));
            dynObj.set("authowner", dynObjs[i].get("channel.id"));
            dynObj.set("customer", dynObjs[i].get("customer.id"));
            dynObj.set("leadtime", (Object)1);
            dynObj.set("discountrate", (Object)1);
            dynObj.set("enable", (Object)"1");
            dynObj.set("status", (Object)"C");
            dynObj.set("creator", UserUtil.getUserID());
            dynObj.set("modifier", UserUtil.getUserID());
            dynObj.set("createtime", (Object)new Date());
            dynObj.set("modifytime", (Object)new Date());
            newDynObjList.add(dynObj);
        }
        if (newDynObjList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newDynObjList.toArray(new DynamicObject[0]));
            CustomerTreeCache.refreshCache();
        }
    }

    private String getNumber(DynamicObject dynObj) {
        String ownerNumber = "";
        String customerNumber = "";
        DynamicObject owner = dynObj.getDynamicObject("channel");
        String key = "number";
        if (owner != null) {
            ownerNumber = owner.getString(key);
        }
        DynamicObject customer = dynObj.getDynamicObject("customer");
        if (owner != null) {
            customerNumber = customer.getString(key);
        }
        return ownerNumber + "_" + customerNumber;
    }
}

