/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.permission.model.Bizpartner;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.dbd.opplugin.customer.validator.CustomerValidator;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerSave
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("legalcustomer");
        fieldKeys.add("receivecustomer");
        fieldKeys.add("balancecustomer");
        fieldKeys.add("paycustomer");
        fieldKeys.add("isinnerorg");
        fieldKeys.add(String.join((CharSequence)".", "parentcustomer", "longnumber"));
        fieldKeys.add(String.join((CharSequence)".", "parentcustomer", "longid"));
        fieldKeys.add("longnumber");
        fieldKeys.add("longid");
        fieldKeys.add("partner");
        fieldKeys.add("phone");
        fieldKeys.add("eascustomerid");
        fieldKeys.add("customertype");
        fieldKeys.add("bdcustomer");
        fieldKeys.add("ordercustomer");
        fieldKeys.add("fid");
        fieldKeys.add("grade");
        fieldKeys.add("group");
        fieldKeys.add(String.join((CharSequence)".", "custclassentity", "classstandardid"));
        fieldKeys.add(String.join((CharSequence)".", "custclassentity", "customergroupid"));
        fieldKeys.add("customerproperty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CustomerValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas;
        super.beginOperationTransaction(e);
        for (DynamicObject data : datas = e.getDataEntities()) {
            this.synPartner2Customer(data);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] customers = e.getDataEntities();
        boolean isUpdate = false;
        if (customers != null && customers.length > 0) {
            IDataEntityType type = null;
            for (DynamicObject customer : customers) {
                boolean isSetFid;
                long customerId;
                if (type == null) {
                    type = customer.getDataEntityType();
                }
                if ((customerId = customer.getLong("id")) <= 0L) continue;
                boolean isSetLegalCustomer = this.setCustomer2This(customer, "legalcustomer");
                boolean isSetReceiveCustomer = this.setCustomer2This(customer, "receivecustomer");
                boolean isSetBalanceCustomer = this.setCustomer2This(customer, "balancecustomer");
                boolean isSetPayCustomer = this.setCustomer2This(customer, "paycustomer");
                DynamicObject parentCustomer = customer.getDynamicObject("parentcustomer");
                if (parentCustomer != null && (StringUtils.isEmpty((String)parentCustomer.getString("longnumber")) || StringUtils.isEmpty((String)parentCustomer.getString("longid")))) {
                    parentCustomer = BusinessDataServiceHelper.loadSingle((Object)parentCustomer.getPkValue(), (DynamicObjectType)parentCustomer.getDynamicObjectType());
                }
                boolean bl = isSetFid = customer.getLong("id") != customer.getLong("fid");
                if (isSetFid) {
                    customer.set("fid", (Object)customer.getLong("id"));
                }
                boolean isSetDefaultCustomerLongID = this.setDefaultCustomerLongID(customer, parentCustomer);
                boolean isSetDefaultCustomerLongNumber = this.setDefaultCustomerLongNumber(customer, parentCustomer);
                boolean isSetCustomerGroupId = false;
                DynamicObjectCollection customerClassEntries = customer.getDynamicObjectCollection("custclassentity");
                for (DynamicObject customerClassEntry : customerClassEntries) {
                    if (customerClassEntry.getDynamicObject("classstandardid") == null || 836014120472951808L != customerClassEntry.getDynamicObject("classstandardid").getLong("id") || customerClassEntry.getDynamicObject("customergroupid") == null && customer.getDynamicObject("group") == null) continue;
                    if (customerClassEntry.getDynamicObject("customergroupid") != null && customer.getDynamicObject("group") == null) {
                        customer.set("group", (Object)customerClassEntry.getDynamicObject("customergroupid"));
                        isSetCustomerGroupId = true;
                        break;
                    }
                    if (customerClassEntry.getDynamicObject("customergroupid") == null && customer.getDynamicObject("group") != null) {
                        customer.set("group", null);
                        isSetCustomerGroupId = true;
                        break;
                    }
                    if (customerClassEntry.getDynamicObject("customergroupid").getLong("id") == customer.getDynamicObject("group").getLong("id")) continue;
                    customer.set("group", (Object)customerClassEntry.getDynamicObject("customergroupid"));
                    isSetCustomerGroupId = true;
                    break;
                }
                isUpdate = isSetLegalCustomer || isSetReceiveCustomer || isSetBalanceCustomer || isSetPayCustomer || isSetDefaultCustomerLongID || isSetDefaultCustomerLongNumber || isSetFid || isSetCustomerGroupId;
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
            }
        }
    }

    private boolean setDefaultCustomerLongNumber(DynamicObject customer, DynamicObject parentCustomer) {
        boolean isUpdate = false;
        if (StringUtils.isEmpty((String)customer.getString("longnumber"))) {
            if (parentCustomer == null) {
                customer.set("longnumber", (Object)customer.getString("number"));
            } else {
                customer.set("longnumber", (Object)(customer.getString("number") + "." + parentCustomer.getString("longnumber")));
            }
            isUpdate = true;
        }
        return isUpdate;
    }

    private boolean setDefaultCustomerLongID(DynamicObject customer, DynamicObject parentCustomer) {
        boolean isUpdate = false;
        if (StringUtils.isEmpty((String)customer.getString("longid"))) {
            if (parentCustomer == null) {
                customer.set("longid", (Object)customer.getString("id"));
            } else {
                customer.set("longid", (Object)(customer.getString("id") + "." + parentCustomer.getString("longid")));
            }
            isUpdate = true;
        }
        return isUpdate;
    }

    private boolean setCustomer2This(DynamicObject customer, String propertyName) {
        boolean isUpdate = false;
        DynamicObject legalCustomer = customer.getDynamicObject(propertyName);
        if (legalCustomer == null) {
            customer.set(propertyName, (Object)customer);
            isUpdate = true;
        }
        return isUpdate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void synPartner2Customer(DynamicObject customer) {
        DynamicObject partner = customer.getDynamicObject("partner");
        StringBuilder errorInfo = new StringBuilder(ResManager.loadKDString((String)"\u6e20\u9053\u4fe1\u606f\u540c\u6b65\u5546\u52a1\u4f19\u4f34\u5931\u8d25\uff1a", (String)"CustomerSave_2", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        if (partner == null) {
            Bizpartner bdBizpartner = this.prase2Bizpartner(customer);
            boolean success = this.createBizPartner(errorInfo, bdBizpartner);
            if (!success) throw new KDBizException(errorInfo.toString());
            Long id = bdBizpartner.getId();
            if (id == null || id == 0L) {
                errorInfo.append(ResManager.loadKDString((String)"id\u4e0d\u5b58\u5728", (String)"CustomerSave_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
                throw new KDBizException(errorInfo.toString());
            }
            partner = BusinessDataServiceHelper.newDynamicObject((String)"bd_bizpartner");
            partner.set("id", (Object)id);
            partner.set("name", (Object)bdBizpartner.getName());
            partner.set("number", (Object)bdBizpartner.getNumber());
            customer.set("partner", (Object)partner);
            return;
        } else {
            String partnerRole;
            Bizpartner oldPartner = PermissionServiceHelper.queryBizpartner((Long)partner.getLong("id"), (StringBuilder)errorInfo);
            boolean isModify = false;
            String customerName = customer.getString("name");
            if (!oldPartner.getName().equals(customerName)) {
                oldPartner.setName(customerName);
                partner.set("name", (Object)customerName);
                isModify = true;
            }
            if (!(partnerRole = oldPartner.getPartnerrole()).contains("3")) {
                oldPartner.setPartnerrole(StringUtils.isEmpty((String)partnerRole) ? "3" : partnerRole + "3,");
                isModify = true;
            }
            long saleOrgId = customer.getDynamicObject("bizgroup").getLong("id");
            if (customer.getBoolean("isinnerorg") && oldPartner.getInternal_company_id() != saleOrgId) {
                oldPartner.setInternal_company_id(Long.valueOf(saleOrgId));
                isModify = true;
            }
            if (!isModify) return;
            this.updateBizPartner(errorInfo, oldPartner);
        }
    }

    private void updateBizPartner(StringBuilder errorInfo, Bizpartner bdBizpartner) {
        boolean success = true;
        try (TXHandle newTx = null;){
            newTx = TX.requiresNew();
            success = PermissionServiceHelper.modifyBizpartner((Bizpartner)bdBizpartner, (StringBuilder)errorInfo);
        }
        if (!success) {
            throw new KDBizException(errorInfo.toString());
        }
    }

    private boolean createBizPartner(StringBuilder errorInfo, Bizpartner bdBizpartner) {
        try (TXHandle newTx = null;){
            newTx = TX.requiresNew();
            boolean bl = PermissionServiceHelper.createBizpartner((Bizpartner)bdBizpartner, (StringBuilder)errorInfo);
            return bl;
        }
    }

    private Bizpartner prase2Bizpartner(DynamicObject data) {
        Bizpartner bp = new Bizpartner();
        bp.setName(data.getString("name"));
        bp.setNumber(data.getString("number"));
        bp.setType("1");
        boolean isInnerOrg = data.getBoolean("isinnerorg");
        if (isInnerOrg) {
            bp.setInternal_company_id(Long.valueOf(data.getDynamicObject("bizgroup").getLong("id")));
        }
        bp.setStatus("C");
        bp.setEnable("1");
        bp.setPartnerrole("3");
        return bp;
    }
}

