/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.validator.BatchFastValidator;

public class CustomerAuthValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            result = this.save(data.getDataEntity());
            if (result.isSuccess()) continue;
            this.addFatalErrorMessage(data, result.getMsg());
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        if (this.isFromListPage()) {
            return;
        }
        this.save(datas);
    }

    private CheckResult save(DynamicObject data) {
        Set allCanSelectIds;
        boolean isEasSync;
        Object customerId;
        DynamicObject authOwner = data.getDynamicObject("authowner");
        DynamicObject customer = data.getDynamicObject("customer");
        if (authOwner == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomerAuthValidator_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        if (customer == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomerAuthValidator_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        Object authOwnerId = authOwner.get("id");
        if (authOwnerId.equals(customerId = customer.get("id"))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u548c\u8ba2\u8d27\u6e20\u9053\u4e0d\u80fd\u540c\u4e3a\u4e00\u4e2a\u6e20\u9053", (String)"CustomerAuthValidator_2", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        if (customer.getBoolean("isinnerorg")) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053\u3010%s\u3011\u662f\u5185\u90e8\u6e20\u9053\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8ba2\u8d27\u6e20\u9053", (String)"CustomerAuthValidator_3", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customer.get("name")});
        }
        if (data.getBoolean("isdefault") && CustomerUtil.queryCustomerByCustom((Object)customerId, (Object)authOwnerId).booleanValue()) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\u9ed8\u8ba4\u7684\u9500\u552e\u9500\u6e20\u9053!", (String)"CustomerAuthValidator_4", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customer.get("name")});
        }
        boolean isNewCreate = DynamicObjectUtils.isNewCreate((DynamicObject)data);
        if (!isNewCreate) {
            QFilter fs = new QFilter("id", "=", data.get("id"));
            fs.and("authowner", "=", authOwnerId);
            fs.and("customer", "=", customerId);
            boolean exists = QueryServiceHelper.exists((String)"mdr_customer_authorize", (QFilter[])fs.toArray());
            if (exists) {
                return CheckResult.returnTrue();
            }
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u8fc7\u7684\u6570\u636e\uff0c\u9500\u552e\u6e20\u9053\u548c\u8ba2\u8d27\u6e20\u9053\u4e0d\u80fd\u518d\u6b21\u4fee\u6539", (String)"CustomerAuthValidator_5", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
        QFilter fs = F7Utils.getEnableFilter();
        ArrayList<Object> ids = new ArrayList<Object>(2);
        ids.add(customerId);
        ids.add(authOwnerId);
        fs.and("id", "in", ids);
        Set dbIds = QueryUtil.querySingleCol((String)"mdr_customer", (String)"id", (QFilter[])fs.toArray());
        if (!dbIds.contains(customerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u3010%s\u3011\u5fc5\u987b\u662f\u542f\u7528\u72b6\u6001", (String)"CustomerAuthValidator_6", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customer.get("name")});
        }
        if (!dbIds.contains(authOwnerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u3010%s\u3011\u5fc5\u987b\u662f\u542f\u7528\u72b6\u6001", (String)"CustomerAuthValidator_7", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{authOwner.get("name")});
        }
        boolean bl = isEasSync = this.getOption().containsVariable("isEasSync") && "true".equals(this.getOption().getVariableValue("isEasSync"));
        if (!isEasSync && !(allCanSelectIds = CustomerUtil.getAllAuthSubsIdsAndSelfByIds(new HashSet(UserUtil.getAuthorizedOwnerIDs()))).contains(authOwnerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u3010%s\u3011\u5fc5\u987b\u662f\u5f53\u524d\u7528\u6237\u7ba1\u7406\u6e20\u9053\u6216\u7ba1\u7406\u6e20\u9053\u7684\u4e0b\u5c42\u6e20\u9053", (String)"CustomerAuthValidator_8", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{authOwner.get("name")});
        }
        Set authOwners = CustomerUtil.getAuthOwnerIDIgnoreVaild((Object)authOwnerId);
        if (authOwners.contains(customerId)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u8ba2\u8d27\u6e20\u9053\u3010%s\u3011\u5df2\u7ecf\u5b58\u5728\u5728\u4e0a\u7ea7\u9500\u552e\u9500\u6e20\u9053\u4e2d!", (String)"CustomerAuthValidator_9", (String)"drp-dbd-opplugin", (Object[])new Object[0]), (Object[])new Object[]{customer.get("name")});
        }
        if (StringUtils.isNotEmpty((CharSequence)authOwner.getString("number")) && StringUtils.isNotEmpty((CharSequence)customer.getString("number"))) {
            data.set("number", (Object)(authOwner.getString("number") + "_" + customer.getString("number")));
        }
        return CheckResult.returnTrue();
    }
}

