/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.customer.validator;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.CustomerTypeId;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.PhoneType;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.validator.BatchFastValidator;
import org.apache.commons.lang3.StringUtils;

public class CustomerValidator
extends BatchFastValidator {
    public void save(ExtendedDataEntity[] datas) {
        CheckResult result = null;
        for (ExtendedDataEntity data : datas) {
            result = this.save(data.getDataEntity());
            if (result.isSuccess()) continue;
            this.addFatalErrorMessage(data, result.getMsg());
        }
    }

    public void submit(ExtendedDataEntity[] datas) {
        if (this.isFromListPage()) {
            return;
        }
        this.save(datas);
    }

    private CheckResult checkRelation(DynamicObject data) {
        CustomerProperty customerProperty;
        boolean isConnectErpCloud = "A".equalsIgnoreCase(SysParamsUtil.getConnectERP());
        if (isConnectErpCloud && (customerProperty = CustomerProperty.CustomerProperty((String)data.getString("customerproperty"))) != null) {
            switch (customerProperty) {
                case DIRECT_CUSTOMER: 
                case MIX_CUSTOMER: {
                    if (data.getDynamicObject("bdcustomer") != null) break;
                    return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5f53\u6e20\u9053\u6027\u8d28={\u76f4\u63a5\u6e20\u9053\uff0c\u6df7\u5408\u6e20\u9053}\uff0c\u5ba2\u6237\u5fc5\u586b\uff01", (String)"CustomerValidator_6", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
                }
                case INDIRECT_CUSTOMER: {
                    break;
                }
            }
        }
        if (DynamicObjectUtils.isNewCreate((DynamicObject)data)) {
            DynamicObject bizGroup = data.getDynamicObject("bizgroup");
            if (bizGroup == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u6e20\u9053\u6240\u5c5e\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CustomerValidator_7", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
            data.set("hascustomer", (Object)Boolean.FALSE);
            data.set("hasowner", (Object)Boolean.FALSE);
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkSaleOrgUniquenessOnSomeCustomerType(DynamicObject customer) {
        DynamicObject customerType = customer.getDynamicObject("customertype");
        if (customerType != null) {
            CustomerTypeId customerTypeId;
            if (StringUtils.isEmpty((CharSequence)customerType.getString("typeid"))) {
                customerType = BusinessDataServiceHelper.loadSingle((Object)customerType.getPkValue(), (DynamicObjectType)customerType.getDynamicObjectType());
            }
            if ((customerTypeId = CustomerTypeId.CustomerTypeId((String)customerType.getString("typeid"))) != null) {
                switch (customerTypeId) {
                    case NEIBUZUZHI: 
                    case ZHIYINGMENDIAN_DULIHESUAN: 
                    case JIAMENGMENDIAN_DULIHESUAN: {
                        DynamicObject saleOrg = customer.getDynamicObject("bizgroup");
                        if (saleOrg == null || saleOrg.getLong("id") <= 0L) break;
                        QFilter fs = new QFilter("customertype.typeid", "=", (Object)customerTypeId.toString());
                        fs.and(new QFilter("bizgroup", "=", (Object)saleOrg.getLong("id")));
                        if (customer.getLong("id") > 0L) {
                            fs.and(new QFilter("id", "!=", (Object)customer.getLong("id")));
                        }
                        DynamicObjectCollection customers = QueryServiceHelper.query((String)"mdr_customer", (String)"id,number", (QFilter[])fs.toArray());
                        boolean isExist = false;
                        if (customer.getLong("id") == 0L && !CollectionUtils.isEmpty((Collection)customers)) {
                            isExist = true;
                        } else if (customer.getLong("id") > 0L && customers.size() == 1 && ((DynamicObject)customers.get(0)).getLong("id") != customer.getLong("id")) {
                            isExist = true;
                        }
                        if (!isExist) break;
                        if (customerTypeId == CustomerTypeId.NEIBUZUZHI) {
                            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u7ecf\u5efa\u7acb\u4e86\u5bf9\u5e94\u7684\u6e20\u9053\uff01\u4e0d\u5141\u8bb8\u91cd\u590d\u5efa\u7acb\uff01", (String)"CustomerValidator_10", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
                        }
                        return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8be5\u95e8\u5e97\u5df2\u7ecf\u5efa\u7acb\u4e86\u5bf9\u5e94\u7684\u6e20\u9053\uff01\u4e0d\u5141\u8bb8\u91cd\u590d\u5efa\u7acb\uff01", (String)"CustomerValidator_11", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        return CheckResult.returnTrue();
    }

    private CheckResult save(DynamicObject data) {
        CheckResult result = this.checkRelation(data);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.checkSaleOrgUniquenessOnSomeCustomerType(data);
        if (!result.isSuccess()) {
            return result;
        }
        String phone = data.getString("phone");
        String string = phone = phone == null ? phone : phone.trim();
        if (!StringUtils.isEmpty((CharSequence)phone) && !(result = ValidateUtils.validPhoneNum((PhoneType)PhoneType.ALL, (String)phone)).isSuccess()) {
            return result;
        }
        return result;
    }
}

