/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.distributionrules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.F7Utils;

public class SaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        if (entities == null || entities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject data = entity.getDataEntity();
            DynamicObjectCollection entryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)data, (String)"entryentity");
            if (entryData == null || entryData.size() <= 0) continue;
            ArrayList<String> lstCombination = new ArrayList<String>();
            for (DynamicObject entryItem : entryData) {
                int seq = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"seq");
                String combination = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"combination");
                lstCombination.add(combination);
                this.checkStock(entity, entryItem, seq);
                this.checkMode(entity, entryItem, seq);
                this.checkErpStock(entity, entryItem, seq);
            }
            this.checkRepetition(entity, entryData, lstCombination);
        }
    }

    private void checkStock(ExtendedDataEntity dataEntity, DynamicObject dyObj, int seq) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"branch");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"stock");
        if (branchId != 0L && stockId <= 0L) {
            String strMsg = String.format("\u7b2c%d\u884c\uff1a\u53d1\u8d27\u95e8\u5e97\u6709\u503c\uff0c\u95e8\u5e97\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq);
            this.addErrorMessage(dataEntity, strMsg);
        }
    }

    private void checkMode(ExtendedDataEntity dataEntity, DynamicObject dyObj, int seq) {
        long modeId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"mode");
        long inventoryOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"inventoryorg");
        if (modeId != 926596489101228032L && inventoryOrgId <= 0L) {
            String strMsg = String.format("\u7b2c%d\u884c\uff1a\u914d\u9001\u6a21\u5f0f\u4e3a\u96c6\u4e2d\u914d\u9001\u6216\u4e8c\u7ea7\u914d\u9001\uff0c\u53d1\u8d27\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq);
            this.addErrorMessage(dataEntity, strMsg);
        }
    }

    private void checkErpStock(ExtendedDataEntity dataEntity, DynamicObject dyObj, int seq) {
        long inventoryOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"inventoryorg");
        long erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"erpstock");
        if (inventoryOrgId != 0L && erpStockId <= 0L) {
            String strMsg = String.format("\u7b2c%d\u884c\uff1a\u53d1\u8d27\u5e93\u5b58\u7ec4\u7ec7\u6709\u503c\uff0c\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq);
            this.addErrorMessage(dataEntity, strMsg);
        }
    }

    private void checkRepetition(ExtendedDataEntity dataEntity, DynamicObjectCollection dyObjs, List<String> lstData) {
        this.checkRepeatInCurrent(dataEntity, dyObjs, lstData);
        this.checkRepeatInDatabase(dataEntity, dyObjs, lstData);
    }

    private void checkRepeatInCurrent(ExtendedDataEntity dataEntity, DynamicObjectCollection dyObjs, List<String> lstData) {
        HashSet set = new HashSet(lstData.size());
        ArrayList lstRepeat = new ArrayList();
        lstData.forEach(x -> {
            if (!set.add(x)) {
                lstRepeat.add(x);
            }
        });
        if (set.size() < dyObjs.size()) {
            dyObjs.forEach(x -> {
                String combination = DynamicObjectUtils.getString((DynamicObject)x, (String)"combination");
                if (lstRepeat.contains(combination)) {
                    int seq = DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq");
                    String strMsg = String.format("\u7b2c%d\u884c: \u201c\u9500\u552e\u7ec4\u7ec7\u201d\u3001\u201c\u9500\u552e\u95e8\u5e97\u201d\u3001\u201c\u5546\u54c1\u5206\u7c7b\u201d\u3001\u201c\u5546\u54c1\u201d\u3001\u201c\u56fd\u5bb6\u5730\u533a\u201d\u3001\u201c\u7701\u201d\u3001\u201c\u5e02\u201d\u3001\u201c\u533a\u201d\u3001\u201c\u53d1\u8d27\u95e8\u5e97\u201d\u3001\u201c\u95e8\u5e97\u4ed3\u5e93\u201d\u3001\u201c\u4f18\u5148\u7ea7\u201d\u3001\u201c\u914d\u9001\u6a21\u5f0f\u201d\u3001\u201c\u53d1\u8d27\u5e93\u5b58\u7ec4\u7ec7\u201d\u3001\u201c\u4ed3\u5e93\u201d\u5747\u5df2\u5b58\u5728\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", seq);
                    this.addErrorMessage(dataEntity, strMsg);
                }
            });
        }
    }

    private void checkRepeatInDatabase(ExtendedDataEntity dataEntity, DynamicObjectCollection dyObjs, List<String> lstData) {
        DynamicObject[] repeatData = this.getRulesFromDataBase(lstData);
        if (repeatData != null && repeatData.length > 0) {
            List lstRepeat = Arrays.stream(repeatData).map(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"combination")).collect(Collectors.toList());
            dyObjs.forEach(x -> {
                String combination = DynamicObjectUtils.getString((DynamicObject)x, (String)"combination");
                if (lstRepeat.contains(combination)) {
                    int seq = DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq");
                    String strMsg = String.format("\u7b2c%d\u884c: \u201c\u9500\u552e\u7ec4\u7ec7\u201d\u3001\u201c\u9500\u552e\u95e8\u5e97\u201d\u3001\u201c\u5546\u54c1\u5206\u7c7b\u201d\u3001\u201c\u5546\u54c1\u201d\u3001\u201c\u56fd\u5bb6\u5730\u533a\u201d\u3001\u201c\u7701\u201d\u3001\u201c\u5e02\u201d\u3001\u201c\u533a\u201d\u3001\u201c\u53d1\u8d27\u95e8\u5e97\u201d\u3001\u201c\u95e8\u5e97\u4ed3\u5e93\u201d\u3001\u201c\u4f18\u5148\u7ea7\u201d\u3001\u201c\u914d\u9001\u6a21\u5f0f\u201d\u3001\u201c\u53d1\u8d27\u5e93\u5b58\u7ec4\u7ec7\u201d\u3001\u201c\u4ed3\u5e93\u201d\u5747\u5df2\u5b58\u5728\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", seq);
                    this.addErrorMessage(dataEntity, strMsg);
                }
            });
        }
    }

    private DynamicObject[] getRulesFromDataBase(List<String> lstData) {
        DynamicObject[] rules;
        IAppCache cache = AppCache.get((String)"dbd");
        String rulesCache = (String)cache.get("dbd_distributionrules", String.class);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"dbd_distributionrules");
        if (StringUtils.isNotBlank((CharSequence)rulesCache)) {
            Object[] data = DynamicObjectSerializeUtil.deserialize((String)rulesCache, (DynamicObjectType)type);
            ArrayList lstRules = new ArrayList(data.length);
            Arrays.stream(data).forEach(x -> lstRules.add((DynamicObject)x));
            rules = lstRules.toArray(new DynamicObject[0]);
        } else {
            QFilter filter = F7Utils.getEnableStatus();
            filter.and("combination", "in", lstData);
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            rules = BusinessDataServiceHelper.load((String)"dbd_distributionrules", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        }
        return rules;
    }
}

