/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.driver;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class DriverSavePlugin
extends MdrBaseOperationServicePlugIn {
    private static final String IDEN_DRIVERID = "driverid";
    private static final String IDEN_DRIVERPHONE = "driverphone";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isdefault");
        fieldKeys.add(IDEN_DRIVERID);
        fieldKeys.add(IDEN_DRIVERPHONE);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject obj : objs = e.getDataEntities()) {
            CheckResult check;
            String driverId = obj.getString(IDEN_DRIVERID);
            String driverPhone = obj.getString(IDEN_DRIVERPHONE);
            if (driverPhone != null && !(check = ValidateUtils.validMobPhone((String)driverPhone)).isSuccess()) {
                throw new KDBizException(check.getMsg());
            }
            if (driverId == null) continue;
            String reg = "([1-9]\\d{13,16}[a-zA-Z0-9]{1})";
            if (!driverId.matches(reg)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u6709\u8bef\uff0c\u8bf7\u8f93\u516515\u4f4d\u621618\u4f4d\u6709\u6548\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"DriverSavePlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter(IDEN_DRIVERID, "=", (Object)driverId);
            qf.and(IDEN_DRIVERPHONE, "=", (Object)driverPhone);
            qf.and("id", "!=", obj.get("id"));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mdr_driver", (String)"id", (QFilter[])qf.toArray());
            if (query.size() <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8eab\u4efd\u8bc1\u548c\u8054\u7cfb\u7535\u8bdd\u76f8\u540c\u7684\u53f8\u673a\uff0c\u4e0d\u4e88\u8bb8\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u786e\u8ba4\u540e", (String)"DriverSavePlugin_1", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] data;
        super.beginOperationTransaction(e);
        for (DynamicObject dyo : data = e.getDataEntities()) {
            DynamicObjectCollection objectCollection = dyo.getDynamicObjectCollection("customerentry");
            for (DynamicObject customerentry : objectCollection) {
                DynamicObject[] load;
                if (!customerentry.getBoolean("isdefault")) continue;
                DynamicObject customer = customerentry.getDynamicObject("customer");
                long customerid = customer.getLong("id");
                QFilter qFilter = new QFilter("customerentry.customer", "=", (Object)customerid);
                qFilter.and("customerentry.id", "!=", customerentry.get("id"));
                for (DynamicObject dydriver : load = BusinessDataServiceHelper.load((String)"mdr_driver", (String)"customerentry.isdefault,customerentry.customer", (QFilter[])qFilter.toArray())) {
                    DynamicObjectCollection customerentrys = dydriver.getDynamicObjectCollection("customerentry");
                    for (DynamicObject customerentry2 : customerentrys) {
                        if (customerid != customerentry2.getLong("customer.id")) continue;
                        customerentry2.set("isdefault", (Object)Boolean.FALSE);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])load);
            }
        }
    }
}

