/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.inventory;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.status.PhoneType;
import kd.drp.mdr.common.util.ValidateUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class CustomerAddressOperationPlugIn
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("email");
        fieldKeys.add("fixedtel");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.defaultBaseSave(e);
    }

    protected String[] setDefaultFields() {
        return new String[]{"customer"};
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        DynamicObject[] dyos = e.getDataEntities();
        if (dyos == null) {
            return;
        }
        for (DynamicObject dyo : dyos) {
            CheckResult check;
            String email = dyo.getString("email");
            String fixedtel = dyo.getString("fixedtel");
            if (StringUtils.isNotEmpty((String)email) && !ValidateUtils.checkEmail((String)email)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"CustomerAddressOperationPlugIn_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isNotEmpty((String)fixedtel) || (check = ValidateUtils.validPhoneNum((PhoneType)PhoneType.TEL, (String)fixedtel)).isSuccess()) continue;
            throw new KDBizException(check.getMsg());
        }
    }
}

