/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemCombinationSavePlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pricemode");
        e.getFieldKeys().add("itemdetail.proportion");
        e.getFieldKeys().add("isdefault");
        e.getFieldKeys().add("subgroup");
        e.getFieldKeys().add("issubgroup");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject combination : e.getDataEntities()) {
            if (combination.getBoolean("issubgroup") || 2 != Integer.parseInt(combination.getString("pricemode"))) continue;
            BigDecimal totalproportion = BigDecimal.ZERO;
            for (DynamicObject entry : combination.getDynamicObjectCollection("itemdetail")) {
                totalproportion = totalproportion.add(entry.getBigDecimal("proportion"));
            }
            if (totalproportion.compareTo(BigDecimal.valueOf(100L)) == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6bd4\u4f8b\u5b9a\u4ef7\u65f6\uff0c\u6bd4\u4f8b\u4e4b\u548c\u9700\u7b49\u4e8e\u767e\u5206\u4e4b\u767e", (String)"ItemCombinationSavePlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject combination : e.getDataEntities()) {
            this.saveOrUpdateF7(combination);
        }
    }

    private void saveOrUpdateF7(DynamicObject combination) {
        DynamicObject o = null;
        DynamicObjectCollection items = combination.getDynamicObjectCollection("itemdetail");
        ArrayList<DynamicObject> itemAndCombination = new ArrayList<DynamicObject>();
        for (DynamicObject item : items) {
            item.getString("item");
            item.getPkValue();
            DynamicObject itemValue = null;
            QFilter f = new QFilter("number", "=", item.get("item.number"));
            if (QueryServiceHelper.exists((String)"dpm_itemcombination_f7", (QFilter[])f.toArray())) {
                itemValue = BusinessDataServiceHelper.loadSingle((String)"dpm_itemcombination_f7", (String)"id,iscombination", (QFilter[])f.toArray());
            } else {
                itemValue = BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemcombination_f7");
                itemValue.set("id", item.getPkValue());
            }
            itemValue.set("number", item.get("item.number"));
            itemValue.set("name", item.get("item.name"));
            itemValue.set("iscombination", (Object)Boolean.FALSE);
            itemAndCombination.add(itemValue);
        }
        o = QueryServiceHelper.exists((String)"dpm_itemcombination_f7", (Object)combination.getPkValue()) ? BusinessDataServiceHelper.loadSingle((Object)combination.getPkValue(), (String)"dpm_itemcombination_f7") : BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemcombination_f7");
        o.set("number", combination.get("number"));
        o.set("name", combination.get("name"));
        o.set("id", combination.getPkValue());
        o.set("iscombination", (Object)Boolean.TRUE);
        itemAndCombination.add(o);
        SaveServiceHelper.save((DynamicObject[])itemAndCombination.toArray(new DynamicObject[itemAndCombination.size()]));
    }
}

