/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.opplugin.item.validator.ItemValidator;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class ItemInfoSavePlugin
extends MdrBaseOperationServicePlugIn {
    public static final String OWNER = "owner";
    public static final String ASSISTUNIT = "assistunit";
    public static final String HASATTR = "hasattr";
    public static final String MAXATTR = "maxattr";
    public static final String ATTRINIT = "attrinit";
    public static final String ATTRPANELAP = "attrpanelap";
    public static final String ATTRENTRY = "attrentry";
    public static final String ATTR = "attr";
    public static final String ATTRVALUEENTRY = "attrvalueentry";
    public static final String ATTRVALUE = "attrvalue";
    public static final String ATTRNAME = "attrname";
    public static final String ATTRNUMBER = "attrnumber";
    public static final String PRE_ATTR = "attrvalue";
    public static final String ISONSELL = "isonsell";
    public static final String SELLTIME = "selltime";
    public static final String NEWSELLTIME = "newselltime";
    public static final String UPDATETIME = "updatetime";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ItemValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List dataList = e.getValidExtDataEntities();
        if (this.isFromListPage()) {
            return;
        }
        for (ExtendedDataEntity data : dataList) {
            DynamicObject material;
            DynamicObject item = data.getDataEntity();
            boolean hasattr = item.getBoolean(HASATTR);
            if (hasattr) {
                // empty if block
            }
            if ((material = item.getDynamicObject("material")) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599", (String)"ItemInfoSavePlugin_0", (String)"drp-dbd-opplugin", (Object[])new Object[0]));
            }
            Object materialMasterId = material.get("masterid");
            item.set("materialmasterid", materialMasterId);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] obj;
        super.beginOperationTransaction(e);
        for (DynamicObject o : obj = e.getDataEntities()) {
            String isonsell = o.getString(ISONSELL);
            if ("1".equals(isonsell)) {
                Object newselltime = o.get(NEWSELLTIME);
                if (null == newselltime) {
                    o.set(NEWSELLTIME, (Object)new Date());
                }
                o.set(SELLTIME, (Object)new Date());
            } else {
                o.set(SELLTIME, null);
            }
            o.set(UPDATETIME, (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (this.isFromListPage()) {
            return;
        }
        DynamicObject[] datas = e.getDataEntities();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject item = datas[i];
            boolean hasattr = item.getBoolean(HASATTR);
            if (hasattr) {
                this.saveAttrVaule(item);
            }
            this.saveOrUpdateF7(item);
        }
    }

    private void saveOrUpdateF7(DynamicObject item) {
        DynamicObject o = null;
        o = QueryServiceHelper.exists((String)"dpm_itemcombination_f7", (Object)item.getPkValue()) ? BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"dpm_itemcombination_f7") : BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemcombination_f7");
        o.set("number", item.get("number"));
        o.set("name", item.get("name"));
        o.set("id", item.getPkValue());
        o.set("iscombination", (Object)Boolean.FALSE);
        o.set("baseunit", item.get("baseunit"));
        o.set("modelnum", item.get("modelnum"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
    }

    private void saveAttrVaule(DynamicObject item) {
        DynamicObjectCollection attrEntry = item.getDynamicObjectCollection(ATTRVALUEENTRY);
        DynamicObjectCollection itemAttrs = item.getDynamicObjectCollection(ATTRENTRY);
        int attrsSize = 0;
        if (itemAttrs != null) {
            attrsSize = itemAttrs.size();
        }
        HashSet<Object> attrvalueIds = new HashSet<Object>();
        ArrayList<DynamicObject> newItemAttrvalues = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> oldItemAttrvalues = new ArrayList<DynamicObject>();
        for (DynamicObject attrs : attrEntry) {
            String attrName = attrs.getString(ATTRNAME);
            String attrNumber = attrs.getString(ATTRNUMBER);
            String easNumber = attrs.getString("easnumber");
            DynamicObject attrvalue = attrs.getDynamicObject("attrvalue");
            if (attrvalue != null) {
                Object attrvalueId = attrvalue.get("id");
                attrvalueIds.add(attrvalueId);
                DynamicObject itemAttrvalue = BusinessDataServiceHelper.loadSingle((Object)attrvalueId, (String)"mdr_item_attrvalue", (String)"id,attrseq,easnumber");
                itemAttrvalue.set("attrseq", attrs.get("seq"));
                itemAttrvalue.set("easnumber", (Object)easNumber);
                oldItemAttrvalues.add(itemAttrvalue);
                continue;
            }
            DynamicObject itemAttrvalue = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue");
            itemAttrvalue.set("name", (Object)attrName);
            itemAttrvalue.set("number", (Object)attrNumber);
            itemAttrvalue.set("easnumber", (Object)easNumber);
            itemAttrvalue.set("item", item.get("id"));
            itemAttrvalue.set("attrseq", attrs.get("seq"));
            DynamicObjectCollection attrentity = itemAttrvalue.getDynamicObjectCollection("attrentity");
            for (int i = 0; i < attrsSize; ++i) {
                DynamicObject attr = attrentity.addNew();
                attr.set("attrvalue", attrs.get("attrvalue" + (i + 1)));
                attr.set("seq", (Object)i);
            }
            newItemAttrvalues.add(itemAttrvalue);
        }
        QFilter q = new QFilter("id", "not in", attrvalueIds);
        q.and("item", "=", item.get("id"));
        DeleteServiceHelper.delete((String)"mdr_item_attrvalue", (QFilter[])q.toArray());
        if (newItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newItemAttrvalues.toArray(new DynamicObject[0]));
        }
        if (oldItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])oldItemAttrvalues.toArray(new DynamicObject[0]));
        }
    }
}

