/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.common.util.StoreUtils;
import kd.drp.dbd.opplugin.item.validator.ItemPriceChangeValidator;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import org.apache.log4j.Logger;

public class ItemPriceChangeOp
extends MdrBaseOperationServicePlugIn {
    private Logger logger = Logger.getLogger(ItemPriceChangeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("createorg");
        fieldKeys.add("currency");
        fieldKeys.add("billstatus");
        fieldKeys.add("customer_entry");
        fieldKeys.add("customergroupid");
        fieldKeys.add("customerid");
        fieldKeys.add("item_entry");
        fieldKeys.add("barcode");
        fieldKeys.add("item");
        fieldKeys.add("materiel");
        fieldKeys.add("auxpty");
        fieldKeys.add("memberprice");
        fieldKeys.add("retailprice");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ItemPriceChangeValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opString = e.getOperationKey();
        Object[] objs = e.getDataEntities();
        switch (opString) {
            case "save": {
                this.saveCheck((DynamicObject[])objs);
                break;
            }
            case "modify": {
                for (Object obj : objs) {
                    if (Status.SAVED.equals(obj.get("billstatus"))) continue;
                    throw new KDBizException("\u53ea\u6709\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u4fee\u6539!");
                }
                break;
            }
            case "submit": {
                this.saveCheck((DynamicObject[])objs);
                SaveServiceHelper.save((IDataEntityType)objs[0].getDataEntityType(), (Object[])objs);
                for (Object obj : objs) {
                    obj = this.getPriceChangeStatus((DynamicObject)obj);
                    if (Status.SAVED.toString().equals(obj.get("billstatus")) || Status.SUBMITED.toString().equals(obj.get("billstatus"))) continue;
                    throw new KDBizException("\u53ea\u6709\u65b0\u589e\u3001\u4fdd\u5b58\u3001\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4!");
                }
                break;
            }
            case "unsubmit": {
                for (Object obj : objs) {
                    obj = this.getPriceChangeStatus((DynamicObject)obj);
                    if (Status.SUBMITED.toString().equals(obj.get("billstatus"))) continue;
                    throw new KDBizException("\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u9500!");
                }
                break;
            }
            case "audit": {
                for (Object obj : objs) {
                    obj = this.getPriceChangeStatus((DynamicObject)obj);
                    if (Status.SUBMITED.toString().equals(obj.get("billstatus"))) continue;
                    throw new KDBizException("\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6838!");
                }
                break;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    private void saveCheck(DynamicObject[] dataEntities) {
        for (DynamicObject itemPrice : dataEntities) {
            DynamicObject createorg = itemPrice.getDynamicObject("createorg");
            DynamicObject currency = itemPrice.getDynamicObject("currency");
            DynamicObjectCollection customer_entry = itemPrice.getDynamicObjectCollection("customer_entry");
            DynamicObjectCollection item_entry = itemPrice.getDynamicObjectCollection("item_entry");
            if (createorg == null) {
                throw new KDBizException("\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (currency == null) {
                throw new KDBizException("\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (customer_entry == null || customer_entry.size() == 0) {
                throw new KDBizException("\u95e8\u5e97\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (item_entry == null || item_entry.size() == 0) {
                throw new KDBizException("\u5546\u54c1\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (DynamicObject entry : item_entry) {
                BigDecimal retailprice = entry.getBigDecimal("retailprice");
                BigDecimal memberprice = entry.getBigDecimal("memberprice");
                if (retailprice == null) {
                    throw new KDBizException("\u96f6\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (memberprice != null) continue;
                throw new KDBizException("\u4f1a\u5458\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opString = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (opString) {
            case "audit": {
                this.saveItemsaleContentChange(objs);
                break;
            }
        }
    }

    private void saveItemsaleContentChange(DynamicObject[] objs) {
        StringBuilder errors = new StringBuilder();
        ArrayList<DynamicObject> successdatas = new ArrayList<DynamicObject>();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject[] contents;
            Object billNo = objs[i].get("billno");
            Object createOrgId = objs[i].getDynamicObject("createorg").getPkValue();
            Object currencyId = objs[i].getDynamicObject("currency").getPkValue();
            DynamicObjectCollection customer_entrys = (DynamicObjectCollection)objs[i].get("customer_entry");
            DynamicObjectCollection barcode_entrys = (DynamicObjectCollection)objs[i].get("item_entry");
            List barcodeIds = barcode_entrys.stream().map(m -> m.getDynamicObject("barcode").getPkValue()).collect(Collectors.toList());
            Set customerIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customerid") != null).map(m -> m.getDynamicObject("customerid").getPkValue()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(customerIds) || customerIds.size() != customer_entrys.size()) {
                List customergroupIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customergroupid") != null).map(m -> m.getDynamicObject("customergroupid").getPkValue()).collect(Collectors.toList());
                QFilter filter = new QFilter("custclassentity.customergroupid", "in", (Object)customergroupIds.toArray());
                filter.and(StoreUtils.getCustomerIsStoreQfiter((Object)createOrgId));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{filter});
                Set group2customerIds = collection.stream().map(m -> m.get("id")).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(customerIds)) {
                    customerIds = group2customerIds;
                } else {
                    customerIds.addAll(group2customerIds);
                }
            }
            QFilter createOrgIdFilter = new QFilter("createorg", "=", createOrgId);
            QFilter currencyIdFilter = new QFilter("currency", "=", currencyId);
            QFilter barcodeIdFilter = new QFilter("barcode", "in", barcodeIds);
            QFilter customerIdFilter = new QFilter("customer", "in", customerIds);
            createOrgIdFilter.and(currencyIdFilter).and(barcodeIdFilter).and(customerIdFilter);
            for (DynamicObject content : contents = BusinessDataServiceHelper.load((String)"dbd_itemsale_content", (String)"createorg,currency,barcode,retailprice,memberprice,customer,customertype", (QFilter[])new QFilter[]{createOrgIdFilter})) {
                Object barcodeId = content.getDynamicObject("barcode").getPkValue();
                BigDecimal oldRetailprice = content.getBigDecimal("retailprice");
                BigDecimal oldMemberprice = content.getBigDecimal("memberprice");
                List records = barcode_entrys.stream().filter(M -> M.getDynamicObject("barcode").getPkValue().equals(barcodeId)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(records) || records.size() != 1) {
                    errors.append("\u5355\u636e:");
                    errors.append(billNo);
                    errors.append(barcodeId);
                    errors.append("\u5339\u914d\u96f6\u552e\u76ee\u5f55\u9519\u8bef\uff0c\u6761\u5f62\u7801\u5339\u914d\u6570\u76ee\u4e0d\u5bf9");
                    continue;
                }
                BigDecimal newRetailprice = ((DynamicObject)records.get(0)).getBigDecimal("retailprice");
                BigDecimal newMemberprice = ((DynamicObject)records.get(0)).getBigDecimal("memberprice");
                content.set("retailprice", (Object)newRetailprice);
                content.set("memberprice", (Object)newMemberprice);
                successdatas.add(content);
            }
        }
        if (!CollectionUtils.isEmpty(successdatas)) {
            try {
                SaveServiceHelper.update((DynamicObject[])successdatas.toArray(new DynamicObject[successdatas.size()]));
                String s = String.format("\u6210\u529f\u4fee\u6539\u96f6\u552e\u7ecf\u8425\u76ee\u5f55\u4ef7\u683c\u6570%s\u6761", successdatas.size());
                this.operationResult.setMessage(s);
            }
            catch (Exception e) {
                errors.append(e.getMessage());
                throw e;
            }
        }
        if (!errors.toString().isEmpty()) {
            this.logger.error((Object)errors.toString());
        }
    }

    private DynamicObject getPriceChangeStatus(DynamicObject obj) {
        return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"dbd_item_pricechange", (String)"id,billno,billstatus");
    }
}

