/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.opplugin.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.dbd.common.util.StoreUtils;
import kd.drp.dbd.opplugin.item.validator.ItemSaleContentPulishValidator;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;
import org.apache.log4j.Logger;

public class ItemSaleContentPublishOp
extends MdrBaseOperationServicePlugIn {
    private Logger logger = Logger.getLogger(ItemSaleContentPublishOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entryentity_customer");
        e.getFieldKeys().add("customergroupid");
        e.getFieldKeys().add("customerid");
        e.getFieldKeys().add("entryentity_item");
        e.getFieldKeys().add("barcode");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("materiel");
        e.getFieldKeys().add("memberprice");
        e.getFieldKeys().add("retailprice");
        e.getFieldKeys().add("retailstate");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ItemSaleContentPulishValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opString = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        switch (opString) {
            case "audit": {
                this.savePublish(objs);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePublish(DynamicObject[] objs) {
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject createOrgId = objs[i].getDynamicObject("createorg");
            DynamicObject currencyId = objs[i].getDynamicObject("currency");
            DynamicObjectCollection customer_entrys = (DynamicObjectCollection)objs[i].get("entryentity_customer");
            DynamicObjectCollection barcode_entrys = (DynamicObjectCollection)objs[i].get("entryentity_item");
            Set customerIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customerid") != null).map(m -> m.getDynamicObject("customerid").getPkValue()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(customerIds) || customerIds.size() != customer_entrys.size()) {
                List customergroupIds = customer_entrys.stream().filter(m -> m.getDynamicObject("customergroupid") != null).map(m -> m.getDynamicObject("customergroupid").getPkValue()).collect(Collectors.toList());
                QFilter filter = new QFilter("custclassentity.customergroupid", "in", (Object)customergroupIds.toArray());
                filter.and(StoreUtils.getCustomerIsStoreQfiter((Object)createOrgId.getPkValue()));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{filter});
                Set group2customerIds = collection.stream().map(m -> m.getString("id")).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(customerIds)) {
                    customerIds = group2customerIds;
                } else {
                    customerIds.addAll(group2customerIds);
                }
            }
            for (Object customerid : customerIds) {
                for (DynamicObject entry : barcode_entrys) {
                    DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"dbd_itemsale_content");
                    object.set("createorg", (Object)createOrgId);
                    object.set("currency", (Object)currencyId);
                    object.set("customer", (Object)DynamicObjectUtils.getDynamicObjectById(customerid, (String)"mdr_customer"));
                    object.set("barcode", entry.get("barcode"));
                    object.set("creator", (Object)RequestContext.get().getUserId());
                    object.set("createtime", (Object)DateUtil.getNowDate());
                    object.set("enable", (Object)Enable.ENABLE);
                    object.set("retailstate", entry.get("retailstate"));
                    object.set("memberprice", entry.get("memberprice"));
                    object.set("retailprice", entry.get("retailprice"));
                    object.set("item", entry.get("item"));
                    datas.add(object);
                }
            }
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"dbd_itemsale_content", (DynamicObject[])datas.toArray(new DynamicObject[0]));
                if (result.getSuccessPkIds().size() < datas.size()) {
                    this.operationResult.setSuccess(false);
                }
                String s = String.format("\u6210\u529f\u53d1\u5e03\u96f6\u552e\u7ecf\u8425\u76ee\u5f55\u6570%s\u6761,\u5931\u8d25%s\u6761", result.getSuccessPkIds().size(), result.getAllErrorOrValidateInfo().size());
                this.operationResult.setMessage(s);
                continue;
            }
            catch (Exception e) {
                this.operationResult.setSuccess(false);
                this.logger.error((Object)"\u96f6\u552e\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                continue;
            }
            finally {
                datas.clear();
            }
        }
    }
}

